/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class CreateTemplateFix
implements LocalQuickFix {
    private static final String DUMMY_NS = "urn:x__dummy__";
    private static final String DUMMY_TAG = "<dummy xmlns='urn:x__dummy__' />";
    private final XmlTag myTag;
    private final String myName;

    public CreateTemplateFix(XmlTag tag, String name) {
        this.myTag = tag;
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = "Create Template '" + this.myName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/CreateTemplateFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Create Template" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/CreateTemplateFix", "getFamilyName"));
        }
        return "Create Template";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/quickfix/CreateTemplateFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/xslt/quickfix/CreateTemplateFix", "applyFix"));
        }
        XmlTag tag = XsltCodeInsightUtil.getTemplateTag((PsiElement)this.myTag, false);
        if (tag == null) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        assert (parentTag != null);
        XmlTag templateTag = parentTag.createChildTag("template", "http://www.w3.org/1999/XSL/Transform", DUMMY_TAG, false);
        templateTag.setAttribute("name", this.myName);
        XmlTag[] arguments = this.myTag.findSubTags("with-param", "http://www.w3.org/1999/XSL/Transform");
        if (arguments.length > 0) {
            XmlTag dummy = templateTag.findFirstSubTag("dummy");
            for (XmlTag arg : arguments) {
                String argName = arg.getAttributeValue("name");
                if (argName == null) continue;
                XmlTag paramTag = parentTag.createChildTag("param", "http://www.w3.org/1999/XSL/Transform", null, false);
                paramTag.setAttribute("name", argName);
                templateTag.addBefore((PsiElement)paramTag, (PsiElement)dummy);
            }
        }
        XmlTag newTemplateTag = (XmlTag)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)templateTag);
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, this.myTag.getContainingFile().getVirtualFile(), newTemplateTag.getTextRange().getStartOffset());
        FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
    }
}

