/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SimpleAttributeReference
implements PsiReference {
    protected final XmlAttribute myAttribute;

    protected SimpleAttributeReference(XmlAttribute attribute) {
        this.myAttribute = attribute;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getTextRange().substring(this.myAttribute.getValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/SimpleAttributeReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement getElement() {
        XmlAttributeValue value = this.myAttribute.getValueElement();
        assert (value != null);
        return value;
    }

    public TextRange getRangeInElement() {
        return this.getTextRange().shiftRight(1);
    }

    public boolean isReferenceTo(PsiElement element) {
        if (this instanceof PsiPolyVariantReference) {
            ResolveResult[] results;
            PsiPolyVariantReference reference = (PsiPolyVariantReference)this;
            for (ResolveResult result : results = reference.multiResolve(false)) {
                if (!Comparing.equal((Object)result.getElement(), (Object)element)) continue;
                return true;
            }
            return false;
        }
        return Comparing.equal((Object)this.resolve(), (Object)element);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/impl/references/SimpleAttributeReference", "bindToElement"));
        }
        throw new UnsupportedOperationException();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myAttribute.setValue(this.getTextRange().replace(this.myAttribute.getValue(), newElementName));
        XmlAttributeValue value = this.myAttribute.getValueElement();
        assert (value != null);
        return value;
    }

    @Nullable
    public final PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.myAttribute.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

            @Nullable
            public PsiElement resolve(@NotNull PsiReference psiReference, boolean b) {
                if (psiReference == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/impl/references/SimpleAttributeReference$1", "resolve"));
                }
                return SimpleAttributeReference.this.resolveImpl();
            }
        }, false, false);
    }

    @Nullable
    protected abstract PsiElement resolveImpl();

    @NotNull
    protected abstract TextRange getTextRange();
}

