/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import icons.XpathIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.xpath.xslt.XsltConfig;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltTreeStructureProvider
implements TreeStructureProvider {
    private final Project myProject;

    public XsltTreeStructureProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/impl/XsltTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/xslt/impl/XsltTreeStructureProvider", "modify"));
        }
        Collection<AbstractTreeNode> l = children;
        int i = 0;
        for (AbstractTreeNode o : children) {
            ProjectViewNode node;
            Object element;
            if (o instanceof ProjectViewNode && (element = (node = (ProjectViewNode)o).getValue()) instanceof PsiFile && XsltSupport.isXsltFile((PsiFile)element)) {
                if (l == children && l.getClass() != ArrayList.class) {
                    l = new ArrayList<AbstractTreeNode>(children);
                }
                XsltFileNode fileNode = new XsltFileNode(this.myProject, (PsiFile)element, settings);
                ((List)l).set(i, fileNode);
            }
            ++i;
        }
        Collection<AbstractTreeNode> collection = l;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltTreeStructureProvider", "modify"));
        }
        return collection;
    }

    @Nullable
    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }

    private static class XsltFileNode
    extends PsiFileNode {
        private final FileAssociationsManager myInstance;
        private final XsltConfig myConfig;

        public XsltFileNode(Project project, PsiFile psiFile, ViewSettings viewSettings) {
            super(project, psiFile, viewSettings);
            this.myInstance = FileAssociationsManager.getInstance(this.myProject);
            this.myConfig = XsltConfig.getInstance();
        }

        public void updateImpl(PresentationData presentationData) {
            super.updateImpl(presentationData);
            PsiFile[] psiFiles = this.myInstance.getAssociationsFor((PsiFile)this.getValue());
            Icon icon = XsltSupport.createXsltIcon(presentationData.getIcon(false));
            if (psiFiles.length > 0) {
                icon = LayeredIcon.create((Icon)icon, (Icon)XpathIcons.Association_small);
            }
            presentationData.setIcon(icon);
        }

        public boolean expandOnDoubleClick() {
            return false;
        }

        public Collection<AbstractTreeNode> getChildrenImpl() {
            PsiFile[] psiFiles;
            if (this.myConfig.isShowLinkedFiles() && (psiFiles = this.myInstance.getAssociationsFor((PsiFile)this.getValue())).length > 0) {
                return ProjectViewNode.wrap(Arrays.asList(psiFiles), (Project)this.myProject, PsiFileNode.class, (ViewSettings)this.getSettings());
            }
            return super.getChildrenImpl();
        }
    }
}

