/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.codeInsight.daemon.ChangeLocalityDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.jetbrains.annotations.NotNull;

public class XsltChangeLocalityDetector
implements ChangeLocalityDetector {
    public PsiElement getChangeHighlightingDirtyScopeFor(@NotNull PsiElement changedElement) {
        if (changedElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/impl/XsltChangeLocalityDetector", "getChangeHighlightingDirtyScopeFor"));
        }
        try {
            if (changedElement instanceof XmlToken && changedElement.getNode().getElementType() == XmlElementType.XML_ATTRIBUTE_VALUE_TOKEN) {
                PsiElement grandParent = changedElement.getParent().getParent();
                if (grandParent instanceof XmlAttribute && XsltSupport.isXPathAttribute((XmlAttribute)grandParent)) {
                    return grandParent;
                }
            } else if (changedElement instanceof XmlTag && XsltSupport.isTemplate((XmlTag)changedElement, false)) {
                return changedElement;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

