/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathLanguageInjector
implements MultiHostInjector {
    private static final Key<Pair<String, TextRange[]>> CACHED_FILES = Key.create((String)"CACHED_FILES");
    private static final TextRange[] EMPTY_ARRAY = new TextRange[0];

    @Nullable
    private static TextRange[] getCachedRanges(XmlAttribute attribute) {
        Pair pair = (Pair)attribute.getUserData(CACHED_FILES);
        if (pair != null) {
            if (!attribute.getValue().equals(pair.getFirst())) {
                attribute.putUserData(CACHED_FILES, null);
                return null;
            }
        } else {
            return null;
        }
        return (TextRange[])pair.getSecond();
    }

    @NotNull
    private synchronized TextRange[] getInjectionRanges(XmlAttribute attribute, XsltChecker.LanguageLevel languageLevel) {
        TextRange[] ranges;
        TextRange[] cachedFiles = XPathLanguageInjector.getCachedRanges(attribute);
        if (cachedFiles != null) {
            if (cachedFiles == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XPathLanguageInjector", "getInjectionRanges"));
            }
            return cachedFiles;
        }
        String value = attribute.getDisplayValue();
        if (value == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XPathLanguageInjector", "getInjectionRanges"));
            }
            return EMPTY_ARRAY;
        }
        if (XsltSupport.mayBeAVT(attribute)) {
            int i;
            SmartList avtRanges = new SmartList();
            int j = 0;
            Lexer lexer = null;
            while ((i = XsltSupport.getAVTOffset(value, j)) != -1) {
                if (lexer == null) {
                    lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(languageLevel.getXPathVersion().getLanguage())).createLexer(attribute.getProject());
                }
                lexer.start((CharSequence)value, i, value.length());
                j = -1;
                while (lexer.getTokenType() != null) {
                    if (lexer.getTokenType() == XPathTokenTypes.RBRACE) {
                        j = lexer.getTokenStart();
                        break;
                    }
                    lexer.advance();
                }
                if (j != -1) {
                    avtRanges.add(AVTRange.create(attribute, i, j + 1, j > i + 1));
                    continue;
                }
                avtRanges.add(AVTRange.create(attribute, i, value.length(), false));
                break;
            }
            ranges = avtRanges.size() > 0 ? avtRanges.toArray(new TextRange[avtRanges.size()]) : EMPTY_ARRAY;
        } else {
            ranges = new TextRange[]{attribute.getValueTextRange()};
        }
        attribute.putUserData(CACHED_FILES, (Object)Pair.create((Object)attribute.getValue(), (Object)ranges));
        if (ranges == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XPathLanguageInjector", "getInjectionRanges"));
        }
        return ranges;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttribute.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XPathLanguageInjector", "elementsToInjectIn"));
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        TextRange[] ranges;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/impl/XPathLanguageInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/xslt/impl/XPathLanguageInjector", "getLanguagesToInject"));
        }
        XmlAttribute attribute = (XmlAttribute)context;
        if (!XsltSupport.isXPathAttribute(attribute)) {
            return;
        }
        XmlAttributeValueImpl value = (XmlAttributeValueImpl)attribute.getValueElement();
        if (value == null) {
            return;
        }
        ASTNode type = value.findChildByType(XmlElementType.XML_ENTITY_REF);
        if (type != null) {
            return;
        }
        XsltChecker.LanguageLevel languageLevel = XsltSupport.getXsltLanguageLevel(attribute.getContainingFile());
        for (TextRange range : ranges = this.getInjectionRanges(attribute, languageLevel)) {
            String prefix;
            TextRange rangeInsideHost;
            if (range instanceof AVTRange) {
                if (((AVTRange)range).myComplete) {
                    rangeInsideHost = range.shiftRight(2).grown(-2);
                    prefix = "";
                } else {
                    rangeInsideHost = range.shiftRight(2).grown(-1);
                    prefix = "{";
                }
            } else {
                rangeInsideHost = range;
                prefix = "";
            }
            if (!value.getTextRange().contains(rangeInsideHost.shiftRight(value.getTextRange().getStartOffset()))) continue;
            registrar.startInjecting(languageLevel.getXPathVersion().getLanguage()).addPlace(prefix, "", (PsiLanguageInjectionHost)value, rangeInsideHost).doneInjecting();
        }
    }

    static final class AVTRange
    extends TextRange {
        final boolean myComplete;

        private AVTRange(int startOffset, int endOffset, boolean iscomplete) {
            super(startOffset, endOffset);
            this.myComplete = iscomplete;
        }

        public static AVTRange create(XmlAttribute attribute, int startOffset, int endOffset, boolean iscomplete) {
            return new AVTRange(attribute.displayToPhysical(startOffset), attribute.displayToPhysical(endOffset), iscomplete);
        }
    }
}

