/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.context;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.context.ContextType;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.FunctionContext;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.context.Xslt2FunctionContext;
import org.intellij.lang.xpath.xslt.context.XsltContextProviderBase;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltFunction;
import org.intellij.lang.xpath.xslt.psi.XsltStylesheet;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Xslt2ContextProvider
extends XsltContextProviderBase {
    public static final ContextType TYPE = ContextType.lookupOrCreate("XSLT2", XPathVersion.V2);
    private static final Key<ParameterizedCachedValue<Map<Pair<QName, Integer>, Function>, XmlFile>> FUNCTIONS = Key.create((String)"XSLT_FUNCTIONS");
    private static final UserDataCache<FunctionContext, XmlFile, Void> functionContextCache = new UserDataCache<FunctionContext, XmlFile, Void>("xslt2FunctionContext"){

        protected FunctionContext compute(final XmlFile xmlFile, Void p) {
            final FunctionContext base = Xslt2FunctionContext.getInstance();
            return new FunctionContext(){

                public Map<Pair<QName, Integer>, Function> getFunctions() {
                    return ContainerUtil.union(base.getFunctions(), (Map)Xslt2ContextProvider.getCustomFunctions(xmlFile));
                }

                @Override
                public boolean allowsExtensions() {
                    return base.allowsExtensions();
                }

                @Override
                public Function resolve(QName name, int argCount) {
                    Function f = base.resolve(name, argCount);
                    if (f == null) {
                        return Xslt2ContextProvider.resolveCustomFunction(xmlFile, name, argCount);
                    }
                    return f;
                }
            };
        }
    };
    private static final UserDataCache<ParameterizedCachedValue<Map<Pair<QName, Integer>, Function>, XmlFile>, XmlFile, Void> ourFunctionCacheProvider = new UserDataCache<ParameterizedCachedValue<Map<Pair<QName, Integer>, Function>, XmlFile>, XmlFile, Void>(){

        protected ParameterizedCachedValue<Map<Pair<QName, Integer>, Function>, XmlFile> compute(XmlFile file, Void p) {
            return CachedValuesManager.getManager((Project)file.getProject()).createParameterizedCachedValue(MyFunctionProvider.INSTANCE, false);
        }
    };

    protected Xslt2ContextProvider(@NotNull XmlElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/context/Xslt2ContextProvider", "<init>"));
        }
        super(contextElement);
    }

    @Override
    @NotNull
    public ContextType getContextType() {
        ContextType contextType = TYPE;
        if (contextType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/Xslt2ContextProvider", "getContextType"));
        }
        return contextType;
    }

    @Override
    protected XPathType getTypeForTag(XmlTag tag, String attribute) {
        if ("select".equals(attribute)) {
            String tagName = tag.getLocalName();
            if ("sequence".equals(tagName)) {
                XPathType declaredType = XsltCodeInsightUtil.getDeclaredType(tag);
                if (declaredType != null) {
                    return declaredType;
                }
                if (XsltSupport.isFunction(tag.getParentTag())) {
                    XsltFunction func = XsltElementFactory.getInstance().wrapElement(tag.getParentTag(), XsltFunction.class);
                    return func.getReturnType();
                }
                return XPath2Type.SEQUENCE;
            }
            if ("value-of".equals(tagName) || "copy-of".equals(tagName) || "for-each".equals(tagName)) {
                return XPath2Type.SEQUENCE;
            }
        } else if ("group-by".equals(attribute)) {
            return XPath2Type.ITEM;
        }
        return super.getTypeForTag(tag, attribute);
    }

    @Override
    @NotNull
    public FunctionContext createFunctionContext() {
        XmlElement contextElement = this.getContextElement();
        FunctionContext functionContext = contextElement != null && contextElement.isValid() ? (FunctionContext)functionContextCache.get((UserDataHolder)((XmlFile)contextElement.getContainingFile()), null) : Xslt2FunctionContext.getInstance();
        if (functionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/Xslt2ContextProvider", "createFunctionContext"));
        }
        return functionContext;
    }

    private static Map<Pair<QName, Integer>, Function> getCustomFunctions(XmlFile file) {
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null && XsltSupport.isXsltRootTag(rootTag)) {
            return (Map)((ParameterizedCachedValue)ourFunctionCacheProvider.get(FUNCTIONS, (UserDataHolder)file, null)).getValue((Object)file);
        }
        return Collections.emptyMap();
    }

    @Nullable
    private static Function resolveCustomFunction(XmlFile file, QName name, int argCount) {
        Map<Pair<QName, Integer>, Function> functions = Xslt2ContextProvider.getCustomFunctions(file);
        Function exactMatch = functions.get(Pair.create((Object)name, (Object)argCount));
        if (exactMatch != null) {
            return exactMatch;
        }
        Function candidate = null;
        for (Pair<QName, Integer> pair : functions.keySet()) {
            if (!((QName)pair.getFirst()).equals(name)) continue;
            candidate = functions.get(pair);
        }
        return candidate;
    }

    private static class MyFunctionProvider
    implements ParameterizedCachedValueProvider<Map<Pair<QName, Integer>, Function>, XmlFile> {
        private static ParameterizedCachedValueProvider<Map<Pair<QName, Integer>, Function>, XmlFile> INSTANCE = new MyFunctionProvider();

        private MyFunctionProvider() {
        }

        public CachedValueProvider.Result<Map<Pair<QName, Integer>, Function>> compute(XmlFile param) {
            Object[] dependencies;
            XsltFunction[] functions;
            XmlTag rootTag = param.getRootTag();
            assert (rootTag != null);
            HashMap<Pair, XsltFunction> candidates = new HashMap<Pair, XsltFunction>();
            for (XsltFunction function : functions = XsltElementFactory.getInstance().wrapElement(rootTag, XsltStylesheet.class).getFunctions()) {
                candidates.put(Pair.create((Object)function.getQName(), (Object)function.getParameters().length), function);
            }
            Collection<XmlFile> data = ResolveUtil.getDependencies(param);
            if (data == null || data.size() == 0) {
                dependencies = new Object[]{param};
            } else {
                data.add(param);
                dependencies = ArrayUtil.toObjectArray(data);
            }
            return CachedValueProvider.Result.create(candidates, (Object[])dependencies);
        }
    }
}

