/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPath2TokenTypes;
import org.intellij.lang.xpath.XPathElementType;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.Parameter;
import org.intellij.lang.xpath.psi.NodeType;
import org.intellij.lang.xpath.psi.PrefixReference;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.QNameElement;
import org.intellij.lang.xpath.psi.XPath2ElementVisitor;
import org.intellij.lang.xpath.psi.XPath2SequenceType;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPath2TypeElement;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunction;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathLocationPath;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathNodeTypeTest;
import org.intellij.lang.xpath.psi.XPathNumber;
import org.intellij.lang.xpath.psi.XPathPredicate;
import org.intellij.lang.xpath.psi.XPathStep;
import org.intellij.lang.xpath.psi.XPathString;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.psi.impl.PrefixedNameImpl;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.psi.impl.XPathNumberImpl;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.ExpressionReplacementFix;
import org.intellij.lang.xpath.xslt.impl.XsltReferenceContributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XPathAnnotator
extends XPath2ElementVisitor
implements Annotator {
    private AnnotationHolder myHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/validation/XPathAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/validation/XPathAnnotator", "annotate"));
        }
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitXPathNodeTest(XPathNodeTest o) {
        ContextProvider contextProvider = o.getXPathContext();
        XPathAnnotator.checkNodeTest(contextProvider, this.myHolder, o);
    }

    @Override
    public void visitXPathStep(XPathStep o) {
        XPathAnnotator.checkSillyStep(this.myHolder, o);
        super.visitXPathStep(o);
    }

    @Override
    public void visitXPathNodeTypeTest(XPathNodeTypeTest o) {
        XPathAnnotator.checkNodeTypeTest(this.myHolder, o);
        this.visitXPathExpression(o);
    }

    @Override
    public void visitXPathFunctionCall(XPathFunctionCall o) {
        ContextProvider contextProvider = o.getXPathContext();
        XPathAnnotator.checkFunctionCall(this.myHolder, o, contextProvider);
        super.visitXPathFunctionCall(o);
    }

    @Override
    public void visitXPathString(XPathString o) {
        XPathAnnotator.checkString(this.myHolder, o);
        super.visitXPathString(o);
    }

    @Override
    public void visitXPathVariableReference(XPathVariableReference o) {
        ContextProvider contextProvider = o.getXPathContext();
        XPathAnnotator.checkVariableReference(this.myHolder, o, contextProvider);
        super.visitXPathVariableReference(o);
    }

    @Override
    public void visitXPath2TypeElement(XPath2TypeElement o) {
        ContextProvider contextProvider = o.getXPathContext();
        XPathAnnotator.checkPrefixReferences(this.myHolder, o, contextProvider);
        if (o.getDeclaredType() == XPathType.UNKNOWN) {
            PsiReference[] references;
            for (PsiReference reference : references = o.getReferences()) {
                if (!(reference instanceof XsltReferenceContributor.SchemaTypeReference) || reference.isSoft() || reference.resolve() != null) continue;
                String message = ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern();
                Annotation annotation = this.myHolder.createErrorAnnotation(reference.getRangeInElement().shiftRight(o.getTextOffset()), message);
                annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        }
        super.visitXPath2TypeElement(o);
    }

    @Override
    public void visitXPathNumber(XPathNumber number) {
        if (number.getXPathVersion() == XPathVersion.V2) {
            IElementType elementType;
            PsiElement leaf = PsiTreeUtil.nextLeaf((PsiElement)number);
            if (leaf != null && (elementType = leaf.getNode().getElementType()) != XPathTokenTypes.STAR && XPath2TokenTypes.KEYWORDS.contains(elementType)) {
                TextRange range = TextRange.create((int)number.getTextRange().getStartOffset(), (int)leaf.getTextRange().getEndOffset());
                Annotation annotation = this.myHolder.createErrorAnnotation(range, "Number literal must be followed by whitespace in XPath 2");
                XPathBinaryExpression expression = (XPathBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)number, XPathBinaryExpression.class, (boolean)true);
                if (expression != null) {
                    XPathBinaryExpression left;
                    XPathExpression rOperand;
                    PsiElement next;
                    XPathExpression lOperand = expression.getLOperand();
                    if (number == lOperand) {
                        XPathExpression rOperand2 = expression.getROperand();
                        if (rOperand2 != null) {
                            String display = number.getText() + " " + expression.getOperationSign();
                            String replacement = display + " " + rOperand2.getText();
                            assert (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression, (PsiElement)XPathChangeUtil.createExpression(expression, replacement)));
                            annotation.registerFix((IntentionAction)new ExpressionReplacementFix(replacement, display, expression));
                        }
                    } else if (number == expression.getROperand() && (next = PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.nextLeaf((PsiElement)expression), XPathExpression.class, (boolean)true)) instanceof XPathBinaryExpression && (rOperand = (left = (XPathBinaryExpression)next).getROperand()) != null && lOperand != null) {
                        String display = number.getText() + " " + left.getOperationSign();
                        String replacement = lOperand.getText() + " " + expression.getOperationSign() + " " + display + " " + rOperand.getText();
                        assert (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)next, (PsiElement)XPathChangeUtil.createExpression(next, replacement)));
                        annotation.registerFix((IntentionAction)new ExpressionReplacementFix(replacement, display, (XPathExpression)next));
                    }
                }
            }
        } else if (((XPathNumberImpl)number).isScientificNotation()) {
            this.myHolder.createErrorAnnotation((PsiElement)number, "Number literals in scientific notation are not allowed in XPath 1.0");
        }
        super.visitXPathNumber(number);
    }

    @Override
    public void visitXPathBinaryExpression(XPathBinaryExpression o) {
        XPathExpression operand = o.getLOperand();
        if (operand != null && o.getXPathVersion() == XPathVersion.V2) {
            XPathElementType operator = o.getOperator();
            if (XPath2TokenTypes.COMP_OPS.contains((IElementType)operator)) {
                if (operand instanceof XPathBinaryExpression && XPath2TokenTypes.COMP_OPS.contains((IElementType)((XPathBinaryExpression)operand).getOperator())) {
                    Annotation annotation = this.myHolder.createErrorAnnotation((PsiElement)o, "Consecutive comparison is not allowed in XPath 2");
                    XPathExpression rOperand = o.getROperand();
                    if (rOperand != null) {
                        String replacement = "(" + operand.getText() + ") " + o.getOperationSign() + " " + rOperand.getText();
                        annotation.registerFix((IntentionAction)new ExpressionReplacementFix(replacement, o));
                    }
                }
                if (XPath2TokenTypes.NODE_COMP_OPS.contains((IElementType)operator)) {
                    this.checkApplicability(o, XPath2Type.NODE);
                } else if (operator == XPath2TokenTypes.WEQ || operator == XPath2TokenTypes.WNE || operator == XPathTokenTypes.EQ || operator == XPathTokenTypes.NE) {
                    this.checkApplicability(o, XPath2Type.NUMERIC, XPath2Type.BOOLEAN, XPath2Type.STRING, XPath2Type.DATE, XPath2Type.TIME, XPath2Type.DATETIME, XPath2Type.DURATION, XPath2Type.HEXBINARY, XPath2Type.BASE64BINARY, XPath2Type.ANYURI, XPath2Type.QNAME);
                } else if (operator == XPath2TokenTypes.WGT || operator == XPath2TokenTypes.WGE || operator == XPath2TokenTypes.WLE || operator == XPath2TokenTypes.WLT || operator == XPathTokenTypes.GT || operator == XPathTokenTypes.GE || operator == XPathTokenTypes.LE || operator == XPathTokenTypes.LT) {
                    this.checkApplicability(o, XPath2Type.NUMERIC, XPath2Type.BOOLEAN, XPath2Type.STRING, XPath2Type.DATE, XPath2Type.TIME, XPath2Type.DATETIME, XPath2Type.DURATION, XPath2Type.ANYURI);
                }
            } else if (XPath2TokenTypes.UNION_OPS.contains((IElementType)operator) || XPath2TokenTypes.INTERSECT_EXCEPT.contains((IElementType)operator)) {
                this.checkApplicability(o, XPath2SequenceType.create(XPath2Type.NODE, XPath2SequenceType.Cardinality.ZERO_OR_MORE));
            } else if (operator == XPath2TokenTypes.TO) {
                this.checkApplicability(o, XPath2Type.INTEGER);
            } else if (operator == XPathTokenTypes.AND || operator == XPathTokenTypes.OR) {
                this.checkApplicability(o, XPath2Type.BOOLEAN);
            } else if (XPathTokenTypes.ADD_OPS.contains((IElementType)operator)) {
                this.checkApplicability(o, XPath2Type.NUMERIC, XPath2Type.DURATION, XPath2Type.DATE, XPath2Type.TIME, XPath2Type.DATETIME);
            } else if (XPath2TokenTypes.MULT_OPS.contains((IElementType)operator)) {
                if (operator == XPath2TokenTypes.IDIV || operator == XPathTokenTypes.MOD) {
                    this.checkApplicability(o, XPath2Type.NUMERIC);
                } else if (operator == XPathTokenTypes.DIV) {
                    this.checkApplicability(o, XPath2Type.NUMERIC, XPath2Type.DURATION);
                } else {
                    assert (operator == XPathTokenTypes.MULT);
                    this.checkApplicability(o, XPath2Type.NUMERIC, XPath2Type.DURATION);
                }
            }
        }
        XPathAnnotator.checkExpression(this.myHolder, o);
        super.visitXPathBinaryExpression(o);
    }

    private void checkApplicability(XPathBinaryExpression o, XPath2Type ... applicableTypes) {
        XPathExpression lOperand = o.getLOperand();
        assert (lOperand != null);
        XPathType leftType = XPath2Type.mapType(lOperand.getType());
        for (XPath2Type applicableType : applicableTypes) {
            if (!XPathType.isAssignable(applicableType, leftType)) continue;
            return;
        }
        this.myHolder.createErrorAnnotation((PsiElement)o, "Operator '" + o.getOperationSign() + "' cannot be applied to expressions of type '" + leftType.getName() + "'");
    }

    @Override
    public void visitXPathExpression(XPathExpression o) {
        XPathAnnotator.checkExpression(this.myHolder, o);
    }

    private static void checkString(AnnotationHolder holder, XPathString string) {
        if (!string.isWellFormed()) {
            holder.createErrorAnnotation((PsiElement)string, "Malformed string literal");
        }
    }

    private static void checkVariableReference(AnnotationHolder holder, XPathVariableReference reference, @NotNull ContextProvider contextProvider) {
        if (contextProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/intellij/lang/xpath/validation/XPathAnnotator", "checkVariableReference"));
        }
        if (reference.resolve() == null) {
            VariableContext variableResolver = contextProvider.getVariableContext();
            if (variableResolver == null) {
                return;
            }
            if (!variableResolver.canResolve()) {
                HashSet<QName> variables;
                VarType[] variablesInScope = variableResolver.getVariablesInScope(reference);
                if (variablesInScope instanceof String[]) {
                    HashSet<String> variables2 = new HashSet<String>(Arrays.asList((String[])variablesInScope));
                    if (!variables2.contains(reference.getReferencedName())) {
                        XPathAnnotator.markUnresolvedVariable(reference, holder);
                    }
                } else if (variablesInScope instanceof QName[] && !(variables = new HashSet<QName>(Arrays.asList((QName[])variablesInScope))).contains(contextProvider.getQName(reference))) {
                    XPathAnnotator.markUnresolvedVariable(reference, holder);
                }
            } else {
                XPathAnnotator.markUnresolvedVariable(reference, holder);
            }
        }
    }

    private static void markUnresolvedVariable(XPathVariableReference reference, AnnotationHolder holder) {
        String referencedName = reference.getReferencedName();
        if (referencedName.length() > 0) {
            TextRange range = reference.getTextRange().shiftRight(1).grown(-1);
            Annotation ann = holder.createErrorAnnotation(range, "Unresolved variable '" + referencedName + "'");
            ann.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            VariableContext variableContext = ContextProvider.getContextProvider(reference).getVariableContext();
            if (variableContext != null) {
                IntentionAction[] fixes;
                for (IntentionAction fix : fixes = variableContext.getUnresolvedVariableFixes(reference)) {
                    ann.registerFix(fix);
                }
            }
        }
    }

    private static void checkSillyStep(AnnotationHolder holder, XPathStep step) {
        XPathNodeTest test;
        XPathNodeTest.PrincipalType principalType;
        XPathNodeTest nodeTest;
        XPathExpression previousStep = step.getPreviousStep();
        if (previousStep instanceof XPathStep && (nodeTest = ((XPathStep)previousStep).getNodeTest()) != null && (principalType = nodeTest.getPrincipalType()) != XPathNodeTest.PrincipalType.ELEMENT && (test = step.getNodeTest()) != null) {
            holder.createWarningAnnotation((PsiElement)test, "Silly location step on " + principalType.getType() + " axis");
        }
    }

    private static void checkFunctionCall(AnnotationHolder holder, XPathFunctionCall call, @NotNull ContextProvider contextProvider) {
        Function functionDecl;
        if (contextProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/intellij/lang/xpath/validation/XPathAnnotator", "checkFunctionCall"));
        }
        ASTNode node = call.getNode().findChildByType(XPathTokenTypes.FUNCTION_NAME);
        if (node == null) {
            return;
        }
        QName name = contextProvider.getQName(call);
        XPathFunction function = call.resolve();
        Function function2 = functionDecl = function != null ? function.getDeclaration() : null;
        if (functionDecl == null) {
            PrefixedNameImpl qName = (PrefixedNameImpl)call.getQName();
            if (call.getQName().getPrefix() != null && contextProvider.getFunctionContext().allowsExtensions()) {
                String extNS;
                PsiReference[] references = call.getReferences();
                if (references.length > 1 && references[1].resolve() == null) {
                    Annotation ann = holder.createErrorAnnotation(qName.getPrefixNode(), "Extension namespace prefix '" + qName.getPrefix() + "' has not been declared");
                    ann.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                } else if (name != null && !StringUtil.isEmpty((String)(extNS = name.getNamespaceURI()))) {
                    Set<Pair<QName, Integer>> pairs = contextProvider.getFunctionContext().getFunctions().keySet();
                    for (Pair<QName, Integer> pair : pairs) {
                        String uri = ((QName)pair.first).getNamespaceURI();
                        if (uri == null || !uri.equals(extNS)) continue;
                        holder.createWarningAnnotation(node, "Unknown function '" + name + "'");
                    }
                }
            } else if (name != null) {
                holder.createWarningAnnotation(node, "Unknown function '" + name + "'");
            } else if (qName.getPrefixNode() != null) {
                Annotation ann = holder.createErrorAnnotation(qName.getPrefixNode(), "Extension namespace prefix '" + qName.getPrefix() + "' has not been declared");
                ann.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        } else {
            XPathExpression[] arguments = call.getArgumentList();
            for (int i = 0; i < arguments.length; ++i) {
                XPathAnnotator.checkArgument(holder, arguments[i], i, functionDecl.getParameters());
            }
            if (arguments.length < functionDecl.getMinArity()) {
                if (functionDecl.getMinArity() == 1) {
                    holder.createErrorAnnotation(node, "Missing argument for function '" + name + "'");
                } else {
                    Parameter last = functionDecl.getParameters()[functionDecl.getParameters().length - 1];
                    String atLeast = last.kind == Parameter.Kind.OPTIONAL || last.kind == Parameter.Kind.VARARG ? "at least " : "";
                    holder.createErrorAnnotation(node, "Function '" + name + "' requires " + atLeast + functionDecl.getMinArity() + " arguments");
                }
            }
        }
    }

    private static void checkArgument(AnnotationHolder holder, XPathExpression argument, int i, Parameter[] parameters) {
        if (i >= parameters.length && (parameters.length <= 0 || parameters[parameters.length - 1].kind != Parameter.Kind.VARARG)) {
            holder.createErrorAnnotation((PsiElement)argument, "Too many arguments");
        }
    }

    private static void checkNodeTypeTest(AnnotationHolder holder, XPathNodeTypeTest test) {
        NodeType nodeType = test.getNodeType();
        if (nodeType == null) {
            return;
        }
        XPathExpression[] arguments = test.getArgumentList();
        if (test.getXPathVersion() == XPathVersion.V2) {
            switch (nodeType) {
                case NODE: 
                case TEXT: 
                case COMMENT: {
                    XPathAnnotator.markExceedingArguments(holder, arguments, 0);
                    break;
                }
                case ELEMENT: 
                case ATTRIBUTE: {
                    XPathAnnotator.checkKindTestArguments(holder, test, true, 0, 2);
                    break;
                }
                case SCHEMA_ELEMENT: 
                case SCHEMA_ATTRIBUTE: {
                    XPathAnnotator.checkKindTestArguments(holder, test, false, 1, 1);
                    break;
                }
                case DOCUMENT_NODE: {
                    NodeType type;
                    if (arguments.length < 1) break;
                    XPathAnnotator.markExceedingArguments(holder, arguments, 1);
                    XPathNodeTypeTest argument = XPathAnnotator.findNodeType(arguments[0]);
                    if (argument != null && ((type = argument.getNodeType()) == NodeType.ELEMENT || type == NodeType.SCHEMA_ELEMENT)) {
                        return;
                    }
                    holder.createErrorAnnotation((PsiElement)arguments[0], "element() or schema-element() expected");
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    PrefixedName argument;
                    if (arguments.length < 1) break;
                    XPathAnnotator.markExceedingArguments(holder, arguments, 1);
                    if (arguments[0] instanceof XPathString || (argument = XPathAnnotator.findQName(arguments[0])) != null && argument.getPrefix() == null && !"*".equals(argument.getLocalName())) break;
                    holder.createErrorAnnotation((PsiElement)arguments[0], "String literal or NCName expected");
                }
            }
        } else {
            if (arguments.length == 0) {
                return;
            }
            if (test.getNodeType() == NodeType.PROCESSING_INSTRUCTION && arguments.length == 1) {
                if (!(arguments[0] instanceof XPathString)) {
                    holder.createErrorAnnotation((PsiElement)arguments[0], "String literal expected");
                }
                return;
            }
            holder.createErrorAnnotation((PsiElement)test, "Invalid number of arguments for node type test '" + nodeType.getType() + "'");
        }
    }

    private static void checkKindTestArguments(AnnotationHolder holder, XPathNodeTypeTest test, boolean wildcardAllowed, int min, int max) {
        XPathExpression[] arguments = test.getArgumentList();
        if (arguments.length >= min) {
            for (XPathExpression arg : arguments) {
                PrefixedName argument = XPathAnnotator.findQName(arg);
                if (argument == null) {
                    holder.createErrorAnnotation((PsiElement)arg, "QName expected");
                    continue;
                }
                if (wildcardAllowed || !"*".equals(argument.getPrefix()) && !"*".equals(argument.getLocalName())) continue;
                holder.createErrorAnnotation((PsiElement)arg, "QName expected");
            }
        } else {
            holder.createErrorAnnotation((PsiElement)test, "Missing argument for node kind test");
        }
        XPathAnnotator.markExceedingArguments(holder, arguments, max);
    }

    private static void markExceedingArguments(AnnotationHolder holder, XPathExpression[] arguments, int start) {
        for (int i = start; i < arguments.length; ++i) {
            holder.createErrorAnnotation((PsiElement)arguments[i], "Too many arguments");
        }
    }

    @Nullable
    private static XPathNodeTypeTest findNodeType(XPathExpression argument) {
        XPathNodeTest test = XPathAnnotator.findNodeTest(argument);
        if (test != null && !test.isNameTest() && test.getPrincipalType() == XPathNodeTest.PrincipalType.ELEMENT) {
            return (XPathNodeTypeTest)PsiTreeUtil.getChildOfType((PsiElement)test, XPathNodeTypeTest.class);
        }
        return null;
    }

    @Nullable
    private static PrefixedName findQName(XPathExpression argument) {
        XPathNodeTest test = XPathAnnotator.findNodeTest(argument);
        if (test != null && test.isNameTest() && test.getPrincipalType() == XPathNodeTest.PrincipalType.ELEMENT) {
            return test.getQName();
        }
        return null;
    }

    @Nullable
    private static XPathNodeTest findNodeTest(XPathExpression argument) {
        XPathNodeTest test;
        XPathStep step;
        if (argument instanceof XPathLocationPath && (step = ((XPathLocationPath)argument).getFirstStep()) != null && step.getPreviousStep() == null && step.getPredicates().length == 0 && (test = step.getNodeTest()) != null) {
            return test;
        }
        return null;
    }

    private static void checkNodeTest(@NotNull ContextProvider myProvider, AnnotationHolder holder, XPathNodeTest nodeTest) {
        if (myProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/validation/XPathAnnotator", "checkNodeTest"));
        }
        XPathAnnotator.checkSillyNodeTest(holder, nodeTest);
        XPathAnnotator.checkPrefixReferences(holder, nodeTest, myProvider);
    }

    private static void checkPrefixReferences(AnnotationHolder holder, QNameElement element, ContextProvider myProvider) {
        PsiReference[] references;
        for (PsiReference reference : references = element.getReferences()) {
            IntentionAction[] fixes;
            PrefixReference pr;
            if (!(reference instanceof PrefixReference) || (pr = (PrefixReference)reference).isSoft() || !pr.isUnresolved()) continue;
            TextRange range = pr.getRangeInElement().shiftRight(pr.getElement().getTextRange().getStartOffset());
            Annotation a = holder.createErrorAnnotation(range, "Unresolved namespace prefix '" + pr.getCanonicalText() + "'");
            a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            NamespaceContext namespaceContext = myProvider.getNamespaceContext();
            PrefixedName qName = element.getQName();
            if (namespaceContext == null || qName == null) continue;
            for (IntentionAction fix : fixes = namespaceContext.getUnresolvedNamespaceFixes(reference, qName.getLocalName())) {
                a.registerFix(fix);
            }
        }
    }

    private static void checkSillyNodeTest(AnnotationHolder holder, XPathNodeTest nodeTest) {
        XPathNodeTypeTest typeTest;
        if (nodeTest.getPrincipalType() != XPathNodeTest.PrincipalType.ELEMENT && (typeTest = (XPathNodeTypeTest)PsiTreeUtil.getChildOfType((PsiElement)nodeTest, XPathNodeTypeTest.class)) != null) {
            holder.createWarningAnnotation((PsiElement)typeTest, "Silly node type test on axis '" + nodeTest.getPrincipalType().getType() + "'");
        }
    }

    @Override
    public void visitXPathPredicate(XPathPredicate o) {
        XPathExpression parentOfType;
        XPathExpression expression = o.getPredicateExpression();
        if (expression instanceof XPathLocationPath && (parentOfType = (XPathExpression)PsiTreeUtil.getParentOfType((PsiElement)o, XPathExpression.class, (boolean)true)) != null && XPath2Type.ANYATOMICTYPE.isAssignableFrom(parentOfType.getType())) {
            this.myHolder.createErrorAnnotation((PsiElement)expression, "Axis step cannot be used here: the context item is an atomic value");
        }
        super.visitXPathPredicate(o);
    }

    private static void checkExpression(AnnotationHolder holder, @NotNull XPathExpression expression) {
        XPathType opType;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/validation/XPathAnnotator", "checkExpression"));
        }
        XPathType expectedType = ExpectedTypeUtil.getExpectedType(expression);
        if (!XPathType.isAssignable(expectedType, opType = ExpectedTypeUtil.mapType(expression, expression.getType()))) {
            holder.createErrorAnnotation((PsiElement)expression, "Expected type '" + expectedType.getName() + "', got '" + opType.getName() + "'");
        }
    }
}

