/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi;

import org.intellij.lang.xpath.psi.XPath2Type;
import org.jetbrains.annotations.NotNull;

public class XPathType {
    public static final XPathType UNKNOWN = new XPathType("unknown", true);
    public static final XPathType ANY = new XPathType("any", true);
    public static final XPathType NUMBER = new XPathType("number", false);
    public static final XPathType BOOLEAN = new XPathType("boolean", false);
    public static final XPathType STRING = new XPathType("string", false);
    public static final XPathType NODESET = new XPathType("nodeset", false);
    protected final String type;
    private final boolean myAbstract;

    protected XPathType(String s, boolean isAbstract) {
        this.type = s;
        this.myAbstract = isAbstract;
    }

    public String toString() {
        return "XPathType: " + this.type;
    }

    public String getName() {
        return this.type;
    }

    public boolean isAbstract() {
        return this.myAbstract;
    }

    public static XPathType getSuperType(XPathType type) {
        return type instanceof XPath2Type ? ((XPath2Type)type).getSuperType() : null;
    }

    public static XPathType fromString(String value) {
        if ("string".equals(value)) {
            return STRING;
        }
        if ("number".equals(value)) {
            return NUMBER;
        }
        if ("boolean".equals(value)) {
            return BOOLEAN;
        }
        if ("nodeset".equals(value)) {
            return NODESET;
        }
        return UNKNOWN;
    }

    public boolean isAssignableFrom(XPathType type) {
        return this.isAbstract() || type.isAbstract() || this != NODESET || type == NODESET;
    }

    public boolean canBePromotedTo(XPathType type) {
        return type != NODESET;
    }

    public static boolean isAssignable(@NotNull XPathType left, @NotNull XPathType type) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/psi/XPathType", "isAssignable"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/psi/XPathType", "isAssignable"));
        }
        if (left instanceof ChoiceType) {
            XPathType[] types;
            for (XPathType t : types = ((ChoiceType)left).getTypes()) {
                if (!XPathType.isAssignable(t, type)) continue;
                return true;
            }
            return false;
        }
        return left.isAssignableFrom(type) || type.canBePromotedTo(left);
    }

    public static final class ChoiceType
    extends XPathType {
        private final XPathType[] myTypes;

        ChoiceType(XPathType[] types, String name) {
            super(name, true);
            this.myTypes = types;
        }

        public static XPathType create(XPathType ... types) {
            StringBuilder name = new StringBuilder();
            for (XPathType type : types) {
                if (name.length() > 0) {
                    name.append(", ");
                }
                name.append(type.getName());
            }
            name.insert(0, "one of ");
            return new ChoiceType(types, name.toString());
        }

        public XPathType[] getTypes() {
            return this.myTypes;
        }

        @Override
        public boolean isAssignableFrom(@NotNull XPathType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/psi/XPathType$ChoiceType", "isAssignableFrom"));
            }
            return false;
        }

        @Override
        public boolean canBePromotedTo(XPathType type) {
            return false;
        }
    }
}

