/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context.functions;

import org.intellij.lang.xpath.psi.XPathType;
import org.jetbrains.annotations.NotNull;

public class Parameter {
    public final XPathType type;
    public final Kind kind;

    public Parameter(@NotNull XPathType type, @NotNull Kind kind) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/context/functions/Parameter", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/context/functions/Parameter", "<init>"));
        }
        this.type = type;
        this.kind = kind;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.getName());
        if (this.kind == Kind.OPTIONAL) {
            sb.append("?");
        }
        if (this.kind == Kind.VARARG) {
            sb.append("*");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.kind != parameter.kind) {
            return false;
        }
        return this.type.equals(parameter.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.kind.hashCode();
        return result;
    }

    public static enum Kind {
        REQUIRED,
        OPTIONAL,
        VARARG;

    }
}

