/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.intellij.lang.xpath.XPath2Language;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XPathFile
extends PsiFileBase
implements XPathElement {
    private final XPathFileType myType;

    public XPathFile(FileViewProvider provider, XPathFileType type) {
        super(provider, type.getLanguage());
        this.myType = type;
    }

    @NotNull
    public FileType getFileType() {
        XPathFileType xPathFileType = this.myType;
        if (xPathFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathFile", "getFileType"));
        }
        return xPathFileType;
    }

    public String toString() {
        return "XPathFile:" + this.getName() + " {" + this.getText() + "}";
    }

    @Override
    public ContextProvider getXPathContext() {
        return ContextProvider.getContextProvider((PsiFile)this);
    }

    @Nullable
    public XPathExpression getExpression() {
        return (XPathExpression)this.findChildByClass(XPathExpression.class);
    }

    @Override
    public XPathVersion getXPathVersion() {
        return this.getLanguage() instanceof XPath2Language ? XPathVersion.V2 : XPathVersion.V1;
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathFile(this);
    }

    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathFile", "accept"));
        }
        if (visitor instanceof XPathElementVisitor) {
            this.accept((XPathElementVisitor)visitor);
        } else {
            super.accept(visitor);
        }
    }
}

