/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class JavaHLCompositeLog
extends SVNDebugLogAdapter {
    Map myLoggers = new HashMap();

    public void addLogger(ISVNDebugLog debugLog) {
        Boolean needTracing = JavaHLCompositeLog.checkTracing(debugLog);
        this.myLoggers.put(debugLog, needTracing);
    }

    public void removeLogger(ISVNDebugLog debugLog) {
        this.myLoggers.remove(debugLog);
    }

    private static Boolean checkTracing(ISVNDebugLog log) {
        InputStream is = log.createLogStream(SVNLogType.NETWORK, SVNFileUtil.DUMMY_IN);
        OutputStream os = log.createLogStream(SVNLogType.NETWORK, SVNFileUtil.DUMMY_OUT);
        if (is == SVNFileUtil.DUMMY_IN && os == SVNFileUtil.DUMMY_OUT) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public InputStream createLogStream(SVNLogType logType, InputStream is) {
        if (this.myLoggers.containsValue(Boolean.TRUE)) {
            return super.createLogStream(logType, is);
        }
        return is;
    }

    public OutputStream createLogStream(SVNLogType logType, OutputStream os) {
        if (this.myLoggers.containsValue(Boolean.TRUE)) {
            return super.createLogStream(logType, os);
        }
        return os;
    }

    public void log(SVNLogType logType, String message, byte[] data) {
        for (Map.Entry entry : this.myLoggers.entrySet()) {
            ISVNDebugLog log = (ISVNDebugLog)entry.getKey();
            Boolean needTracing = (Boolean)entry.getValue();
            if (!needTracing.booleanValue()) continue;
            log.log(logType, message, data);
        }
    }

    public void log(SVNLogType logType, Throwable th, Level logLevel) {
        for (ISVNDebugLog log : this.myLoggers.keySet()) {
            log.log(logType, th, logLevel);
        }
    }

    public void log(SVNLogType logType, String message, Level logLevel) {
        for (ISVNDebugLog log : this.myLoggers.keySet()) {
            log.log(logType, message, logLevel);
        }
    }
}

