/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.checkout;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.ui.experts.SelectCVSConfigurationStep;
import com.intellij.cvsSupport2.ui.experts.SelectCvsElementStep;
import com.intellij.cvsSupport2.ui.experts.SelectLocationStep;
import com.intellij.cvsSupport2.ui.experts.checkout.ChooseCheckoutMode;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class CheckoutWizard
extends CvsWizard {
    private final SelectCVSConfigurationStep mySelectCVSConfigurationStep;
    private final SelectCvsElementStep mySelectCvsElementStep;
    private final SelectLocationStep mySelectLocationStep;
    private final ChooseCheckoutMode myChooseModeStep;

    public CheckoutWizard(Project project) {
        super(CvsBundle.message((String)"dialog.tittle.check.out.from.cvs.repository", (Object[])new Object[0]), project);
        this.mySelectCVSConfigurationStep = new SelectCVSConfigurationStep(project, (CvsWizard)this);
        this.mySelectCvsElementStep = new SelectCvsElementStep(CvsBundle.message((String)"dialog.title.select.cvs.element.to.check.out", (Object[])new Object[0]), this, project, this.mySelectCVSConfigurationStep, false, 4, true, true);
        this.mySelectLocationStep = new MySelectLocationStep(project);
        this.myChooseModeStep = new ChooseCheckoutMode(this);
        this.addStep((Step)this.mySelectCVSConfigurationStep);
        this.addStep((Step)this.mySelectCvsElementStep);
        this.addStep((Step)this.mySelectLocationStep);
        this.addStep((Step)this.myChooseModeStep);
        this.init();
    }

    @Override
    protected void doOKAction() {
        CvsApplicationLevelConfiguration config = CvsApplicationLevelConfiguration.getInstance();
        config.MAKE_CHECKED_OUT_FILES_READONLY = this.myChooseModeStep.getMakeNewFilesReadOnly();
        config.CHECKOUT_PRUNE_EMPTY_DIRECTORIES = this.myChooseModeStep.getPruneEmptyDirectories();
        KeywordSubstitution keywordSubstitution = this.myChooseModeStep.getKeywordSubstitution();
        config.CHECKOUT_KEYWORD_SUBSTITUTION = keywordSubstitution == null ? null : keywordSubstitution.toString();
        super.doOKAction();
    }

    public CvsElement[] getSelectedElements() {
        return this.mySelectCvsElementStep.getSelectedCvsElements();
    }

    public CvsRootConfiguration getSelectedConfiguration() {
        return this.mySelectCVSConfigurationStep.getSelectedConfiguration();
    }

    public boolean useAlternativeCheckoutLocation() {
        return this.myChooseModeStep.useAlternativeCheckoutLocation();
    }

    public File getCheckoutDirectory() {
        return this.myChooseModeStep.getCheckoutDirectory();
    }

    public File getSelectedLocation() {
        return this.mySelectLocationStep.getSelectedFile();
    }

    @Override
    protected String getHelpID() {
        return "cvs.checkOutPrj";
    }

    private class MySelectLocationStep
    extends SelectLocationStep {
        public MySelectLocationStep(Project project) {
            super(CvsBundle.message((String)"dialog.title.select.check.out.location", (Object[])new Object[0]), CheckoutWizard.this, project, false);
            this.init();
        }
    }
}

