/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsResultEx;
import com.intellij.cvsSupport2.config.AbstractConfiguration;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.DateOrRevisionSettings;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.LocalSettings;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.connections.IDEARootFormatter;
import com.intellij.cvsSupport2.connections.SelfTestingConnection;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetModulesListOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsErrors.ErrorMessagesProcessor;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsListenerWithProgress;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.openapi.cvsIntegration.CvsRepository;
import com.intellij.openapi.cvsIntegration.DateOrRevision;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import java.io.IOException;
import java.util.List;
import org.netbeans.lib.cvsclient.CvsRoot;
import org.netbeans.lib.cvsclient.ValidRequestsExpectedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.progress.DummyProgressViewer;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.util.BugLog;

public class CvsRootConfiguration
extends AbstractConfiguration
implements CvsEnvironment,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.config.CvsRootConfiguration");
    public String CVS_ROOT = "";
    public String PATH_TO_WORKING_FOLDER = "";
    public ProxySettings PROXY_SETTINGS = new ProxySettings();
    public ExtConfiguration EXT_CONFIGURATION = new ExtConfiguration();
    public SshSettings SSH_CONFIGURATION = new SshSettings();
    public SshSettings SSH_FOR_EXT_CONFIGURATION = new SshSettings();
    public LocalSettings LOCAL_CONFIGURATION = new LocalSettings();
    public DateOrRevisionSettings DATE_OR_REVISION_SETTINGS = new DateOrRevisionSettings();
    private static final String SEPARATOR = ":";
    private static final String AT = "@";

    public CvsRootConfiguration() {
        super("CvsRootConfiguration");
    }

    public CvsConnectionSettings createSettings() {
        return new IDEARootFormatter(this).createConfiguration();
    }

    public IConnection createConnection(ReadWriteStatistics statistics) {
        return this.createSettings().createConnection(statistics);
    }

    public String getCvsRootAsString() {
        return this.CVS_ROOT;
    }

    private static String createFieldByFieldCvsRoot(CvsRepository cvsRepository) {
        return CvsRootConfiguration.createStringRepresentationOn(CvsMethod.getValue((String)cvsRepository.getMethod()), cvsRepository.getUser(), cvsRepository.getHost(), cvsRepository.getPort(), cvsRepository.getRepository());
    }

    public static String createStringRepresentationOn(CvsMethod method, String user, String host, int port, String repository) {
        if (method == CvsMethod.LOCAL_METHOD) {
            StringBuilder result = new StringBuilder();
            result.append(SEPARATOR);
            result.append(method.getName());
            result.append(SEPARATOR);
            result.append(repository);
            return result.toString();
        }
        StringBuilder result = new StringBuilder();
        result.append(SEPARATOR);
        result.append(method.getName());
        result.append(SEPARATOR);
        result.append(user);
        result.append(AT);
        result.append(host);
        if (port > 0) {
            result.append(SEPARATOR);
            result.append(port);
        } else {
            result.append(SEPARATOR);
        }
        result.append(repository);
        return result.toString();
    }

    public String toString() {
        if (this.useBranch()) {
            return CvsBundle.message((String)"cvs.root.configuration.on.branch.string.representation", (Object[])new Object[]{this.getCvsRootAsString(), this.DATE_OR_REVISION_SETTINGS.BRANCH});
        }
        if (this.useDate()) {
            return CvsBundle.message((String)"cvs.root.configuration.on.date.string.representation", (Object[])new Object[]{this.getCvsRootAsString(), this.DATE_OR_REVISION_SETTINGS.getDate()});
        }
        return this.getCvsRootAsString();
    }

    private boolean useDate() {
        return this.DATE_OR_REVISION_SETTINGS.USE_DATE && !this.DATE_OR_REVISION_SETTINGS.getDate().isEmpty();
    }

    private boolean useBranch() {
        return this.DATE_OR_REVISION_SETTINGS.USE_BRANCH && !this.DATE_OR_REVISION_SETTINGS.BRANCH.isEmpty();
    }

    public CvsRootConfiguration getMyCopy() {
        try {
            return (CvsRootConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(Project project) throws AuthenticationException, IOException {
        final IConnection connection = this.createSettings().createConnection(new ReadWriteStatistics());
        ErrorMessagesProcessor errorProcessor = new ErrorMessagesProcessor();
        final CvsExecutionEnvironment cvsExecutionEnvironment = new CvsExecutionEnvironment(errorProcessor, CvsExecutionEnvironment.DUMMY_STOPPER, errorProcessor, PostCvsActivity.DEAF, project);
        final CvsResultEx result = new CvsResultEx();
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    GetModulesListOperation operation = new GetModulesListOperation(CvsRootConfiguration.this.createSettings());
                    CvsRootProvider cvsRootProvider = operation.getCvsRootProvider();
                    try {
                        if (connection instanceof SelfTestingConnection) {
                            ((SelfTestingConnection)connection).test(CvsListenerWithProgress.createOnProgress());
                        }
                        operation.execute(cvsRootProvider, cvsExecutionEnvironment, connection, (IProgressViewer)DummyProgressViewer.INSTANCE);
                    }
                    catch (ValidRequestsExpectedException ex) {
                        result.addError(new CvsException(ex, cvsRootProvider.getCvsRootAsString()));
                    }
                    catch (CommandException ex) {
                        result.addError(new CvsException(ex.getUnderlyingException(), cvsRootProvider.getCvsRootAsString()));
                    }
                    catch (ProcessCanceledException ex) {
                        result.setIsCanceled();
                    }
                    catch (BugLog.BugException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (Exception e) {
                        result.addError(new CvsException(e, cvsRootProvider.getCvsRootAsString()));
                    }
                }
            }, CvsBundle.message((String)"operation.name.test.connection", (Object[])new Object[0]), true, null);
            if (result.isCanceled()) {
                throw new ProcessCanceledException();
            }
            if (result.hasErrors()) {
                VcsException vcsException = result.composeError();
                throw new AuthenticationException(vcsException.getLocalizedMessage(), vcsException.getCause());
            }
            List<VcsException> errors = errorProcessor.getErrors();
            if (!errors.isEmpty()) {
                VcsException firstError = errors.get(0);
                throw new AuthenticationException(firstError.getLocalizedMessage(), (Throwable)firstError);
            }
        }
        finally {
            connection.close();
        }
    }

    public int hashCode() {
        int result = this.CVS_ROOT != null ? this.CVS_ROOT.hashCode() : 0;
        result = 31 * result + this.PROXY_SETTINGS.hashCode();
        result = 31 * result + this.EXT_CONFIGURATION.hashCode();
        result = 31 * result + this.SSH_CONFIGURATION.hashCode();
        result = 31 * result + this.SSH_FOR_EXT_CONFIGURATION.hashCode();
        result = 31 * result + this.LOCAL_CONFIGURATION.hashCode();
        result = 31 * result + this.DATE_OR_REVISION_SETTINGS.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CvsRootConfiguration)) {
            return false;
        }
        CvsRootConfiguration another = (CvsRootConfiguration)obj;
        return this.CVS_ROOT.equals(another.CVS_ROOT) && this.DATE_OR_REVISION_SETTINGS.equals((Object)another.DATE_OR_REVISION_SETTINGS) && this.EXT_CONFIGURATION.equals((Object)another.EXT_CONFIGURATION) && this.SSH_CONFIGURATION.equals((Object)another.SSH_CONFIGURATION) && this.SSH_FOR_EXT_CONFIGURATION.equals((Object)another.SSH_FOR_EXT_CONFIGURATION) && this.LOCAL_CONFIGURATION.equals((Object)another.LOCAL_CONFIGURATION) && this.PROXY_SETTINGS.equals((Object)another.PROXY_SETTINGS);
    }

    public CvsLoginWorker getLoginWorker(Project project) {
        return this.createSettings().getLoginWorker(project);
    }

    public RevisionOrDate getRevisionOrDate() {
        return RevisionOrDateImpl.createOn(this.DATE_OR_REVISION_SETTINGS);
    }

    public String getRepository() {
        return this.createSettings().getRepository();
    }

    public CvsRoot getCvsRoot() {
        return this.createSettings().getCvsRoot();
    }

    public boolean isValid() {
        return this.createSettings().isValid();
    }

    public CvsRepository createCvsRepository() {
        CvsConnectionSettings settings = this.createSettings();
        return new CvsRepository(settings.getCvsRootAsString(), settings.METHOD == null ? "" : settings.METHOD.getName(), settings.USER, settings.HOST, settings.REPOSITORY, settings.PORT, (DateOrRevision)this.DATE_OR_REVISION_SETTINGS);
    }

    public static CvsRootConfiguration createOn(CvsRepository repository) {
        CvsRootConfiguration result = CvsApplicationLevelConfiguration.createNewConfiguration(CvsApplicationLevelConfiguration.getInstance());
        result.DATE_OR_REVISION_SETTINGS.updateFrom(repository.getDateOrRevision());
        result.CVS_ROOT = CvsRootConfiguration.createFieldByFieldCvsRoot(repository);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        CvsRootConfiguration result = (CvsRootConfiguration)super.clone();
        result.DATE_OR_REVISION_SETTINGS = this.DATE_OR_REVISION_SETTINGS.clone();
        result.PROXY_SETTINGS = this.PROXY_SETTINGS.clone();
        result.EXT_CONFIGURATION = this.EXT_CONFIGURATION.clone();
        result.SSH_CONFIGURATION = this.SSH_CONFIGURATION.clone();
        result.SSH_FOR_EXT_CONFIGURATION = this.SSH_FOR_EXT_CONFIGURATION.clone();
        result.LOCAL_CONFIGURATION = this.LOCAL_CONFIGURATION.clone();
        return result;
    }

    public CommandException processException(CommandException t) {
        return this.createSettings().processException(t);
    }

    public boolean isOffline() {
        return this.createSettings().isOffline();
    }
}

