/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.checkinProject;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.RestoreFileAction;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsRollbackEnvironment
extends DefaultRollbackEnvironment {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.checkinProject.CvsRollbackEnvironment");
    private final Project myProject;

    public CvsRollbackEnvironment(Project project) {
        this.myProject = project;
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/cvsSupport2/checkinProject/CvsRollbackEnvironment", "rollbackChanges"));
        }
        listener.determinate();
        for (Change change : changes) {
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            listener.accept(change);
            VirtualFile parent = filePath.getVirtualFileParent();
            String name = filePath.getName();
            switch (change.getType()) {
                case DELETED: {
                    this.restoreFile(parent, name);
                    break;
                }
                case MODIFICATION: {
                    this.restoreFile(parent, name);
                    break;
                }
                case MOVED: {
                    CvsUtil.removeEntryFor(CvsVfsUtil.getFileFor(parent, name));
                    break;
                }
                case NEW: {
                    CvsUtil.removeEntryFor(CvsVfsUtil.getFileFor(parent, name));
                }
            }
        }
    }

    public void rollbackMissingFileDeletion(List<FilePath> filePaths, List<VcsException> exceptions, RollbackProgressListener listener) {
        CvsHandler cvsHandler = CommandCvsHandler.createCheckoutFileHandler(filePaths.toArray(new FilePath[filePaths.size()]), CvsConfiguration.getInstance(this.myProject), null);
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(cvsHandler, CvsOperationExecutorCallback.EMPTY);
    }

    private void restoreFile(VirtualFile parent, String name) {
        if (this.restoreFileFromCache(parent, name)) {
            return;
        }
        try {
            new RestoreFileAction(parent, name).actionPerformed(new CvsContextAdapter(){

                @Override
                public Project getProject() {
                    return CvsRollbackEnvironment.this.myProject;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean restoreFileFromCache(VirtualFile parent, String name) {
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(parent, name);
        String revision = entry.getRevision();
        if (revision == null) {
            return false;
        }
        boolean makeReadOnly = CvsConfiguration.getInstance((Project)this.myProject).MAKE_NEW_FILES_READONLY;
        return CvsUtil.restoreFileFromCachedContent(parent, name, revision, makeReadOnly);
    }
}

