/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.changeBrowser.LogInformationWrapper;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsLog.RlogCommand;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.log.LogInformation;

public class LoadHistoryOperation
extends LocalPathIndifferentOperation {
    @NonNls
    private static final String INVALID_OPTION_S = "invalid option -- S";
    @NonNls
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.US));
    private static final Collection<String> ourDoNotSupportingSOptionServers = new HashSet<String>();
    private final String myModule;
    private final Date myDateFrom;
    private final Date myDateTo;
    private final Consumer<LogInformationWrapper> myConsumer;
    private final String[] myRevisions;
    private final boolean myNoTags;

    public LoadHistoryOperation(CvsEnvironment environment, String module, @Nullable Date dateFrom, @Nullable Date dateTo, @NotNull Consumer<LogInformationWrapper> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/cvsSupport2/changeBrowser/LoadHistoryOperation", "<init>"));
        }
        this(environment, consumer, module, dateFrom, dateTo, false, new String[0]);
    }

    public LoadHistoryOperation(CvsEnvironment environment, Consumer<LogInformationWrapper> consumer, String module, String ... revisions) {
        this(environment, consumer, module, null, null, true, revisions);
    }

    private LoadHistoryOperation(CvsEnvironment environment, @NotNull Consumer<LogInformationWrapper> consumer, String module, @Nullable Date dateFrom, @Nullable Date dateTo, boolean noTags, String ... revisions) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/cvsSupport2/changeBrowser/LoadHistoryOperation", "<init>"));
        }
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/cvsSupport2/changeBrowser/LoadHistoryOperation", "<init>"));
        }
        super(environment);
        this.myConsumer = consumer;
        this.myModule = module;
        this.myDateFrom = dateFrom;
        this.myDateTo = dateTo;
        this.myNoTags = noTags;
        this.myRevisions = revisions;
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        RlogCommand command = new RlogCommand();
        command.setModuleName(this.myModule);
        command.setHeadersOnly(false);
        command.setNoTags(this.myNoTags);
        if (this.myDateFrom != null) {
            command.setDateFrom(DATE_FORMAT.format(this.myDateFrom));
        }
        if (this.myDateTo != null) {
            command.setDateTo(DATE_FORMAT.format(this.myDateTo));
        }
        command.setRevisions(this.myRevisions);
        if (ourDoNotSupportingSOptionServers.contains(root.getCvsRootAsString())) {
            command.setSuppressEmptyHeaders(false);
        }
        return command;
    }

    private void disableSuppressEmptyHeadersForCurrentCvsRoot() {
        ourDoNotSupportingSOptionServers.add(this.myEnvironment.getCvsRootAsString());
    }

    @Override
    @NonNls
    protected String getOperationName() {
        return "rlog";
    }

    @Override
    public void fileInfoGenerated(Object info) {
        super.fileInfoGenerated(info);
        if (!(info instanceof LogInformation)) {
            return;
        }
        LogInformation logInfo = (LogInformation)info;
        LogInformationWrapper wrapper = LogInformationWrapper.wrap(this.myEnvironment.getRepository(), this.myModule, logInfo);
        if (wrapper == null) {
            return;
        }
        this.myConsumer.consume((Object)wrapper);
    }

    @Override
    public boolean runInReadThread() {
        return false;
    }

    @Override
    protected boolean runInExclusiveLock() {
        return false;
    }

    public CvsResult run(Project project) {
        CvsResult executionResult = this.internalRun(project);
        for (VcsException error : executionResult.getErrors()) {
            for (String message : error.getMessages()) {
                if (!message.contains(INVALID_OPTION_S)) continue;
                this.disableSuppressEmptyHeadersForCurrentCvsRoot();
                return this.internalRun(project);
            }
        }
        return executionResult;
    }

    private CvsResult internalRun(Project project) {
        CvsOperationExecutor executor = new CvsOperationExecutor(project);
        executor.performActionSync(new CommandCvsHandler(CvsBundle.message((String)"browse.changes.load.history.progress.title", (Object[])new Object[0]), this), CvsOperationExecutorCallback.EMPTY);
        return executor.getResult();
    }
}

