/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.NetxPanel;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletStartupSecuritySettings;
import net.sourceforge.jnlp.splashscreen.SplashController;
import net.sourceforge.jnlp.splashscreen.SplashErrorPanel;
import net.sourceforge.jnlp.splashscreen.SplashPanel;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import sun.applet.AppletAudioClip;
import sun.applet.AppletEvent;
import sun.applet.AppletImageRef;
import sun.applet.AppletListener;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletPanelFactory;
import sun.applet.PluginAppletSecurityContext;
import sun.applet.PluginCallRequest;
import sun.applet.PluginCallRequestFactory;
import sun.applet.PluginDebug;
import sun.applet.PluginMessageConsumer;
import sun.applet.PluginParameterParser;
import sun.applet.PluginStreamHandler;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.XEmbeddedFrame;
import sun.misc.Ref;

public class PluginAppletViewer
extends XEmbeddedFrame
implements AppletContext,
Printable,
SplashController {
    private NetxPanel panel;
    static final ReentrantLock panelLock = new ReentrantLock();
    static final Condition panelLive = panelLock.newCondition();
    private int identifier;
    private static ConcurrentMap<Integer, PluginAppletViewer> applets = new ConcurrentHashMap<Integer, PluginAppletViewer>();
    private static final ReentrantLock appletsLock = new ReentrantLock();
    private static final Condition appletAdded = appletsLock.newCondition();
    private static PluginStreamHandler streamhandler;
    private static PluginCallRequestFactory requestFactory;
    private static ConcurrentMap<Integer, PAV_INIT_STATUS> status;
    private static final ReentrantLock statusLock;
    private static final Condition initComplete;
    private WindowListener windowEventListener = null;
    private AppletEventListener appletEventListener = null;
    public static final long APPLET_TIMEOUT = 180000000000L;
    private static final Object requestMutex;
    private static long requestIdentityCounter;
    private Image bufFrameImg;
    private Graphics bufFrameImgGraphics;
    private SplashPanel splashPanel;
    private static long REQUEST_TIMEOUT;
    private static Map<URL, AudioClip> audioClips;
    private static Map<URL, AppletImageRef> imageRefs;
    private static Vector<NetxPanel> appletPanels;
    static Hashtable<String, String> systemParam;

    private static void waitForRequestCompletion(PluginCallRequest request) {
        try {
            if (!request.isDone()) {
                request.wait(REQUEST_TIMEOUT);
            }
            if (!request.isDone()) {
                throw new RuntimeException("Possible deadlock, releasing");
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted waiting for call request.", ex);
        }
    }

    public PluginAppletViewer() {
    }

    public static PluginAppletViewer framePanel(int identifier, long handle, int width, int height, NetxPanel panel) {
        PluginDebug.debug("Framing ", panel);
        System.getSecurityManager().checkPermission(new AllPermission());
        PluginAppletViewer appletFrame = new PluginAppletViewer(handle, identifier, panel);
        appletFrame.setSize(width, height);
        appletFrame.appletEventListener = new AppletEventListener(appletFrame, appletFrame);
        panel.addAppletListener((AppletListener)appletFrame.appletEventListener);
        if (applets.containsKey(identifier)) {
            PluginAppletViewer oldFrame = (PluginAppletViewer)applets.get(identifier);
            oldFrame.remove((Component)panel);
            panel.removeAppletListener((AppletListener)oldFrame.appletEventListener);
        }
        appletsLock.lock();
        applets.put(identifier, appletFrame);
        appletAdded.signalAll();
        appletsLock.unlock();
        PluginDebug.debug(panel, " framed");
        return appletFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginAppletViewer(long handle, final int identifier, NetxPanel appletPanel) {
        super(handle, true);
        this.identifier = identifier;
        this.panel = appletPanel;
        Vector<NetxPanel> vector = appletPanels;
        synchronized (vector) {
            if (!appletPanels.contains(this.panel)) {
                appletPanels.addElement(this.panel);
            }
        }
        this.windowEventListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PluginAppletViewer.destroyApplet(identifier);
            }

            @Override
            public void windowIconified(WindowEvent evt) {
                PluginAppletViewer.this.appletStop();
            }

            @Override
            public void windowDeiconified(WindowEvent evt) {
                PluginAppletViewer.this.appletStart();
            }
        };
        this.addWindowListener(this.windowEventListener);
        NetxPanel fPanel = this.panel;
        try {
            SwingUtilities.invokeAndWait(new SplashCreator((AppletPanel)fPanel));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void replaceSplash(final SplashPanel newSplash) {
        if (this.splashPanel == null) {
            return;
        }
        if (newSplash == null) {
            this.removeSplash();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PluginAppletViewer.this.splashPanel.getSplashComponent().setVisible(false);
                    PluginAppletViewer.this.splashPanel.stopAnimation();
                    PluginAppletViewer.this.remove(PluginAppletViewer.this.splashPanel.getSplashComponent());
                    newSplash.setPercentage(PluginAppletViewer.this.splashPanel.getPercentage());
                    newSplash.setSplashWidth(PluginAppletViewer.this.splashPanel.getSplashWidth());
                    newSplash.setSplashHeight(PluginAppletViewer.this.splashPanel.getSplashHeight());
                    newSplash.adjustForSize();
                    PluginAppletViewer.this.splashPanel = newSplash;
                    PluginAppletViewer.this.add("Center", PluginAppletViewer.this.splashPanel.getSplashComponent());
                    PluginAppletViewer.this.pack();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeSplash() {
        if (this.splashPanel == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PluginAppletViewer.this.splashPanel.getSplashComponent().setVisible(false);
                    PluginAppletViewer.this.splashPanel.stopAnimation();
                    PluginAppletViewer.this.removeAll();
                    PluginAppletViewer.this.setLayout(new BorderLayout());
                    PluginAppletViewer.this.splashPanel = null;
                    PluginAppletViewer.this.add((Component)PluginAppletViewer.this.panel);
                    PluginAppletViewer.this.panel.setVisible(true);
                    PluginAppletViewer.this.pack();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getSplashWidth() {
        if (this.splashPanel != null) {
            return this.splashPanel.getSplashWidth();
        }
        return -1;
    }

    public int getSplashHeigth() {
        if (this.splashPanel != null) {
            return this.splashPanel.getSplashHeight();
        }
        return -1;
    }

    public static void setStreamhandler(PluginStreamHandler sh) {
        streamhandler = sh;
    }

    public static void setPluginCallRequestFactory(PluginCallRequestFactory rf) {
        requestFactory = rf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleInitializationMessage(int identifier, String message) throws IOException, LaunchException {
        long maxTimeToSleep;
        if (AppletStartupSecuritySettings.getInstance().getSecurityLevel() == AppletSecurityLevel.DENY_ALL) {
            throw new LaunchException(null, null, Translator.R((String)"LSFatal"), Translator.R((String)"LCClient"), Translator.R((String)"LUnsignedApplet"), Translator.R((String)"LUnsignedAppletPolicyDenied"));
        }
        if (PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.PRE_INIT) != null) {
            return;
        }
        String[] msgParts = new String[4];
        for (int i = 0; i < 3; ++i) {
            int spaceLocation = message.indexOf(32);
            int nextSpaceLocation = message.indexOf(32, spaceLocation + 1);
            msgParts[i] = message.substring(spaceLocation + 1, nextSpaceLocation);
            message = message.substring(nextSpaceLocation + 1);
        }
        long handle = Long.parseLong(msgParts[0]);
        String width = msgParts[1];
        String height = msgParts[2];
        int spaceLocation = message.indexOf(32, "tag".length() + 1);
        String documentBase = message.substring("tag".length() + 1, spaceLocation);
        String paramString = message.substring(spaceLocation + 1);
        PluginDebug.debug("Handle = ", handle, "\n", "Width = ", width, "\n", "Height = ", height, "\n", "DocumentBase = ", documentBase, "\n", "Params = ", paramString);
        PluginAppletPanelFactory factory = new PluginAppletPanelFactory();
        AppletMessageHandler amh = new AppletMessageHandler("appletviewer");
        URL url = new URL(documentBase);
        URLConnection conn = url.openConnection();
        url = conn.getURL();
        PluginParameters params = new PluginParameterParser().parse(width, height, paramString);
        streamhandler.write("instance " + identifier + " status " + amh.getMessage("status.start"));
        factory.createPanel(streamhandler, identifier, handle, url, params);
        appletsLock.lock();
        try {
            for (maxTimeToSleep = 180000000000L; !applets.containsKey(identifier) && maxTimeToSleep > 0L; maxTimeToSleep -= PluginAppletViewer.waitTillTimeout(appletsLock, appletAdded, maxTimeToSleep)) {
            }
        }
        finally {
            appletsLock.unlock();
        }
        if (maxTimeToSleep <= 0L) {
            throw new RuntimeException("Applet initialization timeout");
        }
        PluginAppletViewer.waitForAppletInit(((PluginAppletViewer)PluginAppletViewer.applets.get((Object)Integer.valueOf((int)identifier))).panel);
        PluginDebug.debug("Init complete");
        if (PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.REFRAME_COMPLETE).equals((Object)PAV_INIT_STATUS.INACTIVE)) {
            PluginAppletViewer.destroyApplet(identifier);
            return;
        }
    }

    public static void handleMessage(int identifier, int reference, String message) {
        PluginDebug.debug("PAV handling: ", message);
        try {
            if (message.startsWith("handle")) {
                PluginAppletViewer.handleInitializationMessage(identifier, message);
            } else if (message.startsWith("destroy")) {
                PAV_INIT_STATUS previousStatus = PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.INACTIVE);
                PluginDebug.debug("Destroy status set for ", identifier);
                if (previousStatus != null && previousStatus.equals((Object)PAV_INIT_STATUS.REFRAME_COMPLETE)) {
                    PluginAppletViewer.destroyApplet(identifier);
                }
            } else {
                PluginDebug.debug("Handling message: ", message, " instance ", identifier, " ", Thread.currentThread());
                while (!(applets.containsKey(identifier) || status.containsKey(identifier) && !((PAV_INIT_STATUS)((Object)status.get(identifier))).equals((Object)PAV_INIT_STATUS.PRE_INIT))) {
                }
                if (((PAV_INIT_STATUS)((Object)status.get(identifier))).equals((Object)PAV_INIT_STATUS.INACTIVE)) {
                    return;
                }
                ((PluginAppletViewer)applets.get(identifier)).handleMessage(reference, message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.INACTIVE);
            throw new RuntimeException("Failed to handle message: " + message + " for instance " + identifier, e);
        }
    }

    private static synchronized PAV_INIT_STATUS updateStatus(int identifier, PAV_INIT_STATUS newStatus) {
        PAV_INIT_STATUS prev = (PAV_INIT_STATUS)((Object)status.get(identifier));
        if (status.containsKey(identifier)) {
            if (((PAV_INIT_STATUS)((Object)status.get(identifier))).equals((Object)PAV_INIT_STATUS.DESTROYED)) {
                return prev;
            }
            if (((PAV_INIT_STATUS)((Object)status.get(identifier))).equals((Object)PAV_INIT_STATUS.INACTIVE) && !newStatus.equals((Object)PAV_INIT_STATUS.DESTROYED)) {
                return prev;
            }
        }
        statusLock.lock();
        status.put(identifier, newStatus);
        initComplete.signalAll();
        statusLock.unlock();
        return prev;
    }

    private static synchronized void destroyApplet(int identifier) {
        PluginAppletViewer.waitForAppletInit(((PluginAppletViewer)PluginAppletViewer.applets.get((Object)Integer.valueOf((int)identifier))).panel);
        PluginDebug.debug("DestroyApplet called for ", identifier);
        PAV_INIT_STATUS prev = PluginAppletViewer.updateStatus(identifier, PAV_INIT_STATUS.DESTROYED);
        if (prev.equals((Object)PAV_INIT_STATUS.DESTROYED)) {
            PluginDebug.debug(identifier, " already destroyed. Returning.");
            return;
        }
        PluginDebug.debug("Attempting to destroy frame ", identifier);
        final PluginAppletViewer pav = (PluginAppletViewer)applets.get(identifier);
        if (pav != null) {
            pav.dispose();
            if (pav.panel.applet == null) {
                PluginDebug.debug(identifier, " panel inactive. Returning.");
                return;
            }
            PluginDebug.debug("Attempting to destroy panel ", identifier);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pav.appletClose();
                }
            });
        }
        PluginDebug.debug(identifier, " destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAppletInit(NetxPanel panel) {
        PluginDebug.debug("Waiting for applet init");
        panelLock.lock();
        try {
            for (long maxTimeToSleep = 180000000000L; !panel.isInitialized() && maxTimeToSleep > 0L; maxTimeToSleep -= PluginAppletViewer.waitTillTimeout(panelLock, panelLive, maxTimeToSleep)) {
                PluginDebug.debug("Waiting for applet panel ", panel, " to initialize...");
            }
        }
        finally {
            panelLock.unlock();
        }
        PluginDebug.debug("Applet panel ", panel, " initialized");
    }

    public void handleMessage(int reference, String message) {
        if (message.startsWith("width")) {
            PluginAppletViewer.waitForAppletInit(this.panel);
            String[] dimMsg = message.split(" ");
            final int height = Integer.parseInt(dimMsg[3]);
            final int width = Integer.parseInt(dimMsg[1]);
            this.panel.updateSizeInAtts(height, width);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PluginAppletViewer.this.setSize(width, height);
                        PluginAppletViewer.this.panel.setSize(1, 1);
                        PluginAppletViewer.this.panel.validate();
                        PluginAppletViewer.this.panel.setSize(width, height);
                        PluginAppletViewer.this.panel.validate();
                        ((PluginAppletViewer)PluginAppletViewer.this).panel.applet.resize(width, height);
                        ((PluginAppletViewer)PluginAppletViewer.this).panel.applet.validate();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (message.startsWith("GetJavaObject")) {
            PluginAppletViewer.waitForAppletInit(this.panel);
            PluginDebug.debug(this.panel, " -- ", this.panel.getApplet(), " -- initialized: ", this.panel.isInitialized());
            if (this.panel.getApplet() == null) {
                streamhandler.write("instance " + this.identifier + " reference " + -1 + " fatalError: " + "Initialization failed");
                streamhandler.write("context 0 reference " + reference + " Error");
                return;
            }
            Applet o = this.panel.getApplet();
            PluginDebug.debug("Looking for object ", o, " panel is ", this.panel);
            AppletSecurityContextManager.getSecurityContext(0).store(o);
            PluginDebug.debug("WRITING 1: ", "context 0 reference ", reference, " GetJavaObject ", AppletSecurityContextManager.getSecurityContext(0).getIdentifier(o));
            streamhandler.write("context 0 reference " + reference + " GetJavaObject " + AppletSecurityContextManager.getSecurityContext(0).getIdentifier(o));
            PluginDebug.debug("WRITING 1 DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioClip getAudioClip(URL url) {
        PluginAppletViewer.checkConnect(url);
        Map<URL, AudioClip> map = audioClips;
        synchronized (map) {
            AudioClip clip = audioClips.get(url);
            if (clip == null) {
                clip = new AppletAudioClip(url);
                audioClips.put(url, clip);
            }
            return clip;
        }
    }

    @Override
    public Image getImage(URL url) {
        return this.getCachedImage(url);
    }

    private Image getCachedImage(URL url) {
        return (Image)this.getCachedImageRef(url).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Ref getCachedImageRef(URL url) {
        PluginDebug.debug("getCachedImageRef() searching for ", url);
        try {
            String originalURL = url.toString();
            String codeBase = this.panel.getCodeBase().toString();
            if (originalURL.startsWith(codeBase)) {
                PluginDebug.debug("getCachedImageRef() got URL = ", url);
                PluginDebug.debug("getCachedImageRef() plugin codebase = ", codeBase);
                String resourceName = originalURL.substring(codeBase.length());
                JNLPClassLoader loader = (JNLPClassLoader)this.panel.getAppletClassLoader();
                URL localURL = null;
                if (loader.resourceAvailableLocally(resourceName)) {
                    url = loader.getResource(resourceName);
                }
                url = localURL != null ? localURL : url;
            }
            PluginDebug.debug("getCachedImageRef() getting img from URL = ", url);
            Map<URL, AppletImageRef> map = imageRefs;
            synchronized (map) {
                AppletImageRef ref = imageRefs.get(url);
                if (ref == null) {
                    ref = new AppletImageRef(url);
                    imageRefs.put(url, ref);
                }
                return ref;
            }
        }
        catch (Exception e) {
            System.err.println("Error occurred when trying to fetch image:");
            e.printStackTrace();
            return null;
        }
    }

    static void flushImageCache() {
        imageRefs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Applet getApplet(String name) {
        name = name.toLowerCase();
        SocketPermission panelSp = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Vector<NetxPanel> vector = appletPanels;
        synchronized (vector) {
            Enumeration<NetxPanel> e = appletPanels.elements();
            while (e.hasMoreElements()) {
                SocketPermission sp;
                AppletPanel p = (AppletPanel)e.nextElement();
                String param = p.getParameter("name");
                if (param != null) {
                    param = param.toLowerCase();
                }
                if (!name.equals(param) || !p.getDocumentBase().equals(this.panel.getDocumentBase()) || !panelSp.implies(sp = new SocketPermission(p.getCodeBase().getHost(), "connect"))) continue;
                return p.applet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Applet> getApplets() {
        Vector<Applet> v = new Vector<Applet>();
        SocketPermission panelSp = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Vector<NetxPanel> vector = appletPanels;
        synchronized (vector) {
            Enumeration<NetxPanel> e = appletPanels.elements();
            while (e.hasMoreElements()) {
                SocketPermission sp;
                AppletPanel p = (AppletPanel)e.nextElement();
                if (!p.getDocumentBase().equals(this.panel.getDocumentBase()) || !panelSp.implies(sp = new SocketPermission(p.getCodeBase().getHost(), "connect"))) continue;
                v.addElement(p.applet);
            }
        }
        return v.elements();
    }

    @Override
    public void showDocument(URL url) {
        PluginDebug.debug("Showing document...");
        this.showDocument(url, "_self");
    }

    @Override
    public void showDocument(URL url, String target) {
        if ("javascript".equals(url.getProtocol())) {
            String evalString = url.toString().substring("javascript:".length());
            PluginAppletViewer.eval(this.getWindow(), evalString);
            return;
        }
        try {
            Long reference = PluginAppletViewer.getRequestIdentifier();
            this.write("reference " + reference + " LoadURL " + UrlUtil.encode(url.toString(), "UTF-8") + " " + target);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showStatus(String status) {
        try {
            status = status.replace("\n", " ");
            this.write("status " + status);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getRequestIdentifier() {
        Object object = requestMutex;
        synchronized (object) {
            if (requestIdentityCounter == Long.MAX_VALUE) {
                requestIdentityCounter = 0L;
            }
            long l = requestIdentityCounter++;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWindow() {
        PluginDebug.debug("STARTING getWindow");
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("window", "instance " + this.identifier + " reference " + reference + " " + "GetWindow", reference);
        PluginDebug.debug("STARTING postCallRequest");
        streamhandler.postCallRequest(request);
        PluginDebug.debug("STARTING postCallRequest done");
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait request 2");
                while ((Long)request.getObject() == 0L) {
                    request.wait();
                }
                PluginDebug.debug("wait request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug("STARTING getWindow DONE");
        return (Long)request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getMember(long internal, String name) {
        AppletSecurityContextManager.getSecurityContext(0).store(name);
        int nameID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(name);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " GetMember " + internal + " " + nameID, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait getMEM request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait getMEM request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait getMEM request 3 GOT: ", request.getObject().getClass());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" getMember DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMember(long internal, String name, Object value) {
        PluginDebug.debug("Setting to class " + value.getClass() + ":" + value.getClass().isPrimitive());
        PluginAppletSecurityContext securityContext = AppletSecurityContextManager.getSecurityContext(0);
        securityContext.store(name);
        int nameID = securityContext.getIdentifier(name);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        String objIDStr = securityContext.toObjectIDString(value, value.getClass(), true);
        PluginCallRequest request = requestFactory.getPluginCallRequest("void", "instance 0 reference " + reference + " SetMember " + internal + " " + nameID + " " + objIDStr, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait setMem request: ", request.getMessage());
            PluginDebug.debug("wait setMem request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait setMem request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait setMem request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" setMember DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSlot(long internal, int index, Object value) {
        PluginAppletSecurityContext securityContext = AppletSecurityContextManager.getSecurityContext(0);
        securityContext.store(value);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        String objIDStr = securityContext.toObjectIDString(value, value.getClass(), true);
        PluginCallRequest request = requestFactory.getPluginCallRequest("void", "instance 0 reference " + reference + " SetSlot " + internal + " " + index + " " + objIDStr, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait setSlot request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait setSlot request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait setSlot request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" setSlot DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSlot(long internal, int index) {
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " GetSlot " + internal + " " + index, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait getSlot request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait getSlot request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait getSlot request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" getSlot DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object eval(long internal, String s) {
        AppletSecurityContextManager.getSecurityContext(0).store(s);
        int stringID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(s);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " Eval " + internal + " " + stringID, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait eval request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait eval request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait eval request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" getSlot DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMember(long internal, String name) {
        AppletSecurityContextManager.getSecurityContext(0).store(name);
        int nameID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(name);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("void", "instance 0 reference " + reference + " RemoveMember " + internal + " " + nameID, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait removeMember request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait removeMember request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait removeMember request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" RemoveMember DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(long internal, String name, Object[] args) {
        AppletSecurityContextManager.getSecurityContext(0).store(name);
        int nameID = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(name);
        Long reference = PluginAppletViewer.getRequestIdentifier();
        String argIDs = "";
        for (Object arg : args) {
            AppletSecurityContextManager.getSecurityContext(0).store(arg);
            argIDs = argIDs + AppletSecurityContextManager.getSecurityContext(0).getIdentifier(arg) + " ";
        }
        argIDs = argIDs.trim();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " Call " + internal + " " + nameID + " " + argIDs, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait call request 1");
            PluginCallRequest len$ = request;
            synchronized (len$) {
                PluginDebug.debug("wait call request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait call request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" Call DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object requestPluginCookieInfo(URI uri) {
        PluginCallRequest request;
        Long reference = PluginAppletViewer.getRequestIdentifier();
        try {
            String encodedURI = UrlUtil.encode(uri.toString(), "UTF-8");
            request = requestFactory.getPluginCallRequest("cookieinfo", "plugin PluginCookieInfo reference " + reference + " " + encodedURI, reference);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        PluginMessageConsumer.registerPriorityWait(reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait cookieinfo request 1");
            PluginCallRequest e = request;
            synchronized (e) {
                PluginDebug.debug("wait cookieinfo request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait cookieinfo request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for cookieinfo request.", e);
        }
        PluginDebug.debug(" Cookieinfo DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object requestPluginProxyInfo(URI uri) {
        Object port;
        String requestURI = null;
        Long reference = PluginAppletViewer.getRequestIdentifier();
        try {
            String scheme = uri.getScheme();
            Object object = port = uri.getPort() != -1 ? ":" + uri.getPort() : "";
            if (!uri.getScheme().startsWith("http") && !uri.getScheme().equals("ftp")) {
                scheme = "http";
            }
            requestURI = UrlUtil.encode(scheme + "://" + uri.getHost() + (String)port + "/" + uri.getPath(), "UTF-8");
        }
        catch (Exception e) {
            PluginDebug.debug("Cannot construct URL from ", uri.toString(), " ... falling back to DIRECT proxy");
            e.printStackTrace();
            return null;
        }
        PluginCallRequest request = requestFactory.getPluginCallRequest("proxyinfo", "plugin PluginProxyInfo reference " + reference + " " + requestURI, reference);
        PluginMessageConsumer.registerPriorityWait(reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait call request 1");
            port = request;
            synchronized (port) {
                PluginDebug.debug("wait call request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait call request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" Call DONE");
        return request.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void JavaScriptFinalize(long internal) {
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("void", "instance 0 reference " + reference + " Finalize " + internal, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        try {
            PluginDebug.debug("wait finalize request 1");
            PluginCallRequest pluginCallRequest = request;
            synchronized (pluginCallRequest) {
                PluginDebug.debug("wait finalize request 2");
                while (!request.isDone()) {
                    request.wait();
                }
                PluginDebug.debug("wait finalize request 3");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for call request.", e);
        }
        PluginDebug.debug(" finalize DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String javascriptToString(long internal) {
        Long reference = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest request = requestFactory.getPluginCallRequest("member", "instance 0 reference " + reference + " ToString " + internal, reference);
        streamhandler.postCallRequest(request);
        streamhandler.write(request.getMessage());
        PluginDebug.debug("wait ToString request 1");
        PluginCallRequest pluginCallRequest = request;
        synchronized (pluginCallRequest) {
            PluginDebug.debug("wait ToString request 2");
            PluginAppletViewer.waitForRequestCompletion(request);
            PluginDebug.debug("wait ToString request 3");
        }
        PluginDebug.debug(" ToString DONE");
        return (String)request.getObject();
    }

    private void write(String message) throws IOException {
        PluginDebug.debug("WRITING 2: ", "instance ", this.identifier, " " + message);
        streamhandler.write("instance " + this.identifier + " " + message);
        PluginDebug.debug("WRITING 2 DONE");
    }

    @Override
    public void setStream(String key, InputStream stream) throws IOException {
    }

    @Override
    public InputStream getStream(String key) {
        return null;
    }

    @Override
    public Iterator<String> getStreamKeys() {
        return null;
    }

    public void updateAtts() {
        Dimension d = this.panel.getSize();
        Insets in = this.panel.getInsets();
        int width = d.width - (in.left + in.right);
        int height = d.height - (in.top + in.bottom);
        this.panel.updateSizeInAtts(height, width);
    }

    void appletRestart() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    void appletReload() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(0);
        AppletPanel.flushClassLoader((String)this.panel.getClassLoaderCacheKey());
        try {
            this.panel.joinAppletThread();
            this.panel.release();
        }
        catch (InterruptedException e) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PluginAppletViewer.this.panel.createAppletThread();
                return null;
            }
        });
        this.panel.sendEvent(1);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    @Override
    public int print(Graphics graphics, PageFormat pf, int pageIndex) {
        return 1;
    }

    void appletStart() {
        this.panel.sendEvent(3);
    }

    void appletStop() {
        this.panel.sendEvent(4);
    }

    private void appletShutdown(AppletPanel p) {
        p.sendEvent(4);
        p.sendEvent(5);
        p.sendEvent(0);
        p.sendEvent(6);
    }

    void appletClose() {
        NetxPanel p = this.panel;
        new Thread(new Runnable((AppletPanel)p){
            final /* synthetic */ AppletPanel val$p;
            {
                this.val$p = appletPanel;
            }

            @Override
            public void run() {
                ClassLoader cl = this.val$p.applet.getClass().getClassLoader();
                if (cl instanceof JNLPClassLoader.CodeBaseClassLoader) {
                    cl = ((JNLPClassLoader.CodeBaseClassLoader)cl).getParentJNLPClassLoader();
                }
                PluginAppletViewer.this.appletShutdown(this.val$p);
                appletPanels.removeElement(this.val$p);
                ((JNLPClassLoader)cl).decrementLoaderUseCount();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            PluginAppletViewer.this.dispose();
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (PluginAppletViewer.countApplets() == 0) {
                    PluginAppletViewer.this.appletSystemExit();
                }
                PluginAppletViewer.updateStatus(PluginAppletViewer.this.identifier, PAV_INIT_STATUS.DESTROYED);
            }
        }).start();
    }

    private void appletSystemExit() {
    }

    public static int countApplets() {
        return appletPanels.size();
    }

    private static void checkConnect(URL url) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                Permission perm = url.openConnection().getPermission();
                if (perm != null) {
                    security.checkPermission(perm);
                } else {
                    security.checkConnect(url.getHost(), url.getPort());
                }
            }
            catch (IOException ioe) {
                security.checkConnect(url.getHost(), url.getPort());
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.bufFrameImg == null || this.bufFrameImgGraphics == null) {
            this.bufFrameImg = this.createImage(Math.max(1, this.getWidth()), Math.max(1, this.getHeight()));
            this.bufFrameImgGraphics = this.bufFrameImg.getGraphics();
        }
        for (Component c : this.getComponents()) {
            c.paint(this.bufFrameImgGraphics);
        }
        g.drawImage(this.bufFrameImg, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public static long waitTillTimeout(ReentrantLock lock, Condition cond, long timeout) {
        if (lock == null) {
            return 0L;
        }
        assert (lock.isHeldByCurrentThread());
        long sleepStart = 0L;
        try {
            sleepStart = System.nanoTime();
            cond.await(timeout, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return System.nanoTime() - sleepStart;
    }

    static {
        status = new ConcurrentHashMap<Integer, PAV_INIT_STATUS>();
        statusLock = new ReentrantLock();
        initComplete = statusLock.newCondition();
        requestMutex = new Object();
        requestIdentityCounter = 0L;
        REQUEST_TIMEOUT = 60000L;
        audioClips = new HashMap<URL, AudioClip>();
        imageRefs = new HashMap<URL, AppletImageRef>();
        appletPanels = new Vector();
        systemParam = new Hashtable();
        systemParam.put("codebase", "codebase");
        systemParam.put("code", "code");
        systemParam.put("alt", "alt");
        systemParam.put("width", "width");
        systemParam.put("height", "height");
        systemParam.put("align", "align");
        systemParam.put("vspace", "vspace");
        systemParam.put("hspace", "hspace");
    }

    private class SplashCreator
    implements Runnable {
        private final AppletPanel fPanel;

        public SplashCreator(AppletPanel fPanel) {
            this.fPanel = fPanel;
        }

        @Override
        public void run() {
            PluginAppletViewer.this.add("Center", (Component)this.fPanel);
            this.fPanel.setVisible(false);
            PluginAppletViewer.this.splashPanel = SplashUtils.getSplashScreen((int)this.fPanel.getWidth(), (int)this.fPanel.getHeight());
            if (PluginAppletViewer.this.splashPanel != null) {
                PluginAppletViewer.this.splashPanel.startAnimation();
                PluginDebug.debug("Added splash " + PluginAppletViewer.this.splashPanel);
                PluginAppletViewer.this.add("Center", PluginAppletViewer.this.splashPanel.getSplashComponent());
            }
            PluginAppletViewer.this.pack();
        }
    }

    private static class AppletEventListener
    implements AppletListener {
        final Frame frame;
        final PluginAppletViewer appletViewer;

        public AppletEventListener(Frame frame, PluginAppletViewer appletViewer) {
            this.frame = frame;
            this.appletViewer = appletViewer;
        }

        public void appletStateChanged(AppletEvent evt) {
            AppletPanel src = (AppletPanel)evt.getSource();
            panelLock.lock();
            panelLive.signalAll();
            panelLock.unlock();
            switch (evt.getID()) {
                case 51234: {
                    if (src == null) break;
                    this.appletViewer.setSize(this.appletViewer.getPreferredSize());
                    this.appletViewer.validate();
                    break;
                }
                case 51236: {
                    Applet a = src.getApplet();
                    if (a != null) {
                        AppletPanel.changeFrameAppContext((Frame)this.frame, (AppContext)SunToolkit.targetToAppContext(a));
                    } else {
                        AppletPanel.changeFrameAppContext((Frame)this.frame, (AppContext)AppContext.getAppContext());
                    }
                    PluginAppletViewer.updateStatus(this.appletViewer.identifier, PAV_INIT_STATUS.INIT_COMPLETE);
                    break;
                }
                case 3: {
                    if (src.status == 2 || src.status == 4) break;
                    String s = "Applet started, but but reached invalid state";
                    PluginDebug.debug(s);
                    SplashErrorPanel sp = SplashUtils.getErrorSplashScreen((int)this.appletViewer.panel.getWidth(), (int)this.appletViewer.panel.getHeight(), (Throwable)new Exception(s));
                    this.appletViewer.replaceSplash((SplashPanel)sp);
                    break;
                }
                case 7: {
                    String s = "Undefined error causing applet not to staart appeared";
                    PluginDebug.debug(s);
                    SplashErrorPanel sp = SplashUtils.getErrorSplashScreen((int)this.appletViewer.panel.getWidth(), (int)this.appletViewer.panel.getHeight(), (Throwable)new Exception(s));
                    this.appletViewer.replaceSplash((SplashPanel)sp);
                    break;
                }
            }
        }
    }

    private static enum PAV_INIT_STATUS {
        PRE_INIT,
        INIT_COMPLETE,
        REFRAME_COMPLETE,
        INACTIVE,
        DESTROYED;

    }
}

