/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;

public class BasicExceptionDialog {
    private static String exceptionToString(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static void show(Exception exception) {
        String detailsText = BasicExceptionDialog.exceptionToString(exception);
        final JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JOptionPane optionPane = new JOptionPane(mainPanel, 0);
        final JDialog errorDialog = optionPane.createDialog(Translator.R("Error"));
        errorDialog.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        JPanel quickInfoPanel = new JPanel();
        BoxLayout layout = new BoxLayout(quickInfoPanel, 1);
        quickInfoPanel.setLayout(layout);
        mainPanel.add((Component)quickInfoPanel, "First");
        JLabel errorLabel = new JLabel(exception.getMessage());
        errorLabel.setAlignmentY(0.0f);
        quickInfoPanel.add(errorLabel);
        final JButton viewDetails = new JButton(Translator.R("ButShowDetails"));
        viewDetails.setAlignmentY(0.0f);
        viewDetails.setActionCommand("show");
        quickInfoPanel.add(viewDetails);
        JTextArea textArea = new JTextArea();
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.setEditable(false);
        textArea.setText(detailsText);
        final JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(100, 200));
        viewDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (viewDetails.getActionCommand().equals("show")) {
                    mainPanel.add((Component)scrollPane, "Center");
                    viewDetails.setActionCommand("hide");
                    viewDetails.setText(Translator.R("ButHideDetails"));
                    errorDialog.pack();
                } else {
                    mainPanel.remove(scrollPane);
                    viewDetails.setActionCommand("show");
                    viewDetails.setText(Translator.R("ButShowDetails"));
                    errorDialog.pack();
                }
            }
        });
        errorDialog.pack();
        errorDialog.setResizable(true);
        ScreenFinder.centerWindowsToCurrentScreen(errorDialog);
        errorDialog.setVisible(true);
        errorDialog.dispose();
    }
}

