/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.browser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public final class FirefoxPreferencesParser {
    File prefsFile = null;
    Map<String, String> prefs = null;

    public FirefoxPreferencesParser(File preferencesFile) {
        this.prefsFile = preferencesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        this.prefs = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new FileReader(this.prefsFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("user_pref")) continue;
                boolean foundKey = false;
                boolean foundValue = false;
                String pref = line.substring("user_pref(".length(), line.length() - 2);
                int firstCommaPos = pref.indexOf(44);
                if (firstCommaPos < 1) continue;
                String key = pref.substring(0, firstCommaPos).trim();
                if (key.startsWith("\"") && key.endsWith("\"") && (key = key.substring(1, key.length() - 1)).trim().length() > 0) {
                    foundKey = true;
                }
                if (pref.length() <= firstCommaPos + 1) continue;
                String value = pref.substring(firstCommaPos + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1).trim();
                }
                foundValue = true;
                if (!foundKey || !foundValue) continue;
                this.prefs.put(key, value);
            }
        }
        finally {
            reader.close();
        }
        if (JNLPRuntime.isDebug()) {
            System.out.println("Read " + this.prefs.size() + " entries from Firefox's preferences");
        }
    }

    public Map<String, String> getPreferences() {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.putAll(this.prefs);
        return newMap;
    }
}

