/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import net.sourceforge.jnlp.PluginParameterException;
import net.sourceforge.jnlp.runtime.Translator;

public class PluginParameters {
    private final Hashtable<String, String> parameters;

    public PluginParameters(Map<String, String> params) {
        this.parameters = PluginParameters.createParameterTable(params);
        if (this.parameters.get("code") == null && this.parameters.get("object") == null && this.parameters.get("jnlp_href") == null) {
            throw new PluginParameterException(Translator.R("BNoCodeOrObjectApplet"));
        }
    }

    public String get(String key) {
        return this.parameters.get(key);
    }

    public void put(String key, String value) {
        this.parameters.put(key.toLowerCase(), value);
    }

    public Map<String, String> getUnmodifiableMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    Hashtable<String, String> getUnderlyingHashtable() {
        return this.parameters;
    }

    public String getDefaulted(String key, String defaultStr) {
        String value = this.get(key);
        return value != null ? value : defaultStr;
    }

    public String getAppletTitle() {
        String name = this.get("name");
        if (name == null) {
            return "Applet";
        }
        return name + " applet";
    }

    public boolean useCodebaseLookup() {
        return Boolean.valueOf(this.getDefaulted("codebase_lookup", "true"));
    }

    public String getArchive() {
        return this.getDefaulted("archive", "");
    }

    public String getJavaArchive() {
        return this.getDefaulted("java_archive", "");
    }

    public String getJavaArguments() {
        return this.getDefaulted("java_arguments", "");
    }

    public String getCacheArchive() {
        return this.getDefaulted("cache_archive", "");
    }

    public String getCacheArchiveEx() {
        return this.getDefaulted("cache_archive_ex", "");
    }

    public String getCacheOption() {
        return this.getDefaulted("cache_option", "");
    }

    public String getCacheVersion() {
        return this.getDefaulted("cache_version", "");
    }

    public String getCode() {
        return this.getDefaulted("code", "");
    }

    public String getJNLPHref() {
        return this.get("jnlp_href");
    }

    public String getJNLPEmbedded() {
        return this.get("jnlp_embedded");
    }

    public String getJarFiles() {
        return this.getDefaulted("archive", "");
    }

    public int getWidth() {
        String widthStr = this.getDefaulted("width", "0");
        return Integer.valueOf(widthStr);
    }

    public int getHeight() {
        String heightStr = this.getDefaulted("height", "0");
        return Integer.valueOf(heightStr);
    }

    public void updateSize(int width, int height) {
        this.parameters.put("width", Integer.toString(width));
        this.parameters.put("height", Integer.toString(height));
    }

    public String getUniqueKey(URL codebase) {
        return "codebase=" + codebase.toExternalForm() + "cache_archive=" + this.getCacheArchive() + "java_archive=" + this.getJavaArchive() + "archive=" + this.getArchive();
    }

    static void ensureJavaPrefixTakesPrecedence(Map<String, String> params, String attribute) {
        String javaPrefixAttribute = params.get("java_" + attribute);
        if (javaPrefixAttribute != null) {
            params.put(attribute, javaPrefixAttribute);
        }
    }

    static Hashtable<String, String> createParameterTable(Map<String, String> rawParams) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        for (Map.Entry<String, String> entry : rawParams.entrySet()) {
            String key = entry.getKey().toLowerCase();
            String value = entry.getValue();
            params.put(key, value);
        }
        String codeTag = (String)params.get("code");
        String classID = (String)params.get("classid");
        if (codeTag == null && classID != null && !classID.startsWith("clsid:")) {
            codeTag = classID;
            params.put("code", codeTag);
        }
        if (codeTag != null && codeTag.startsWith("java:")) {
            codeTag = codeTag.substring("java:".length());
            params.put("code", codeTag);
        }
        PluginParameters.ensureJavaPrefixTakesPrecedence(params, "code");
        PluginParameters.ensureJavaPrefixTakesPrecedence(params, "codebase");
        PluginParameters.ensureJavaPrefixTakesPrecedence(params, "archive");
        PluginParameters.ensureJavaPrefixTakesPrecedence(params, "object");
        PluginParameters.ensureJavaPrefixTakesPrecedence(params, "type");
        return params;
    }

    public String toString() {
        return this.parameters.toString();
    }
}

