/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.List;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.Translator;

public class JREDesc {
    private final Version version;
    private final URL location;
    private final String initialHeapSize;
    private final String maximumHeapSize;
    private final String vmArgs;
    private final List<ResourcesDesc> resources;

    public JREDesc(Version version, URL location, String vmArgs, String initialHeapSize, String maximumHeapSize, List<ResourcesDesc> resources) throws ParseException {
        this.version = version;
        this.location = location;
        this.vmArgs = vmArgs;
        JREDesc.checkHeapSize(initialHeapSize);
        this.initialHeapSize = initialHeapSize;
        JREDesc.checkHeapSize(maximumHeapSize);
        this.maximumHeapSize = maximumHeapSize;
        this.resources = resources;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isPlatformVersion() {
        return this.getLocation() == null;
    }

    public URL getLocation() {
        return this.location;
    }

    public String getMaximumHeapSize() {
        return this.maximumHeapSize;
    }

    public String getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public List<ResourcesDesc> getResourcesDesc() {
        return this.resources;
    }

    public String getVMArgs() {
        return this.vmArgs;
    }

    private static void checkHeapSize(String heapSize) throws ParseException {
        if (heapSize == null) {
            return;
        }
        boolean lastCharacterIsDigit = true;
        char lastChar = Character.toLowerCase(heapSize.charAt(heapSize.length() - 1));
        if (lastChar < '0' || lastChar > '9') {
            lastCharacterIsDigit = false;
            if (lastChar != 'k' && lastChar != 'm') {
                throw new ParseException(Translator.R("PBadHeapSize", heapSize));
            }
        }
        int indexOfLastDigit = heapSize.length() - 1;
        if (!lastCharacterIsDigit) {
            --indexOfLastDigit;
        }
        String size = heapSize.substring(0, indexOfLastDigit);
        try {
            Integer.valueOf(size);
        }
        catch (NumberFormatException numberFormat) {
            throw new ParseException(Translator.R("PBadHeapSize", heapSize), numberFormat);
        }
    }
}

