#!/bin/sh
export PATH='/usr/obj/hs-scientific-0.3.3.5/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: scientific
version: 0.3.3.5
id: scientific-0.3.3.5-eb2b1e9cf145c4f7aa3b7a8ae1edc34a

license: BSD3
copyright:
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
stability:
homepage: https://github.com/basvandijk/scientific
package-url:
synopsis: Numbers represented using scientific notation
description: @Data.Scientific@ provides a space efficient and arbitrary precision
             scientific number type.
             .
             '\''Scientific'\'' numbers are represented using
             <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>. It
             uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent @e :: '\''Int'\''@ (do
             note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
             aren'\''t truly arbitrary precision). A scientific number corresponds to the
             '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
             .
             The main application of '\''Scientific'\'' is to be used as the target of parsing
             arbitrary precision numbers coming from an untrusted source. The advantages
             over using '\''Rational'\'' for this are that:
             .
             * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
             constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
             '\''denominator'\''.
             .
             * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
             @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
             program. Scientific works as expected:
             .
             > > read "1e1000000000" :: Scientific
             > 1.0e1000000000
             .
             * Also, the space usage of converting scientific numbers with huge exponents to
             @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
             will always be bounded by the target type.
category: Data
author: Bas van Dijk
pkgpath: devel/hs-scientific
exposed: True
exposed-modules: Data.Scientific Data.Text.Lazy.Builder.Scientific
                 Data.ByteString.Builder.Scientific
hidden-modules: Math.NumberTheory.Logarithms
trusted: False
import-dirs: /usr/local/lib/ghc/scientific-0.3.3.5
library-dirs: /usr/local/lib/ghc/scientific-0.3.3.5
hs-libraries: HSscientific-0.3.3.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.5.0.0-470385a50d2b78598af85cfe9d988e1b
         base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         deepseq-1.3.0.2-63a1ab91b7017a28bb5d04cb1b5d2d02
         ghc-prim-0.3.1.0-a24f9c14c632d75b683d0f93283aea37
         hashable-1.2.2.0-6aae2a5ae00dba4cc06a8e388409e9ed
         integer-gmp-0.5.1.0-26579559b3647acf4f01d5edd9491a46
         text-1.1.0.0-72236c81391c0a9a303f37559690d8fe
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-scientific-0.3.3.5/html/scientific.haddock
haddock-html: /usr/local/share/doc/hs-scientific-0.3.3.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
