#!/bin/sh
export PATH='/usr/obj/hs-convertible-1.1.0.0/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: convertible
version: 1.1.0.0
id: convertible-1.1.0.0-887b62ebc9ebf9c4752b8921d6a67093

license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: Nicolas Wu <nicolas.wu@gmail.com>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
synopsis: Typeclasses and instances for converting between types
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen, Nicolas Wu
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/convertible-1.1.0.0
library-dirs: /usr/local/lib/ghc/convertible-1.1.0.0
hs-libraries: HSconvertible-1.1.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         mtl-2.1.3.1-96f1a7910a7553352339ed05fb61c269
         old-locale-1.0.0.6-50b0125c49f76af85dc7aa22975cdc34
         old-time-1.1.0.2-e3f776e97c1a6ff1770b04943a7ef7c6
         text-1.1.0.0-72236c81391c0a9a303f37559690d8fe
         time-1.4.2-311aa8e77a6af87dc3d662d572df62ec
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.1.0.0/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.1.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
