/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    protected float divisionType;
    protected int resolution;
    protected Vector<Track> tracks;
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30 = 30.0f;
    public static final float SMPTE_30DROP = 29.97f;

    private void init(float divisionType, int resolution, int numTracks) throws InvalidMidiDataException {
        if (divisionType != 0.0f && divisionType != 24.0f && divisionType != 25.0f && divisionType != 30.0f && divisionType != 29.97f) {
            throw new InvalidMidiDataException("Invalid division type (" + divisionType + ")");
        }
        this.divisionType = divisionType;
        this.resolution = resolution;
        this.tracks = new Vector(numTracks);
        while (numTracks > 0) {
            this.tracks.set(--numTracks, new Track());
        }
    }

    public Sequence(float divisionType, int resolution) throws InvalidMidiDataException {
        this.init(divisionType, resolution, 0);
    }

    public Sequence(float divisionType, int resolution, int numTracks) throws InvalidMidiDataException {
        this.init(divisionType, resolution, 0);
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Track createTrack() {
        Track track = new Track();
        this.tracks.add(track);
        return track;
    }

    public boolean deleteTrack(Track track) {
        return this.tracks.remove(track);
    }

    public Track[] getTracks() {
        return this.tracks.toArray((S[])new Track[this.tracks.size()]);
    }

    public long getMicrosecondLength() {
        long tickLength = this.getTickLength();
        if (this.divisionType == 0.0f) {
            throw new UnsupportedOperationException("Can't compute PPQ based lengths yet");
        }
        return (long)((float)(tickLength * 1000000L) / (this.divisionType * (float)this.resolution));
    }

    public long getTickLength() {
        long length = 0L;
        for (Track track : this.tracks) {
            long trackTicks = track.ticks();
            if (trackTicks <= length) continue;
            length = trackTicks;
        }
        return length;
    }

    public Patch[] getPatchList() {
        throw new UnsupportedOperationException("Can't get patch list yet");
    }
}

