/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class BacktrackStack {
    Backtrack[] stack = new Backtrack[32];
    private int size = 0;
    private int capacity = 32;
    private static final int INITIAL_CAPACITY = 32;
    private static final int CAPACITY_INCREMENT = 16;

    BacktrackStack() {
    }

    boolean empty() {
        return this.size == 0;
    }

    Backtrack peek() {
        return this.stack[this.size - 1];
    }

    Backtrack pop() {
        Backtrack bt = this.stack[--this.size];
        this.stack[this.size] = null;
        return bt;
    }

    void clear() {
        int i = 0;
        while (i < this.size) {
            this.stack[i] = null;
            ++i;
        }
        this.size = 0;
    }

    void push(Backtrack bt) {
        if (this.size >= this.capacity) {
            this.capacity += 16;
            Backtrack[] newStack = new Backtrack[this.capacity];
            System.arraycopy(this.stack, 0, newStack, 0, this.size);
            this.stack = newStack;
        }
        this.stack[this.size++] = bt;
    }

    static class Backtrack {
        REToken token;
        CharIndexed input;
        REMatch match;
        Object param;

        Backtrack(REToken token, CharIndexed input, REMatch match, Object param) {
            this.token = token;
            this.input = input;
            this.match = (REMatch)match.clone();
            this.param = param;
        }
    }
}

