/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font;

import gnu.java.awt.font.FontDelegate;
import gnu.java.awt.java2d.ShapeWrapper;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GNUGlyphVector
extends GlyphVector {
    private FontDelegate fontDelegate;
    private Font font;
    private FontRenderContext renderContext;
    private int[] glyphs;
    private float fontSize;
    private AffineTransform transform;
    private boolean valid;
    private float[] pos;
    private AffineTransform[] transforms;
    private int layoutFlags;
    private Shape cleanOutline;

    public GNUGlyphVector(FontDelegate fontDelegate, Font font, FontRenderContext renderContext, int[] glyphs) {
        this.fontDelegate = fontDelegate;
        this.font = font;
        this.renderContext = renderContext;
        this.glyphs = glyphs;
        this.fontSize = font.getSize2D();
        this.transform = font.getTransform();
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.renderContext;
    }

    public void performDefaultLayout() {
        Point2D.Float advance = new Point2D.Float();
        this.pos = new float[(this.glyphs.length + 1) * 2];
        float y = 0.0f;
        float x = 0.0f;
        int p = 0;
        p = 0;
        int i = 0;
        while (i < this.glyphs.length) {
            AffineTransform tx;
            p += 2;
            if (this.transforms == null || (tx = this.transforms[i]) == null) {
                tx = this.transform;
            } else {
                tx = new AffineTransform(tx);
                tx.concatenate(this.transform);
            }
            this.fontDelegate.getAdvance(this.glyphs[i], this.fontSize, tx, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), true, advance);
            this.pos[p] = x += (float)Math.round(advance.x);
            this.pos[p + 1] = y += advance.y;
            ++i;
        }
        this.valid = true;
    }

    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    public int getGlyphCode(int glyphIndex) {
        return this.glyphs[glyphIndex];
    }

    public int[] getGlyphCodes(int firstGlyphIndex, int numEntries, int[] outCodes) {
        if (numEntries < 0) {
            throw new IllegalArgumentException();
        }
        if (outCodes == null) {
            outCodes = new int[numEntries];
        }
        System.arraycopy(this.glyphs, firstGlyphIndex, outCodes, 0, numEntries);
        return outCodes;
    }

    public Rectangle2D getLogicalBounds() {
        this.validate();
        return new Rectangle2D.Float(0.0f, 0.0f, this.pos[this.pos.length - 2], this.getAscent() - this.getDescent());
    }

    public Rectangle2D getVisualBounds() {
        this.validate();
        return this.getLogicalBounds();
    }

    public Shape getOutline() {
        return this.getOutline(0.0f, 0.0f);
    }

    public Shape getOutline(float x, float y) {
        Shape outline;
        GeneralPath path;
        this.validate();
        if (this.cleanOutline == null) {
            path = new GeneralPath();
            int len = this.glyphs.length;
            int i = 0;
            while (i < len) {
                GeneralPath p = new GeneralPath(this.getGlyphOutline(i));
                path.append(p, false);
                ++i;
            }
            outline = this.cleanOutline = new ShapeWrapper(path);
        } else {
            outline = this.cleanOutline;
        }
        if (x != 0.0f || y != 0.0f) {
            path = new GeneralPath(outline);
            AffineTransform t = new AffineTransform();
            t.translate(x, y);
            path.transform(t);
            outline = path;
        }
        return outline;
    }

    public Shape getOutline(float x, float y, int type) {
        this.validate();
        GeneralPath outline = new GeneralPath();
        int len = this.glyphs.length;
        int i = 0;
        while (i < len) {
            GeneralPath p = new GeneralPath(this.getGlyphOutline(i, type));
            outline.append(p, false);
            ++i;
        }
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        outline.transform(t);
        return outline;
    }

    public Shape getGlyphOutline(int glyphIndex) {
        AffineTransform tx;
        AffineTransform glyphTx;
        this.validate();
        if (this.transforms != null && (glyphTx = this.transforms[glyphIndex]) != null) {
            tx = new AffineTransform(this.transform);
            tx.concatenate(glyphTx);
        } else {
            tx = this.transform;
        }
        GeneralPath path = this.fontDelegate.getGlyphOutline(this.glyphs[glyphIndex], this.fontSize, tx, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), 1);
        tx = new AffineTransform();
        tx.translate(this.pos[glyphIndex * 2], this.pos[glyphIndex * 2 + 1]);
        path.transform(tx);
        return path;
    }

    public Shape getGlyphOutline(int glyphIndex, int type) {
        AffineTransform tx;
        AffineTransform glyphTx;
        this.validate();
        if (this.transforms != null && (glyphTx = this.transforms[glyphIndex]) != null) {
            tx = new AffineTransform(this.transform);
            tx.concatenate(glyphTx);
        } else {
            tx = this.transform;
        }
        GeneralPath path = this.fontDelegate.getGlyphOutline(this.glyphs[glyphIndex], this.fontSize, tx, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), type);
        tx = new AffineTransform();
        tx.translate(this.pos[glyphIndex * 2], this.pos[glyphIndex * 2 + 1]);
        path.transform(tx);
        return path;
    }

    public Point2D getGlyphPosition(int glyphIndex) {
        this.validate();
        return new Point2D.Float(this.pos[glyphIndex * 2], this.pos[glyphIndex * 2 + 1]);
    }

    public void setGlyphPosition(int glyphIndex, Point2D position) {
        this.validate();
        this.pos[glyphIndex * 2] = (float)position.getX();
        this.pos[glyphIndex * 2 + 1] = (float)position.getY();
    }

    public AffineTransform getGlyphTransform(int glyphIndex) {
        if (this.transforms == null) {
            return null;
        }
        return this.transforms[glyphIndex];
    }

    public void setGlyphTransform(int glyphIndex, AffineTransform transform) {
        if (this.transforms == null) {
            this.transforms = new AffineTransform[this.glyphs.length];
        }
        this.transforms[glyphIndex] = transform;
        if (transform != null) {
            this.layoutFlags |= 1;
        }
        this.valid = false;
    }

    public int getLayoutFlags() {
        return this.layoutFlags;
    }

    public float[] getGlyphPositions(int firstGlyphIndex, int numGlyphs, float[] outPositions) {
        if (numGlyphs < 0) {
            throw new IllegalArgumentException();
        }
        this.validate();
        if (outPositions == null) {
            outPositions = new float[numGlyphs * 2];
        }
        System.arraycopy(this.pos, firstGlyphIndex * 2, outPositions, 0, numGlyphs * 2);
        return outPositions;
    }

    private float getAscent() {
        return this.fontDelegate.getAscent(this.fontSize, this.transform, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), true);
    }

    private float getDescent() {
        return this.fontDelegate.getDescent(this.fontSize, this.transform, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), true);
    }

    public Shape getGlyphLogicalBounds(int glyphIndex) {
        this.validate();
        float ascent = this.getAscent();
        float x = this.pos[glyphIndex * 2];
        float y = this.pos[glyphIndex * 2 + 1];
        return new Rectangle2D.Float(x, y - ascent, this.pos[(glyphIndex + 1) * 2] - x, ascent - this.getDescent());
    }

    public Shape getGlyphVisualBounds(int glyphIndex) {
        return this.getGlyphOutline(glyphIndex).getBounds2D();
    }

    public GlyphMetrics getGlyphMetrics(int glyphIndex) {
        throw new UnsupportedOperationException();
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int glyphIndex) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(GlyphVector other) {
        if (!(other instanceof GNUGlyphVector)) {
            return false;
        }
        GNUGlyphVector o = (GNUGlyphVector)other;
        if (this.font != o.font || this.fontDelegate != o.fontDelegate || this.renderContext != o.renderContext || this.glyphs.length != o.glyphs.length) {
            return false;
        }
        int i = 0;
        while (i < this.glyphs.length) {
            if (this.glyphs[i] != o.glyphs[i]) {
                return false;
            }
            ++i;
        }
        this.validate();
        o.validate();
        i = 0;
        while (i < this.pos.length) {
            if (this.pos[i] != o.pos[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void validate() {
        if (!this.valid) {
            this.performDefaultLayout();
        }
    }
}

