/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.GIOP;

import gnu.CORBA.CDR.AbstractCdrInput;
import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.GIOP.CharSets_OSF;
import gnu.CORBA.GIOP.ServiceContext;
import gnu.CORBA.IOR;
import java.io.IOException;

public class CodeSetServiceContext
extends ServiceContext {
    public static final int ID = 1;
    public static final CodeSetServiceContext STANDARD = new CodeSetServiceContext();
    public int char_data = 65537;
    public int wide_char_data = 65801;

    public static CodeSetServiceContext find(ServiceContext[] contexts) {
        if (contexts != null) {
            int i = 0;
            while (i < contexts.length) {
                if (contexts[i] instanceof CodeSetServiceContext) {
                    return (CodeSetServiceContext)contexts[i];
                }
                ++i;
            }
        }
        return STANDARD;
    }

    public static CodeSetServiceContext negotiate(IOR.CodeSets_profile profile) {
        if (profile.negotiated != null) {
            return profile.negotiated;
        }
        CodeSetServiceContext use = new CodeSetServiceContext();
        use.char_data = CodeSetServiceContext.negotiate(profile.narrow, CodeSetServiceContext.STANDARD.char_data, 65537);
        use.wide_char_data = CodeSetServiceContext.negotiate(profile.wide, CodeSetServiceContext.STANDARD.wide_char_data, 65801);
        profile.negotiated = use;
        return use;
    }

    public void readContext(AbstractCdrInput input) {
        BufferredCdrInput encap = input.read_encapsulation();
        this.char_data = encap.read_ulong();
        this.wide_char_data = encap.read_ulong();
    }

    public String toString() {
        return " Encoding: narrow " + this.name(this.char_data) + ", wide " + this.name(this.wide_char_data) + ". ";
    }

    public void write(AbstractCdrOutput output) {
        output.write_ulong(1);
        AbstractCdrOutput enout = output.createEncapsulation();
        enout.write_long(this.char_data);
        enout.write_ulong(this.wide_char_data);
        try {
            enout.close();
        }
        catch (IOException ex) {
            InternalError t = new InternalError();
            t.initCause(ex);
            throw t;
        }
    }

    protected static int negotiate(IOR.CodeSets_profile.CodeSet_component profile, int our_native, int final_decission) {
        if (profile.native_set == our_native) {
            return our_native;
        }
        if (profile.conversion != null) {
            int i = 0;
            while (i < profile.conversion.length) {
                if (our_native == profile.conversion[i]) {
                    return our_native;
                }
                ++i;
            }
        }
        int[] allSupported = CharSets_OSF.getSupportedCharSets();
        int s = 0;
        while (s < allSupported.length) {
            if (allSupported[s] == profile.native_set) {
                return profile.native_set;
            }
            ++s;
        }
        if (profile.conversion != null) {
            s = 0;
            while (s < allSupported.length) {
                int i = 0;
                while (i < profile.conversion.length) {
                    if (allSupported[s] == profile.conversion[i]) {
                        return allSupported[s];
                    }
                    ++i;
                }
                ++s;
            }
        }
        return final_decission;
    }

    private String name(int set) {
        return "0x" + Integer.toHexString(set) + " (" + CharSets_OSF.getName(set) + ") ";
    }
}

