/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

final class CopyOfNode
extends TemplateNode {
    final Expr select;

    CopyOfNode(Expr select) {
        this.select = select;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        CopyOfNode ret = new CopyOfNode(this.select.clone(stylesheet));
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        Document doc;
        Object ret = this.select.evaluate(context, pos, len);
        Document document = doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        if (ret instanceof Collection) {
            Collection ns = (Collection)ret;
            ArrayList list2 = new ArrayList(ns);
            Collections.sort(list2, documentOrderComparator);
            for (Node src : list2) {
                short nodeType = src.getNodeType();
                if (nodeType == 9) {
                    if ((src = ((Document)src).getDocumentElement()) == null) continue;
                    nodeType = 1;
                } else if (nodeType == 2 && parent.getFirstChild() != null) continue;
                if (parent.getNodeType() == 2 && nodeType != 3 && nodeType != 5) continue;
                Node node2 = src.cloneNode(true);
                node2 = doc.adoptNode(node2);
                if (nodeType == 2) {
                    NamedNodeMap attrs = parent.getAttributes();
                    if (attrs == null) continue;
                    attrs.setNamedItemNS(node2);
                    continue;
                }
                if (nextSibling != null) {
                    parent.insertBefore(node2, nextSibling);
                    continue;
                }
                parent.appendChild(node2);
            }
        } else {
            String value = Expr._string(context, ret);
            if (value != null && value.length() > 0) {
                Text textNode = doc.createTextNode(value);
                if (nextSibling != null) {
                    parent.insertBefore(textNode, nextSibling);
                } else {
                    parent.appendChild(textNode);
                }
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public boolean references(QName var) {
        if (this.select != null && this.select.references(var)) {
            return true;
        }
        return super.references(var);
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder("copy-of");
        buf.append('[');
        buf.append("select=");
        buf.append(this.select);
        buf.append(']');
        return buf.toString();
    }
}

