/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.autofit;

import gnu.java.awt.font.autofit.AxisHints;
import gnu.java.awt.font.autofit.Constants;
import gnu.java.awt.font.autofit.Edge;
import gnu.java.awt.font.autofit.GlyphHints;
import gnu.java.awt.font.autofit.HintScaler;
import gnu.java.awt.font.autofit.LatinAxis;
import gnu.java.awt.font.autofit.LatinBlue;
import gnu.java.awt.font.autofit.LatinMetrics;
import gnu.java.awt.font.autofit.Script;
import gnu.java.awt.font.autofit.ScriptMetrics;
import gnu.java.awt.font.autofit.Segment;
import gnu.java.awt.font.autofit.Utils;
import gnu.java.awt.font.autofit.Width;
import gnu.java.awt.font.opentype.OpenTypeFont;
import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Point;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.geom.AffineTransform;
import java.util.HashSet;

class Latin
implements Script,
Constants {
    static final int MAX_WIDTHS = 16;
    private static final int MAX_TEST_CHARS = 12;
    private static final int CAPITAL_TOP = 0;
    private static final int CAPITAL_BOTTOM = 1;
    private static final int SMALL_F_TOP = 2;
    private static final int SMALL_TOP = 3;
    private static final int SMALL_BOTTOM = 4;
    private static final int SMALL_MINOR = 5;
    static final int BLUE_MAX = 6;
    private static final String[] TEST_CHARS = new String[]{"THEZOCQS", "HEZLOCUS", "fijkdbh", "xzroesc", "xzroesc", "pqgjy"};
    private static final AffineTransform IDENTITY = new AffineTransform();

    Latin() {
    }

    public void applyHints(GlyphHints hints, Zone outline, ScriptMetrics metrics) {
        hints.reload(outline);
        hints.rescale(metrics);
        if (hints.doHorizontal()) {
            this.detectFeatures(hints, 0);
        }
        if (hints.doVertical()) {
            this.detectFeatures(hints, 1);
            this.computeBlueEdges(hints, (LatinMetrics)metrics);
        }
        int dim = 0;
        while (dim < 2) {
            if (dim == 0 && hints.doHorizontal() || dim == 1 && hints.doVertical()) {
                this.hintEdges(hints, dim);
                if (hints.doAlignEdgePoints()) {
                    hints.alignEdgePoints(dim);
                }
                if (hints.doAlignStrongPoints()) {
                    hints.alignStrongPoints(dim);
                }
                if (hints.doAlignWeakPoints()) {
                    hints.alignWeakPoints(dim);
                }
            }
            ++dim;
        }
    }

    private void hintEdges(GlyphHints hints, int dim) {
        Edge edge;
        int e;
        AxisHints axis = hints.axis[dim];
        Edge[] edges = axis.edges;
        int numEdges = axis.numEdges;
        Edge anchor = null;
        int hasSerifs = 0;
        if (dim == 1) {
            e = 0;
            while (e < numEdges) {
                edge = edges[e];
                if ((edge.flags & 4) == 0) {
                    Width blue = edge.blueEdge;
                    Edge edge1 = null;
                    Edge edge2 = edge.link;
                    if (blue != null) {
                        edge1 = edge;
                    } else if (edge2 != null && edge2.blueEdge != null) {
                        blue = edge2.blueEdge;
                        edge1 = edge2;
                        edge2 = edge;
                    }
                    if (edge1 != null) {
                        edge1.pos = blue.fit;
                        edge1.flags |= 4;
                        if (edge2 != null && edge2.blueEdge == null) {
                            this.alignLinkedEdge(hints, dim, edge1, edge2);
                            edge2.flags |= 4;
                        }
                        if (anchor == null) {
                            anchor = edge;
                        }
                    }
                }
                ++e;
            }
        }
        e = 0;
        while (e < numEdges) {
            edge = edges[e];
            if ((edge.flags & 4) == 0) {
                int curPos1;
                Edge edge2 = edge.link;
                if (edge2 == null) {
                    ++hasSerifs;
                } else if (edge2.blueEdge != null || axis.getEdgeIndex(edge2) < e) {
                    this.alignLinkedEdge(hints, dim, edge2, edge);
                    edge.flags |= 4;
                } else if (anchor == null) {
                    int dOff;
                    int uOff;
                    int orgLen = edge2.opos - edge.opos;
                    int curLen = this.computeStemWidth(hints, dim, orgLen, edge.flags, edge2.flags);
                    if (curLen <= 64) {
                        uOff = 32;
                        dOff = 32;
                    } else {
                        uOff = 38;
                        dOff = 26;
                    }
                    if (curLen < 96) {
                        int error2;
                        int orgCenter = edge.opos + (orgLen >> 1);
                        curPos1 = Utils.pixRound(orgCenter);
                        int error1 = orgCenter - (curPos1 - uOff);
                        if (error1 < 0) {
                            error1 = -error1;
                        }
                        if ((error2 = orgCenter - (curPos1 + dOff)) < 0) {
                            error2 = -error2;
                        }
                        curPos1 = error1 < error2 ? (curPos1 -= uOff) : (curPos1 += dOff);
                        edge.pos = curPos1 - curLen / 2;
                        edge2.pos = curPos1 + curLen / 2;
                    } else {
                        edge.pos = Utils.pixRound(edge.opos);
                    }
                    anchor = edge;
                    edge.flags |= 4;
                    this.alignLinkedEdge(hints, dim, edge, edge2);
                } else {
                    int aDiff = edge.opos - anchor.opos;
                    int orgPos = anchor.pos + aDiff;
                    int orgLen = edge2.opos - edge.opos;
                    int orgCenter = orgPos + (orgLen >> 1);
                    int curLen = this.computeStemWidth(hints, dim, orgLen, edge.flags, edge2.flags);
                    if (curLen < 96) {
                        int delta2;
                        int dOff;
                        int uOff;
                        int curPos12 = Utils.pixRound(orgCenter);
                        if (curLen <= 64) {
                            uOff = 32;
                            dOff = 32;
                        } else {
                            uOff = 38;
                            dOff = 26;
                        }
                        int delta1 = orgCenter - (curPos12 - uOff);
                        if (delta1 < 0) {
                            delta1 = -delta1;
                        }
                        if ((delta2 = orgCenter - (curPos12 + dOff)) < 0) {
                            delta2 = -delta2;
                        }
                        curPos12 = delta1 < delta2 ? (curPos12 -= uOff) : (curPos12 += dOff);
                        edge.pos = curPos12 - curLen / 2;
                        edge2.pos = curPos12 + curLen / 2;
                    } else {
                        int curPos2;
                        int delta2;
                        orgPos = anchor.pos + (edge.opos - anchor.opos);
                        orgLen = edge2.opos - edge.opos;
                        orgCenter = orgPos + (orgLen >> 1);
                        curLen = this.computeStemWidth(hints, dim, orgLen, edge.flags, edge2.flags);
                        curPos1 = Utils.pixRound(orgPos);
                        int delta1 = curPos1 + (curLen >> 1) - orgCenter;
                        if (delta1 < 0) {
                            delta1 = -delta1;
                        }
                        if ((delta2 = (curPos2 = Utils.pixRound(orgPos + orgLen) - curLen) + (curLen >> 1) - orgCenter) < 0) {
                            delta2 = -delta2;
                        }
                        edge.pos = delta1 < delta2 ? curPos1 : curPos2;
                        edge2.pos = edge.pos + curLen;
                    }
                    edge.flags |= 4;
                    edge2.flags |= 4;
                    if (e > 0 && edge.pos < edges[e - 1].pos) {
                        edge.pos = edges[e - 1].pos;
                    }
                }
            }
            ++e;
        }
        if (hasSerifs > 0 || anchor == null) {
            e = 0;
            while (e < numEdges) {
                edge = edges[e];
                if ((edge.flags & 4) == 0) {
                    if (edge.serif != null) {
                        this.alignSerifEdge(hints, edge.serif, edge);
                    } else if (anchor == null) {
                        edge.pos = Utils.pixRound(edge.opos);
                        anchor = edge;
                    } else {
                        edge.pos = anchor.pos + Utils.pixRound(edge.opos - anchor.opos);
                    }
                    edge.flags |= 4;
                    if (e > 0 && edge.pos < edges[e - 1].pos) {
                        edge.pos = edges[e - 1].pos;
                    }
                    if (e + 1 < numEdges && (edges[e + 1].flags & 4) != 0 && edge.pos > edges[e + 1].pos) {
                        edge.pos = edges[e + 1].pos;
                    }
                }
                ++e;
            }
        }
    }

    private void alignSerifEdge(GlyphHints hints, Edge base, Edge serif) {
        serif.pos = base.pos + (serif.opos - base.opos);
    }

    private int computeStemWidth(GlyphHints hints, int dim, int width, int baseFlags, int stemFlags) {
        boolean vertical;
        LatinMetrics metrics = (LatinMetrics)hints.metrics;
        LatinAxis axis = metrics.axis[dim];
        int dist = width;
        int sign = 0;
        boolean bl = vertical = dim == 1;
        if (!this.doStemAdjust(hints)) {
            return width;
        }
        if (dist < 0) {
            dist = -width;
            sign = 1;
        }
        if (vertical && !this.doVertSnap(hints) || !vertical && !this.doHorzSnap(hints)) {
            if ((stemFlags & 2) != 0 && vertical && dist < 192) {
                return this.doneWidth(dist, sign);
            }
            if ((baseFlags & 1) != 0) {
                if (dist < 80) {
                    dist = 64;
                }
            } else if (dist < 56) {
                dist = 56;
            }
            if (axis.widthCount > 0) {
                int delta;
                if (axis.widthCount > 0) {
                    delta = dist - axis.widths[0].cur;
                    if (delta < 0) {
                        delta = -delta;
                    }
                    if (delta < 40) {
                        dist = axis.widths[0].cur;
                        if (dist < 48) {
                            dist = 48;
                        }
                        return this.doneWidth(dist, sign);
                    }
                }
                if (dist < 192) {
                    delta = dist & 0x3F;
                    dist &= 0xFFFFFFC0;
                    dist = delta < 10 ? (dist += delta) : (delta < 32 ? (dist += 10) : (delta < 54 ? (dist += 54) : (dist += delta)));
                } else {
                    dist = dist + 32 & 0xFFFFFFC0;
                }
            }
        } else {
            dist = this.snapWidth(axis.widths, axis.widthCount, dist);
            dist = vertical ? (dist >= 64 ? dist + 16 & 0xFFFFFFC0 : 64) : (this.doMono(hints) ? (dist < 64 ? 64 : dist + 32 & 0xFFFFFFC0) : (dist < 48 ? dist + 64 >> 1 : (dist < 128 ? dist + 22 & 0xFFFFFFC0 : dist + 32 & 0xFFFFFFC0)));
        }
        return this.doneWidth(dist, sign);
    }

    private boolean doMono(GlyphHints hints) {
        return true;
    }

    private int snapWidth(Width[] widths, int count, int width) {
        int best = 98;
        int reference = width;
        int n = 0;
        while (n < count) {
            int w = widths[n].cur;
            int dist = width - w;
            if (dist < 0) {
                dist = -dist;
            }
            if (dist < best) {
                best = dist;
                reference = w;
            }
            ++n;
        }
        int scaled = Utils.pixRound(reference);
        if (width >= reference) {
            if (width < scaled + 48) {
                width = reference;
            }
        } else if (width > scaled + 48) {
            width = reference;
        }
        return width;
    }

    private int doneWidth(int w, int s) {
        if (s == 1) {
            w = -w;
        }
        return w;
    }

    private boolean doVertSnap(GlyphHints hints) {
        return true;
    }

    private boolean doHorzSnap(GlyphHints hints) {
        return true;
    }

    private boolean doStemAdjust(GlyphHints hints) {
        return true;
    }

    private void alignLinkedEdge(GlyphHints hints, int dim, Edge base, Edge stem) {
        int dist = stem.opos - base.opos;
        int fitted = this.computeStemWidth(hints, dim, dist, base.flags, stem.flags);
        stem.pos = base.pos + fitted;
    }

    public void doneMetrics(ScriptMetrics metrics) {
    }

    public void initHints(GlyphHints hints, ScriptMetrics metrics) {
        hints.rescale(metrics);
        LatinMetrics lm = (LatinMetrics)metrics;
        hints.xScale = lm.axis[0].scale;
        hints.xDelta = lm.axis[0].delta;
        hints.yScale = lm.axis[1].scale;
        hints.yDelta = lm.axis[1].delta;
    }

    public void initMetrics(ScriptMetrics metrics, OpenTypeFont face) {
        assert (metrics instanceof LatinMetrics);
        LatinMetrics lm = (LatinMetrics)metrics;
        lm.unitsPerEm = face.unitsPerEm;
        this.initWidths(lm, face, 'o');
        this.initBlues(lm, face);
    }

    public void scaleMetrics(ScriptMetrics metrics, HintScaler scaler) {
        LatinMetrics lm = (LatinMetrics)metrics;
        lm.scaler.renderMode = scaler.renderMode;
        lm.scaler.face = scaler.face;
        this.scaleMetricsDim(lm, scaler, 0);
        this.scaleMetricsDim(lm, scaler, 1);
    }

    private void scaleMetricsDim(LatinMetrics lm, HintScaler scaler, int dim) {
        int delta;
        int scale;
        if (dim == 0) {
            scale = scaler.xScale;
            delta = scaler.xDelta;
        } else {
            scale = scaler.yScale;
            delta = scaler.yDelta;
        }
        LatinAxis axis = lm.axis[dim];
        if (axis.orgScale == scale && axis.orgDelta == delta) {
            return;
        }
        axis.orgScale = scale;
        axis.orgDelta = delta;
        LatinAxis cfr_ignored_0 = lm.axis[1];
        LatinBlue blue = null;
        axis.scale = scale;
        axis.delta = delta;
        if (dim == 0) {
            lm.scaler.xScale = scale;
            lm.scaler.xDelta = delta;
        } else {
            lm.scaler.yScale = scale;
            lm.scaler.yDelta = delta;
        }
        int nn = 0;
        while (nn < axis.widthCount) {
            Width w = axis.widths[nn];
            w.fit = w.cur = Fixed.mul16(w.org, scale);
            ++nn;
        }
        if (dim == 1) {
            nn = 0;
            while (nn < axis.blueCount) {
                blue = axis.blues[nn];
                blue.ref.fit = blue.ref.cur = Fixed.mul16(blue.ref.org, scale) + delta;
                blue.shoot.cur = Fixed.mul16(blue.ref.org, scale) + delta;
                blue.flags &= 0xFFFFFFFE;
                int dist = Fixed.mul16(blue.ref.org - blue.shoot.org, scale);
                if (dist <= 48 && dist >= -48) {
                    int delta1;
                    int delta2 = delta1 = blue.shoot.org - blue.ref.org;
                    if (delta1 < 0) {
                        delta2 = -delta2;
                    }
                    delta2 = (delta2 = Fixed.mul16(delta2, scale)) < 32 ? 0 : (delta2 < 64 ? 32 + (delta2 - 32 + 16 & 0xFFFFFFE0) : Utils.pixRound(delta2));
                    if (delta1 < 0) {
                        delta2 = -delta2;
                    }
                    blue.ref.fit = Utils.pixRound(blue.ref.cur);
                    blue.shoot.fit = blue.ref.fit + delta2;
                    blue.flags |= 1;
                }
                ++nn;
            }
        }
    }

    private void initWidths(LatinMetrics metrics, OpenTypeFont face, char ch) {
        LatinAxis axis;
        GlyphHints hints = new GlyphHints();
        metrics.axis[0].widthCount = 0;
        metrics.axis[1].widthCount = 0;
        int glyphIndex = face.getGlyph(ch);
        Zone outline = face.getRawGlyphOutline(glyphIndex, IDENTITY);
        LatinMetrics dummy = new LatinMetrics();
        HintScaler scaler = dummy.scaler;
        dummy.unitsPerEm = metrics.unitsPerEm;
        scaler.yScale = 10000;
        scaler.xScale = 10000;
        scaler.yDelta = 0;
        scaler.xDelta = 0;
        scaler.face = face;
        hints.rescale(dummy);
        hints.reload(outline);
        int dim = 0;
        while (dim < 2) {
            axis = metrics.axis[dim];
            AxisHints axHints = hints.axis[dim];
            int numWidths = 0;
            this.computeSegments(hints, dim);
            this.linkSegments(hints, dim);
            Segment[] segs = axHints.segments;
            HashSet<Segment> touched = new HashSet<Segment>();
            int i = 0;
            while (i < segs.length) {
                Segment seg = segs[i];
                Segment link = seg.link;
                if (link != null && link.link == seg && !touched.contains(link)) {
                    int dist = Math.abs(seg.pos - link.pos);
                    if (numWidths < 16) {
                        axis.widths[numWidths++] = new Width(dist);
                    }
                }
                touched.add(seg);
                ++i;
            }
            Utils.sort(numWidths, axis.widths);
            axis.widthCount = numWidths;
            ++dim;
        }
        dim = 0;
        while (dim < 2) {
            axis = metrics.axis[dim];
            int stdw = axis.widthCount > 0 ? axis.widths[0].org : this.constant(metrics, 50);
            axis.edgeDistanceTreshold = stdw / 5;
            ++dim;
        }
    }

    void linkSegments(GlyphHints hints, int dim) {
        Segment seg1;
        AxisHints axis = hints.axis[dim];
        Segment[] segments = axis.segments;
        int numSegs = axis.numSegments;
        int majorDir = axis.majorDir;
        int lenThreshold = this.constant((LatinMetrics)hints.metrics, 8);
        lenThreshold = Math.min(1, lenThreshold);
        int lenScore = this.constant((LatinMetrics)hints.metrics, 3000);
        int i1 = 0;
        while (i1 < numSegs) {
            seg1 = segments[i1];
            if (seg1.first != seg1.last && seg1.dir == majorDir) {
                int i2 = 0;
                while (i2 < numSegs) {
                    Segment seg2 = segments[i2];
                    if (seg2 != seg1 && seg1.dir + seg2.dir == 0) {
                        int dist;
                        int pos1 = seg1.pos;
                        int pos2 = seg2.pos;
                        int n = dist = dim == 1 ? pos1 - pos2 : pos2 - pos1;
                        if (dist >= 0) {
                            int len;
                            int min = seg1.minPos;
                            int max = seg1.maxPos;
                            if (min < seg2.minPos) {
                                min = seg2.minPos;
                            }
                            if (max > seg2.maxPos) {
                                max = seg2.maxPos;
                            }
                            if ((len = max - min) > lenThreshold) {
                                int score = dist + lenScore / len;
                                if (score < seg1.score) {
                                    seg1.score = score;
                                    seg1.link = seg2;
                                }
                                if (score < seg2.score) {
                                    seg2.score = score;
                                    seg2.link = seg1;
                                }
                            }
                        }
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        i1 = 0;
        while (i1 < numSegs) {
            seg1 = segments[i1];
            Segment seg2 = seg1.link;
            if (seg2 != null) {
                ++seg2.numLinked;
                if (seg2.link != seg1) {
                    seg1.link = null;
                    seg1.serif = seg2.link;
                }
            }
            ++i1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initBlues(LatinMetrics metrics, OpenTypeFont face) {
        flats = new int[12];
        rounds = new int[12];
        axis = metrics.axis[1];
        bb = 0;
        while (bb < 6) {
            p = Latin.TEST_CHARS[bb];
            numFlats = 0;
            numRounds = 0;
            i = 0;
            while (i < p.length()) {
                block23: {
                    glyphIndex = face.getGlyph(p.charAt(i));
                    glyph = face.getRawGlyphOutline(glyphIndex, Latin.IDENTITY);
                    numPoints = glyph.getSize() - 4;
                    points = glyph.getPoints();
                    point = points[0];
                    extremum = 0;
                    index = 1;
                    if (!this.isTopBlue(bb)) ** GOTO lbl30
                    while (index < numPoints) {
                        point = points[index];
                        if (point.getOrigY() < points[extremum].getOrigY()) {
                            extremum = index;
                        }
                        ++index;
                    }
                    break block23;
lbl-1000:
                    // 1 sources

                    {
                        point = points[index];
                        if (point.getOrigY() > points[extremum].getOrigY()) {
                            extremum = index;
                        }
                        ++index;
lbl30:
                        // 2 sources

                        ** while (index < numPoints)
                    }
                }
                idx = extremum;
                last = -1;
                first = 0;
                n = 0;
                while (n < glyph.getNumContours()) {
                    end = glyph.getContourEnd(n);
                    if (end >= idx) {
                        last = end;
                        break;
                    }
                    first = end + 1;
                    ++n;
                }
                if (!Latin.$assertionsDisabled && last < 0) {
                    throw new AssertionError();
                }
                next = prev = idx;
                do {
                    if (prev > first) {
                        --prev;
                        continue;
                    }
                    prev = last;
                } while ((dist = points[prev].getOrigY() - points[extremum].getOrigY()) >= -5 && dist <= 5 && prev != idx);
                do {
                    if (next < last) {
                        ++next;
                        continue;
                    }
                    next = first;
                } while ((dist = points[next].getOrigY() - points[extremum].getOrigY()) >= -5 && dist <= 5 && next != idx);
                v0 = round = points[prev].isControlPoint() != false || points[next].isControlPoint() != false;
                if (round) {
                    rounds[numRounds++] = points[extremum].getOrigY();
                } else {
                    flats[numFlats++] = points[extremum].getOrigY();
                }
                ++i;
            }
            Utils.sort(numRounds, rounds);
            Utils.sort(numFlats, flats);
            blue = axis.blues[axis.blueCount] = new LatinBlue();
            ++axis.blueCount;
            if (numFlats == 0) {
                blue.ref = blue.shoot = new Width(rounds[numRounds / 2]);
            } else if (numRounds == 0) {
                blue.ref = blue.shoot = new Width(flats[numFlats / 2]);
            } else {
                blue.ref = new Width(flats[numFlats / 2]);
                blue.shoot = new Width(rounds[numRounds / 2]);
            }
            if (blue.shoot != blue.ref) {
                shoot = blue.shoot.org;
                ref = blue.ref.org;
                v1 = overRef = shoot < ref;
                if (this.isTopBlue(bb) ^ overRef) {
                    blue.shoot = blue.ref = new Width((shoot + ref) / 2);
                }
            }
            blue.flags = 0;
            if (this.isTopBlue(bb)) {
                blue.flags |= 2;
            }
            if (bb == 3) {
                blue.flags |= 4;
            }
            ++bb;
        }
    }

    private int constant(LatinMetrics metrics, int c) {
        return c * (metrics.unitsPerEm / 2048);
    }

    private void computeSegments(GlyphHints hints, int dim) {
        int majorDir;
        int i;
        Point[] points = hints.points;
        if (dim == 0) {
            i = 0;
            while (i < hints.numPoints) {
                points[i].setU(points[i].getOrigX());
                points[i].setV(points[i].getOrigY());
                ++i;
            }
        } else {
            i = 0;
            while (i < hints.numPoints) {
                points[i].setU(points[i].getOrigY());
                points[i].setV(points[i].getOrigX());
                ++i;
            }
        }
        AxisHints axis = hints.axis[dim];
        int segmentDir = majorDir = Math.abs(axis.majorDir);
        Point[] contours = hints.contours;
        int numContours = hints.numContours;
        Segment segment = null;
        int i2 = 0;
        while (i2 < numContours) {
            int minPos = 32000;
            int maxPos = -32000;
            Point point = contours[i2];
            Point last = point.getPrev();
            if (point != last) {
                if (Math.abs(last.getOutDir()) == majorDir && Math.abs(point.getOutDir()) == majorDir) {
                    last = point;
                    do {
                        if (Math.abs((point = point.getPrev()).getOutDir()) == majorDir) continue;
                        point = point.getNext();
                        break;
                    } while (point != last);
                }
                last = point;
                boolean passed = false;
                boolean onEdge = false;
                while (true) {
                    if (onEdge) {
                        int u = point.getU();
                        if (u < minPos) {
                            minPos = u;
                        }
                        if (u > maxPos) {
                            maxPos = u;
                        }
                        if (point.getOutDir() != segmentDir || point == last) {
                            segment.last = point;
                            segment.pos = minPos + maxPos >> 1;
                            if (segment.first.isControlPoint() || point.isControlPoint()) {
                                segment.flags |= 1;
                            }
                            minPos = maxPos = point.getV();
                            int v = segment.first.getV();
                            if (v < minPos) {
                                minPos = v;
                            }
                            if (v > maxPos) {
                                maxPos = v;
                            }
                            segment.minPos = minPos;
                            segment.maxPos = maxPos;
                            onEdge = false;
                            segment = null;
                        }
                    }
                    if (point == last) {
                        if (passed) break;
                        passed = true;
                    }
                    if (!onEdge && Math.abs(point.getOutDir()) == majorDir) {
                        segmentDir = point.getOutDir();
                        segment = axis.newSegment();
                        segment.dir = segmentDir;
                        segment.flags = 0;
                        minPos = maxPos = point.getU();
                        segment.first = point;
                        segment.last = point;
                        segment.contour = contours[i2];
                        segment.score = 32000;
                        segment.len = 0;
                        segment.link = null;
                        onEdge = true;
                    }
                    point = point.getNext();
                }
            }
            ++i2;
        }
    }

    private boolean isTopBlue(int b) {
        return b == 0 || b == 2 || b == 3;
    }

    private void detectFeatures(GlyphHints hints, int dim) {
        this.computeSegments(hints, dim);
        this.linkSegments(hints, dim);
        this.computeEdges(hints, dim);
    }

    private void computeEdges(GlyphHints hints, int dim) {
        Segment seg;
        AxisHints axis = hints.axis[dim];
        LatinAxis laxis = ((LatinMetrics)hints.metrics).axis[dim];
        Segment[] segments = axis.segments;
        int numSegments = axis.numSegments;
        axis.numEdges = 0;
        int scale = dim == 0 ? hints.xScale : hints.yScale;
        int upDir = dim == 0 ? 2 : 1;
        int edgeDistanceThreshold = Fixed.mul16(laxis.edgeDistanceTreshold, scale);
        if (edgeDistanceThreshold > 16) {
            edgeDistanceThreshold = 16;
        }
        edgeDistanceThreshold = Fixed.div16(edgeDistanceThreshold, scale);
        int i = 0;
        while (i < numSegments) {
            seg = segments[i];
            Edge found = null;
            int ee = 0;
            while (ee < axis.numEdges) {
                Edge edge = axis.edges[ee];
                int dist = seg.pos - edge.fpos;
                if (dist < 0) {
                    dist = -dist;
                }
                if (dist < edgeDistanceThreshold) {
                    found = edge;
                    break;
                }
                ++ee;
            }
            if (found == null) {
                Edge edge = axis.newEdge(seg.pos);
                edge.first = seg;
                edge.last = seg;
                edge.fpos = seg.pos;
                edge.opos = edge.pos = Fixed.mul16(seg.pos, scale);
                seg.edgeNext = seg;
                seg.edge = edge;
            } else {
                seg.edgeNext = found.first;
                found.last.edgeNext = seg;
                found.last = seg;
                seg.edge = found;
            }
            ++i;
        }
        int e = 0;
        while (e < axis.numEdges) {
            Edge edge = axis.edges[e];
            int isRound = 0;
            int isStraight = 0;
            int ups = 0;
            int downs = 0;
            seg = edge.first;
            do {
                boolean isSerif;
                if ((seg.flags & 1) != 0) {
                    ++isRound;
                } else {
                    ++isStraight;
                }
                if (seg.dir == upDir) {
                    ups += seg.maxPos - seg.minPos;
                } else {
                    downs += seg.maxPos - seg.minPos;
                }
                boolean bl = isSerif = seg.serif != null && seg.serif.edge != edge;
                if (seg.link == null && !isSerif) continue;
                Edge edge2 = edge.link;
                Segment seg2 = seg.link;
                if (isSerif) {
                    seg2 = seg.serif;
                    edge2 = edge.serif;
                }
                if (edge2 != null) {
                    int segDelta;
                    int edgeDelta = edge.fpos - edge2.fpos;
                    if (edgeDelta < 0) {
                        edgeDelta = -edgeDelta;
                    }
                    if ((segDelta = seg.pos - seg2.pos) < 0) {
                        segDelta = -segDelta;
                    }
                    if (segDelta < edgeDelta) {
                        edge2 = seg2.edge;
                    }
                } else {
                    edge2 = seg2.edge;
                }
                if (isSerif) {
                    edge.serif = edge2;
                    edge2.flags |= 2;
                    continue;
                }
                edge.link = edge2;
            } while ((seg = seg.edgeNext) != edge.first);
            edge.flags = 0;
            if (isRound > 0 && isRound > isStraight) {
                edge.flags |= 1;
            }
            edge.dir = 0;
            if (ups > downs) {
                edge.dir = upDir;
            } else if (ups < downs) {
                edge.dir = -upDir;
            } else if (ups == downs) {
                edge.dir = 0;
            }
            if (edge.serif != null && edge.link != null) {
                edge.serif = null;
            }
            ++e;
        }
    }

    private void computeBlueEdges(GlyphHints hints, LatinMetrics metrics) {
        AxisHints axis = hints.axis[1];
        Edge[] edges = axis.edges;
        int numEdges = axis.numEdges;
        LatinAxis latin = metrics.axis[1];
        int scale = latin.scale;
        int e = 0;
        while (e < numEdges) {
            Edge edge = edges[e];
            Width bestBlue = null;
            int bestDist = Fixed.mul16(metrics.unitsPerEm / 40, scale);
            if (bestDist > 32) {
                bestDist = 32;
            }
            int bb = 0;
            while (bb < 6) {
                LatinBlue blue = latin.blues[bb];
                if ((blue.flags & 1) != 0) {
                    boolean isMajorDir;
                    boolean isTopBlue = (blue.flags & 2) != 0;
                    boolean bl = isMajorDir = edge.dir == axis.majorDir;
                    if (isTopBlue ^ isMajorDir) {
                        int dist = edge.fpos - blue.ref.org;
                        if (dist < 0) {
                            dist = -dist;
                        }
                        if ((dist = Fixed.mul16(dist, scale)) < bestDist) {
                            bestDist = dist;
                            bestBlue = blue.ref;
                        }
                        if ((edge.flags & 1) != 0 && dist != 0) {
                            boolean isUnderRef;
                            boolean bl2 = isUnderRef = edge.fpos > blue.ref.org;
                            if (isTopBlue ^ isUnderRef) {
                                blue = latin.blues[bb];
                                dist = edge.fpos - blue.shoot.org;
                                if (dist < 0) {
                                    dist = -dist;
                                }
                                if ((dist = Fixed.mul16(dist, scale)) < bestDist) {
                                    bestDist = dist;
                                    bestBlue = blue.shoot;
                                }
                            }
                        }
                    }
                }
                ++bb;
            }
            if (bestBlue != null) {
                edge.blueEdge = bestBlue;
            }
            ++e;
        }
    }
}

