/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.transport;

import gnu.classpath.jdwp.transport.JdwpCommandPacket;
import gnu.classpath.jdwp.transport.JdwpReplyPacket;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class JdwpPacket {
    protected static int _last_id = 0;
    protected static final int JDWP_FLAG_REPLY = 128;
    protected static final int MINIMUM_SIZE = 9;
    protected int _id;
    protected byte _flags;
    protected byte[] _data;

    public JdwpPacket() {
    }

    public JdwpPacket(JdwpPacket pkt) {
        this._id = pkt.getId();
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public byte getFlags() {
        return this._flags;
    }

    public void setFlags(byte flags) {
        this._flags = flags;
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public int getLength() {
        return 9 + (this._data == null ? 0 : this._data.length);
    }

    protected abstract int myFromBytes(byte[] var1, int var2);

    public static JdwpPacket fromBytes(byte[] bytes) {
        int i = 0;
        int length = (bytes[i++] & 0xFF) << 24 | (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
        int id = 0;
        byte flags = 0;
        if (bytes.length == length) {
            id = (bytes[i++] & 0xFF) << 24 | (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
            flags = bytes[i++];
            Class clazz = null;
            if (flags == 0) {
                clazz = JdwpCommandPacket.class;
            } else if ((flags & 0x80) != 0) {
                clazz = JdwpReplyPacket.class;
            } else {
                return null;
            }
            JdwpPacket pkt = null;
            try {
                pkt = (JdwpPacket)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            pkt.setId(id);
            pkt.setFlags(flags);
            i += pkt.myFromBytes(bytes, i);
            byte[] data = new byte[length - i];
            System.arraycopy(bytes, i, data, 0, data.length);
            pkt.setData(data);
            return pkt;
        }
        return null;
    }

    protected abstract void myWrite(DataOutputStream var1) throws IOException;

    public void write(DataOutputStream dos) throws IOException {
        int length = this.getLength();
        dos.writeInt(length);
        dos.writeInt(this.getId());
        dos.writeByte(this.getFlags());
        this.myWrite(dos);
        byte[] data = this.getData();
        if (data != null && data.length > 0) {
            dos.write(data, 0, data.length);
        }
    }
}

