/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.xlib;

import gnu.awt.j2d.Graphics2DImpl;
import gnu.awt.j2d.IntegerGraphicsState;
import gnu.awt.xlib.XEventLoop;
import gnu.awt.xlib.XGraphics;
import gnu.awt.xlib.XGraphicsConfiguration;
import gnu.awt.xlib.XOffScreenImage;
import gnu.awt.xlib.XToolkit;
import gnu.gcj.xlib.Window;
import gnu.gcj.xlib.WindowAttributes;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.CanvasPeer;
import java.awt.peer.ContainerPeer;
import sun.awt.CausedFocusEvent;

public class XCanvasPeer
implements CanvasPeer {
    static final Dimension MIN_SIZE = new Dimension(1, 1);
    public Window window;
    Window parent;
    Component component;
    XGraphicsConfiguration config;
    private WindowAttributes attributes = new WindowAttributes();
    private long eventMask;
    private Rectangle locationBounds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XCanvasPeer(Component component) {
        this.component = component;
        this.config = (XGraphicsConfiguration)component.getGraphicsConfiguration();
        if (this.config == null) {
            this.config = this.getXToolkit().getDefaultXGraphicsConfiguration();
        }
        Rectangle bounds = component.getBounds();
        this.parent = this.locateParentWindow(bounds);
        if (bounds.width < 1) {
            bounds.width = 1;
        }
        if (bounds.height < 1) {
            bounds.height = 1;
        }
        component.setBounds(bounds);
        Color bg = component.getBackground();
        if (bg != null) {
            int[] components = new int[]{bg.getRed(), bg.getGreen(), bg.getBlue(), 255};
            ColorModel cm = this.config.getColorModel();
            long pixel = cm.getDataElement(components, 0);
            this.attributes.setBackground(pixel);
        }
        long eventMask = 32768L;
        this.attributes.setEventMask(eventMask);
        XEventLoop xEventLoop = this.getXToolkit().eventLoop;
        synchronized (xEventLoop) {
            this.window = new Window(this.parent, bounds, this.attributes);
            this.window.setClientData(this);
        }
        this.initWindowProperties();
        if (component.isVisible()) {
            EventQueue.invokeLater(new DoMap(this.window));
        }
    }

    Window locateParentWindow(Rectangle bounds) {
        Container parent = this.component.getParent();
        while (parent.isLightweight()) {
            bounds.x += parent.getX();
            bounds.y += parent.getY();
            parent = parent.getParent();
        }
        XCanvasPeer parentPeer = (XCanvasPeer)parent.getPeer();
        if (parentPeer == null) {
            throw new NullPointerException("Parent has no peer. This should not be possible, since the calls leading here should come from parent, after it has set the parent peer.");
        }
        return parentPeer.window;
    }

    void initWindowProperties() {
    }

    XToolkit getXToolkit() {
        return XToolkit.INSTANCE;
    }

    protected void ensureFlush() {
        this.getXToolkit().flushIfIdle();
    }

    public Component getComponent() {
        return this.component;
    }

    long getBasicEventMask() {
        return 32768L;
    }

    public int checkImage(Image img, int width, int height, ImageObserver o) {
        throw new UnsupportedOperationException("FIXME, not implemented");
    }

    public Image createImage(ImageProducer prod) {
        return new XOffScreenImage(this.config, this.window, prod, this.config.getColorModel());
    }

    public Image createImage(int width, int height) {
        return new XOffScreenImage(this.config, this.window, width, height, this.config.getColorModel());
    }

    public void dispose() {
        throw new UnsupportedOperationException("FIXME, not implemented");
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    public FontMetrics getFontMetrics(Font f) {
        throw new UnsupportedOperationException("FIXME, not implemented");
    }

    public ColorModel getColorModel() {
        return null;
    }

    public Graphics getGraphics() {
        XGraphics gfxDevice = new XGraphics(this.window, this.config);
        IntegerGraphicsState igState = new IntegerGraphicsState(gfxDevice);
        Graphics2DImpl gfx2d = new Graphics2DImpl(this.config);
        gfx2d.setState(igState);
        gfx2d.setColor(this.component.getBackground());
        return gfx2d;
    }

    public Point getLocationOnScreen() {
        this.locationBounds = this.window.getBounds(this.locationBounds);
        return new Point(this.locationBounds.x, this.locationBounds.y);
    }

    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.component.getSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Toolkit getToolkit() {
        return this.getXToolkit();
    }

    public void handleEvent(AWTEvent event) {
        int id = event.getID();
        switch (id) {
            case 800: 
            case 801: {
                try {
                    Graphics g = this.getGraphics();
                    g.setClip(((PaintEvent)event).getUpdateRect());
                    if (id == 800) {
                        this.component.paint(g);
                    } else {
                        this.component.update(g);
                    }
                    g.dispose();
                    break;
                }
                catch (InternalError e) {
                    System.err.println(e);
                }
            }
        }
    }

    public boolean isFocusTraversable() {
        throw new UnsupportedOperationException("FIXME, not implemented");
    }

    public void paint(Graphics gfx) {
    }

    public boolean prepareImage(Image img, int width, int height, ImageObserver o) {
        throw new UnsupportedOperationException("FIXME, not implemented");
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void repaint(long tm, int x, int y, int w, int h) {
        PaintEvent updateEvent = new PaintEvent(this.component, 801, new Rectangle(x, y, w, h));
        this.getXToolkit().queue.postEvent(updateEvent);
    }

    public void requestFocus() {
        throw new UnsupportedOperationException("FIXME, not implemented");
    }

    public void setBackground(Color color) {
        if (color != null) {
            int[] components = new int[]{color.getRed(), color.getGreen(), color.getBlue(), 255};
            ColorModel cm = this.config.getColorModel();
            long pixel = cm.getDataElement(components, 0);
            this.attributes.setBackground(pixel);
            this.window.setAttributes(this.attributes);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        this.window.setBounds(x, y, width, height);
        this.ensureFlush();
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void setCursor(Cursor cursor) {
        throw new UnsupportedOperationException("FIXME, not implemented");
    }

    public void setEnabled(boolean enabled) {
        throw new UnsupportedOperationException("FIXME, not implemented");
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void setEventMask(long eventMask) {
        if (this.eventMask != eventMask) {
            this.eventMask = eventMask;
            long xEventMask = this.getBasicEventMask();
            if ((eventMask & 0x10L) != 0L) {
                xEventMask |= 0xCL;
            }
            this.attributes.setEventMask(xEventMask);
            this.window.setAttributes(this.attributes);
            this.ensureFlush();
        }
    }

    public void setFont(Font font) {
    }

    public void setForeground(Color color) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.window.map();
            this.ensureFlush();
        } else {
            this.window.unmap();
            this.ensureFlush();
        }
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean requestFocus(Component source, boolean b1, boolean b2, long x) {
        return false;
    }

    public boolean requestFocus(Component source, boolean b1, boolean b2, long x, CausedFocusEvent.Cause cause) {
        return false;
    }

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    public void coalescePaintEvent(PaintEvent e) {
    }

    public void updateCursorImmediately() {
    }

    public VolatileImage createVolatileImage(int width, int height) {
        return null;
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public void createBuffers(int x, BufferCapabilities capabilities) throws AWTException {
    }

    public Image getBackBuffer() {
        return null;
    }

    public void flip(BufferCapabilities.FlipContents contents) {
    }

    public void destroyBuffers() {
    }

    public boolean isRestackSupported() {
        return false;
    }

    public void cancelPendingPaint(int x, int y, int width, int height) {
    }

    public void restack() {
    }

    public Rectangle getBounds() {
        return null;
    }

    public void reparent(ContainerPeer parent) {
    }

    public void setBounds(int x, int y, int width, int height, int z) {
    }

    public boolean isReparentSupported() {
        return false;
    }

    public void layout() {
    }

    static class DoMap
    implements Runnable {
        Window window;

        public DoMap(Window w) {
            this.window = w;
        }

        public void run() {
            this.window.map();
        }
    }
}

