/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.imageio.ImageIO;

public class ForestMaker {
    private static String DESTDIR = "data/rules/classic/resources/images/forest";
    private static int BASE_WIDTH = 128;
    private static int BASE_HEIGHT = 64;
    private static int MARGIN = 20;
    private static int TREES = 60;
    private static int RIVER_HEIGHT = 8;
    private static int RIVER_WIDTH = 2 * RIVER_HEIGHT;
    private static int HALF_WIDTH = BASE_WIDTH / 2;
    private static int HALF_HEIGHT = BASE_HEIGHT / 2;
    private static int[] LIMIT = new int[]{HALF_WIDTH, HALF_WIDTH, -HALF_WIDTH, -HALF_WIDTH};
    private static double[] SLOPE = new double[]{-0.5, 0.5, -0.5, 0.5};
    private static final int[] POWERS_OF_TWO = new int[]{1, 2, 4, 8};
    private static boolean drawBorders = true;
    private static boolean drawTrees = true;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: ForestMaker <directory>...");
            System.out.println("Directory name should match a directory in");
            System.out.println("   " + DESTDIR);
            System.exit(1);
        }
        String riverName = "data/rules/classic/resources/images/terrain/ocean/center0.png";
        BufferedImage river = ImageIO.read(new File(riverName));
        river = river.getSubimage(44, 22, 40, 20);
        Rectangle rectangle = new Rectangle(0, 0, river.getWidth(), river.getHeight());
        TexturePaint texture = new TexturePaint(river, rectangle);
        for (String arg : args) {
            File sourceDirectory = new File(arg);
            if (!sourceDirectory.exists()) {
                System.out.println("Source directory " + arg + " does not exist.");
                continue;
            }
            String baseName = sourceDirectory.getName();
            File destinationDirectory = new File(DESTDIR, baseName);
            if (!destinationDirectory.exists()) {
                System.out.println("Destination directory " + destinationDirectory.getPath() + " does not exist.");
                continue;
            }
            File[] imageFiles = sourceDirectory.listFiles();
            if (imageFiles == null) {
                System.out.println("No images found in source directory " + arg + ".");
                continue;
            }
            System.out.println(imageFiles.length + " images found in source directory " + arg + ".");
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(imageFiles.length);
            int maximumHeight = 0;
            for (File imageFile : imageFiles) {
                if (!imageFile.isFile() || !imageFile.canRead()) continue;
                try {
                    BufferedImage image = ImageIO.read(imageFile);
                    images.add(image);
                    if (image.getHeight() <= maximumHeight) continue;
                    maximumHeight = image.getHeight();
                }
                catch (Exception e) {
                    System.out.println("Unable to load image " + imageFile.getName() + ":\n");
                    e.printStackTrace();
                }
            }
            int numberOfImages = images.size();
            Random random = new Random(1492L);
            for (int index = 0; index < 16; ++index) {
                BufferedImage base = new BufferedImage(BASE_WIDTH, BASE_HEIGHT + MARGIN, 2);
                Graphics2D g = base.createGraphics();
                g.translate(HALF_WIDTH, BASE_HEIGHT + MARGIN);
                g.setPaint(texture);
                String counter = "";
                boolean[] branches = new boolean[4];
                if (index > 0) {
                    for (int i = 0; i < POWERS_OF_TWO.length; ++i) {
                        if ((index & POWERS_OF_TWO[i]) == POWERS_OF_TWO[i]) {
                            branches[i] = true;
                            counter = counter + "1";
                            continue;
                        }
                        counter = counter + "0";
                    }
                }
                Point right = new Point(HALF_WIDTH, -HALF_HEIGHT);
                Point left = new Point(-HALF_WIDTH, -HALF_HEIGHT);
                int treeCount = 0;
                if (branches[0] || branches[2]) {
                    left.translate(RIVER_WIDTH, RIVER_HEIGHT);
                    ++treeCount;
                }
                if (branches[1] || branches[3]) {
                    right.translate(-RIVER_WIDTH, RIVER_HEIGHT);
                    ++treeCount;
                }
                if (drawBorders) {
                    int dx = right.x + left.x;
                    int dy = right.y + left.y;
                    g.setColor(Color.RED);
                    g.drawLine(0, 0, right.x, right.y);
                    g.drawLine(right.x, right.y, dx, dy);
                    g.drawLine(dx, dy, left.x, left.y);
                    g.drawLine(left.x, left.y, 0, 0);
                }
                if (drawTrees) {
                    ArrayList<ImageLocation> trees = new ArrayList<ImageLocation>(TREES);
                    int numberOfTrees = (6 - treeCount) * TREES / 6;
                    int count = 0;
                    while (count < numberOfTrees) {
                        BufferedImage image = (BufferedImage)images.get(random.nextInt(numberOfImages));
                        int width = image.getWidth();
                        int height = image.getHeight();
                        int halfWidth = width / 2;
                        float a = random.nextFloat();
                        float b = random.nextFloat();
                        int x = (int)(a * (float)right.x + b * (float)left.x);
                        int y = (int)(a * (float)right.y + b * (float)left.y);
                        if (x - halfWidth < -HALF_WIDTH) {
                            x = -HALF_WIDTH + halfWidth;
                        }
                        if (x + halfWidth > HALF_WIDTH) {
                            x = HALF_WIDTH - halfWidth;
                        }
                        int crown = Math.max(y - height, -(BASE_HEIGHT + MARGIN));
                        if ((branches[1] || branches[3]) && crown < -BASE_HEIGHT + RIVER_HEIGHT + (x + halfWidth) / 2 || (branches[0] || branches[2]) && crown < -BASE_HEIGHT + RIVER_HEIGHT - (x - halfWidth) / 2) continue;
                        trees.add(new ImageLocation(image, x - halfWidth, crown));
                        ++count;
                    }
                    Collections.sort(trees);
                    for (ImageLocation imageLocation : trees) {
                        g.drawImage((Image)imageLocation.image, imageLocation.x, imageLocation.y, null);
                    }
                }
                ImageIO.write((RenderedImage)base, "png", new File(destinationDirectory, sourceDirectory.getName() + counter + ".png"));
            }
        }
    }

    private static int getY(int x, int y, double slope, int newX) {
        return (int)((double)y + slope * (double)(newX - x));
    }

    private static int getRandomY(Random random, int x) {
        int height = HALF_HEIGHT - Math.abs(x) / 2;
        return height == 0 ? 0 : random.nextInt(2 * height) - height;
    }

    private static class ImageLocation
    implements Comparable<ImageLocation> {
        BufferedImage image;
        int x;
        int y;

        public ImageLocation(BufferedImage image, int x, int y) {
            this.image = image;
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(ImageLocation other) {
            int dy = other.y - this.y;
            return dy == 0 ? other.x - this.x : dy;
        }

        public boolean equals(Object other) {
            if (other instanceof ImageLocation) {
                return this.compareTo((ImageLocation)other) == 0;
            }
            return super.equals(other);
        }

        public int hashCode() {
            int hash = super.hashCode();
            hash = 37 * hash + this.x;
            hash = 37 * hash + this.y;
            return 37 * hash + this.image.hashCode();
        }
    }
}

