/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.networking;

import java.io.IOException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.MessageHandler;
import org.w3c.dom.Element;

public final class DummyConnection
extends Connection {
    private MessageHandler outgoingMessageHandler;
    private DummyConnection otherConnection;

    public DummyConnection(String name, MessageHandler incomingMessageHandler) {
        super(name);
        this.setMessageHandler(incomingMessageHandler);
    }

    @Override
    public void close() {
    }

    @Override
    public void send(Element element) throws IOException {
        try {
            this.outgoingMessageHandler.handle(this.getOtherConnection(), element);
        }
        catch (FreeColException freeColException) {
            // empty catch block
        }
    }

    @Override
    public Element ask(Element request) throws IOException {
        Element reply;
        try {
            reply = this.outgoingMessageHandler.handle(this.getOtherConnection(), request);
        }
        catch (FreeColException e) {
            reply = null;
        }
        return reply;
    }

    @Override
    public void sendAndWait(Element element) throws IOException {
        this.ask(element);
    }

    private void setOutgoingMessageHandler(MessageHandler mh) {
        this.outgoingMessageHandler = mh;
    }

    public void setOutgoingMessageHandler(DummyConnection c) {
        this.otherConnection = c;
        this.setOutgoingMessageHandler(c.getMessageHandler());
    }

    public DummyConnection getOtherConnection() {
        return this.otherConnection;
    }

    @Override
    public String toString() {
        return "[DummyConnection " + this.getName() + "]";
    }
}

