/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.TransactionSession;

public class MonarchSession
extends TransactionSession {
    private static final Logger logger = Logger.getLogger(MonarchSession.class.getName());
    private ServerPlayer serverPlayer;
    private Monarch.MonarchAction action;
    private int tax;
    private Goods goods = null;
    private List<AbstractUnit> mercenaries = null;
    private int price;

    public MonarchSession(ServerPlayer serverPlayer, Monarch.MonarchAction action, int tax, Goods goods) {
        super(MonarchSession.makeSessionKey(MonarchSession.class, serverPlayer.getId(), ""));
        this.serverPlayer = serverPlayer;
        this.action = action;
        this.tax = tax;
        this.goods = goods;
        this.mercenaries = null;
        this.price = 0;
    }

    public MonarchSession(ServerPlayer serverPlayer, Monarch.MonarchAction action, List<AbstractUnit> mercenaries, int price) {
        super(MonarchSession.makeSessionKey(MonarchSession.class, serverPlayer.getId(), ""));
        this.serverPlayer = serverPlayer;
        this.action = action;
        this.tax = 0;
        this.goods = null;
        this.mercenaries = mercenaries;
        this.price = price;
    }

    public void complete(boolean result, ChangeSet cs) {
        switch (this.action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: {
                this.serverPlayer.csRaiseTax(this.tax, this.goods, result, cs);
                break;
            }
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                if (!result) break;
                this.serverPlayer.csAddMercenaries(this.mercenaries, this.price, cs);
                break;
            }
        }
        super.complete(cs);
    }

    @Override
    public void complete(ChangeSet cs) {
        switch (this.action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: {
                this.serverPlayer.csRaiseTax(this.tax, this.goods, true, cs);
                cs.addMessage(ChangeSet.See.only(this.serverPlayer), new ModelMessage("model.monarch.ignoredTax", this.serverPlayer).addAmount("%amount%", this.tax));
                break;
            }
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                cs.addMessage(ChangeSet.See.only(this.serverPlayer), new ModelMessage("model.monarch.ignoredMercenaries", this.serverPlayer));
                break;
            }
        }
        super.complete(cs);
    }

    public Monarch.MonarchAction getAction() {
        return this.action;
    }

    public int getTax() {
        return this.tax;
    }

    public Goods getGoods() {
        return this.goods;
    }

    public List<AbstractUnit> getMercenaries() {
        return this.mercenaries;
    }

    public int getPrice() {
        return this.price;
    }
}

