/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class IdleAtSettlementMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IdleAtSettlementMission.class.getName());
    private static final String tag = "AI idler";

    public IdleAtSettlementMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit, null);
    }

    public IdleAtSettlementMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private boolean isSafe() {
        Unit unit = this.getUnit();
        return unit.isInEurope() || !unit.hasTile() || unit.getTile().hasSettlement();
    }

    @Override
    public int getBaseTransportPriority() {
        return 60;
    }

    @Override
    public Location getTarget() {
        return this.isSafe() ? null : this.findTarget();
    }

    @Override
    public void setTarget(Location target) {
    }

    @Override
    public Location findTarget() {
        if (this.isSafe()) {
            return null;
        }
        Unit unit = this.getAIUnit().getUnit();
        PathNode path = unit.findOurNearestOtherSettlement();
        return path == null ? null : IdleAtSettlementMission.upLoc(path.getLastNode().getLocation());
    }

    @Override
    public boolean isOneTime() {
        return true;
    }

    @Override
    public String invalidReason() {
        return IdleAtSettlementMission.invalidAIUnitReason(this.getAIUnit());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        String reason = this.invalidReason();
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        if (this.isSafe()) {
            lb.add(", idling");
            return this.lbAt(lb);
        }
        Location target = this.getTarget();
        if (target == null) {
            this.moveRandomlyTurn(tag);
            return this.lbWait(lb, new Object[0]);
        }
        Unit.MoveType mt = this.travelToTarget(this.getTarget(), null, lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                return this;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        return this.lbAt(lb);
    }

    @Override
    public String getXMLTagName() {
        return IdleAtSettlementMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "idleAtSettlementMission";
    }
}

