/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class DefendSettlementMission
extends Mission {
    private static final Logger logger = Logger.getLogger(DefendSettlementMission.class.getName());
    private String tag = "AI defender";
    private static int MAX_TURNS = 20;
    private Location target;
    private static final String SETTLEMENT_TAG = "settlement";

    public DefendSettlementMission(AIMain aiMain, AIUnit aiUnit, Settlement settlement) {
        super(aiMain, aiUnit, settlement);
    }

    public DefendSettlementMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        Settlement settlement = loc.getSettlement();
        return DefendSettlementMission.invalidReason(aiUnit, settlement) == null ? settlement : null;
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = DefendSettlementMission.extractTarget(aiUnit, path);
        return loc instanceof Settlement ? aiUnit.getAIOwner().adjustMission(aiUnit, path, DefendSettlementMission.class, (int)(1000.0f * ((Settlement)loc).getDefenceRatio() / (float)(path.getTotalTurns() + 1))) : Integer.MIN_VALUE;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit) {
        return new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = Integer.MIN_VALUE;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                int value = DefendSettlementMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (DefendSettlementMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location start = unit.getPathStartLocation();
        return unit.search(start, DefendSettlementMission.getGoalDecider(aiUnit), CostDeciders.avoidSettlementsAndBlockingUnits(), range, unit.getCarrier());
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = DefendSettlementMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? DefendSettlementMission.extractTarget(aiUnit, path) : null;
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = DefendSettlementMission.invalidAIUnitReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        CombatModel cm = unit.getGame().getCombatModel();
        return cm.getDefencePower(null, unit) <= 0.0f ? "unit-not-defender" : null;
    }

    private static String invalidSettlementReason(AIUnit aiUnit, Settlement settlement) {
        return DefendSettlementMission.invalidTargetReason(settlement, aiUnit.getUnit().getOwner());
    }

    public static String invalidReason(AIUnit aiUnit) {
        String reason = DefendSettlementMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (aiUnit.getUnit().getOwner().getNumberOfSettlements() <= 0 ? "target-not-found" : null);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = DefendSettlementMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Settlement ? DefendSettlementMission.invalidSettlementReason(aiUnit, (Settlement)loc) : "target-invalid");
    }

    @Override
    public int getBaseTransportPriority() {
        return this.getTransportDestination() == null ? 0 : 105;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target == null || target instanceof Settlement) {
            this.target = target;
        }
    }

    @Override
    public Location findTarget() {
        return DefendSettlementMission.findTarget(this.getAIUnit(), 4, true);
    }

    @Override
    public String invalidReason() {
        return DefendSettlementMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(this.tag);
        String reason = this.invalidReason();
        if (DefendSettlementMission.isTargetReason(reason)) {
            return this.retargetMission(reason, lb);
        }
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Unit unit = this.getUnit();
        Unit.MoveType mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                return this;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        AIMain aiMain = this.getAIMain();
        AIUnit aiUnit = this.getAIUnit();
        Mission m = null;
        if (this.getTarget() instanceof Colony) {
            Colony colony = (Colony)this.getTarget();
            if (unit.isInColony() || unit.isPerson() && colony.getUnitCount() < 1) {
                m = this.getEuropeanAIPlayer().getWorkInsideColonyMission(aiUnit, aiMain.getAIColony(colony));
                return this.lbDone(lb, m != null, "bolster ", colony);
            }
        }
        switch (unit.getState()) {
            case FORTIFIED: {
                return this.lbWait(lb, ", fortified");
            }
            case FORTIFYING: {
                return this.lbWait(lb, ", fortifying");
            }
        }
        Settlement settlement = (Settlement)this.getTarget();
        int defenderCount = 0;
        int fortifyCount = 0;
        List<Unit> units = settlement.getUnitList();
        units.addAll(settlement.getTile().getUnitList());
        for (Unit u : units) {
            AIUnit aiu = this.getAIMain().getAIUnit(u);
            if (DefendSettlementMission.invalidMissionReason(aiu) != null) continue;
            ++defenderCount;
            switch (u.getState()) {
                case FORTIFIED: 
                case FORTIFYING: {
                    ++fortifyCount;
                    break;
                }
            }
        }
        if (defenderCount <= 2 || fortifyCount <= 1) {
            return !unit.checkSetState(Unit.UnitState.FORTIFYING) ? this.lbWait(lb, ", waiting to fortify at ", settlement) : (AIMessage.askChangeState(aiUnit, Unit.UnitState.FORTIFYING) && unit.getState() == Unit.UnitState.FORTIFYING ? this.lbWait(lb, ", now fortifying at ", settlement) : this.lbFail(lb, false, ", fortify failed at ", settlement));
        }
        if (!unit.isOffensiveUnit()) {
            return this.lbFail(lb, false, "not-offensive-unit");
        }
        CombatModel cm = unit.getGame().getCombatModel();
        Unit bestTarget = null;
        float bestDifference = Float.MIN_VALUE;
        Map.Direction bestDirection = null;
        for (Map.Direction d : Map.Direction.getRandomDirections("defendSettlements", this.getAIRandom())) {
            float weDefend;
            float enemyDefend;
            Unit defender;
            Tile t = unit.getTile().getNeighbourOrNull(d);
            if (t == null || (defender = t.getFirstUnit()) == null || !defender.getOwner().atWarWith(unit.getOwner()) || !unit.getMoveType(d).isAttack()) continue;
            Unit enemyUnit = t.getDefendingUnit(unit);
            float enemyAttack = cm.getOffencePower(enemyUnit, unit);
            float weAttack = cm.getOffencePower(unit, enemyUnit);
            float difference = weAttack / (weAttack + (enemyDefend = cm.getDefencePower(unit, enemyUnit))) - enemyAttack / (enemyAttack + (weDefend = cm.getDefencePower(enemyUnit, unit)));
            if (!(difference > bestDifference) || !(difference > 0.0f) && !(weAttack > enemyDefend)) continue;
            bestDifference = difference;
            bestTarget = enemyUnit;
            bestDirection = d;
        }
        if (bestTarget != null) {
            AIMessage.askAttack(this.getAIUnit(), bestDirection);
            return this.lbAttack(lb, bestTarget);
        }
        return this.lbWait(lb, ", alert at ", this.getTarget());
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(SETTLEMENT_TAG, this.target.getId());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getAttribute(this.getGame(), SETTLEMENT_TAG, Settlement.class, (Settlement)null);
    }

    @Override
    public String getXMLTagName() {
        return DefendSettlementMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "defendSettlementMission";
    }
}

