/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.mission.Mission;

public class BuildColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(BuildColonyMission.class.getName());
    private static final String tag = "AI colony builder";
    private Location target;
    private int colonyValue;
    private static final String TARGET_TAG = "target";

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit, target);
    }

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private int getColonyValue(Tile tile) {
        Player owner = this.getAIUnit().getUnit().getOwner();
        return owner.getColonyValue(tile);
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        Tile tile = loc.getTile();
        Colony colony = loc.getColony();
        return BuildColonyMission.invalidReason(aiUnit, tile) == null ? tile : (BuildColonyMission.invalidReason(aiUnit, colony) == null ? colony : null);
    }

    public static float scorePath(AIUnit aiUnit, PathNode path) {
        Location loc;
        if (path == null || !((loc = BuildColonyMission.extractTarget(aiUnit, path)) instanceof Tile)) {
            return -2.1474836E9f;
        }
        Tile tile = (Tile)loc;
        Player player = aiUnit.getUnit().getOwner();
        float turns = (float)path.getTotalTurns() + 1.0f;
        return (float)player.getColonyValue(tile) / turns;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private float bestValue = 0.0f;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                float value;
                Location loc = BuildColonyMission.extractTarget(aiUnit, path);
                if (loc instanceof Tile && this.bestValue < (value = BuildColonyMission.scorePath(aiUnit, path))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(false, gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (BuildColonyMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location start = unit.getPathStartLocation();
        Unit carrier = unit.getCarrier();
        GoalDecider gd = BuildColonyMission.getGoalDecider(aiUnit, deferOK);
        CostDecider standardCd = CostDeciders.avoidSettlementsAndBlockingUnits();
        return unit.search(start, gd, standardCd, range, carrier);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = BuildColonyMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? BuildColonyMission.extractTarget(aiUnit, path) : BuildColonyMission.upLoc(BuildColonyMission.findCircleTarget(aiUnit, BuildColonyMission.getGoalDecider(aiUnit, deferOK), range * 3, deferOK));
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = BuildColonyMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().getOwner().canBuildColonies() ? "player-not-a-colony-founder" : (!aiUnit.getUnit().getType().canBuildColony() ? "unit-not-a-colony-founder" : null));
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        return BuildColonyMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
    }

    private static String invalidTileReason(AIUnit aiUnit, Tile tile) {
        Player owner = aiUnit.getUnit().getOwner();
        Player.NoClaimReason reason = owner.canClaimToFoundSettlementReason(tile);
        switch (reason) {
            case NONE: 
            case NATIVES: {
                return null;
            }
        }
        return "target-" + (Object)((Object)reason);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = BuildColonyMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? BuildColonyMission.invalidColonyReason(aiUnit, (Colony)loc) : (loc instanceof Tile ? BuildColonyMission.invalidTileReason(aiUnit, (Tile)loc) : "target-invalid"));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return BuildColonyMission.invalidMissionReason(aiUnit);
    }

    @Override
    public int getBaseTransportPriority() {
        return 110;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target == null || target instanceof Colony || target instanceof Tile) {
            this.target = target;
            this.colonyValue = target instanceof Tile ? this.getColonyValue((Tile)target) : -1;
        }
    }

    @Override
    public Location findTarget() {
        return BuildColonyMission.findTarget(this.getAIUnit(), 5, true);
    }

    @Override
    public String invalidReason() {
        return BuildColonyMission.invalidReason(this.getAIUnit(), this.target);
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        AIMain aiMain = this.getAIMain();
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        EuropeanAIPlayer euaip = this.getEuropeanAIPlayer();
        boolean retarget = false;
        String reason = this.invalidReason();
        if (BuildColonyMission.isTargetReason(reason)) {
            Colony c;
            if (this.target instanceof Tile && (c = ((Tile)this.target).getColony()) != null && player.owns(c)) {
                Mission m = euaip.getPioneeringMission(aiUnit, c.getTile());
                if (m != null) {
                    return this.lbDrop(lb, ", improving with ", m);
                }
                this.setTarget(c);
                return this.lbRetarget(lb);
            }
        } else {
            int newValue;
            if (reason != null) {
                return this.lbFail(lb, false, reason);
            }
            if (this.target instanceof Tile && (newValue = this.getColonyValue((Tile)this.target)) < this.colonyValue) {
                reason = "target tile " + this.target.toShortString() + " value " + this.colonyValue + " -> " + newValue;
                retarget = true;
            }
        }
        if (retarget) {
            return this.retargetMission(reason, lb);
        }
        Unit.MoveType mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                return this;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        this.lbAt(lb);
        if (this.getTarget() instanceof Colony) {
            Colony colony = (Colony)this.getTarget();
            Mission m = euaip.getPioneeringMission(aiUnit, colony.getTile());
            if (m != null) {
                return this.lbDrop(lb, ", improving with ", m);
            }
            if (colony.getUnitCount() <= 1) {
                this.setTarget(colony);
                return this.lbDrop(lb, ", join small colony");
            }
            Location newTarget = BuildColonyMission.findTarget(aiUnit, 5, false);
            if (newTarget != null) {
                this.setTarget(newTarget);
                return this.lbRetarget(lb);
            }
            Colony best = null;
            int bestValue = Integer.MAX_VALUE;
            for (Colony c : player.getColonies()) {
                PathNode path;
                if (c == colony || c.getUnitCount() < colony.getUnitCount() || (path = unit.findPath(c)) == null || path.getTotalTurns() >= bestValue) continue;
                bestValue = path.getTotalTurns();
                best = c;
            }
            if (best != null) {
                lb.add(", going to smaller ", best.getUnitCount(), "<", colony.getUnitCount(), " colony");
                this.setTarget(best);
                return this.lbRetarget(lb);
            }
            return this.lbDrop(lb, ", joining");
        }
        if (!(this.getTarget() instanceof Tile)) {
            return this.lbFail(lb, false, "bogus target ", this.getTarget());
        }
        Tile tile = (Tile)this.getTarget();
        if (unit.getMovesLeft() <= 0) {
            return this.lbWait(lb, ", waiting to build at ", tile);
        }
        if (tile.getOwner() != null) {
            if (player.owns(tile)) {
                Colony colony = (Colony)tile.getOwningSettlement();
                if (colony != null) {
                    logger.warning("Building on colony tile: " + tile);
                    return this.lbFail(lb, false, "building on colony tile ", tile);
                }
            } else {
                boolean fail;
                int price = player.getLandPrice(tile);
                boolean bl = fail = price < 0;
                if (price > 0 && !player.checkGold(price) && RandomUtils.randomInt(logger, "Land gold?", this.getAIRandom(), 4) == 0) {
                    lb.add(", ");
                    euaip.cheatGold(price, lb);
                    lb.add(" to buy ", tile);
                }
                if (price >= 0) {
                    boolean bl2 = fail = !AIMessage.askClaimLand(tile, aiUnit, price == 0 ? 0 : (player.checkGold(price) ? price : -1)) || !player.owns(tile);
                }
                if (fail) {
                    return this.retargetMission("tile-claim-at-" + tile, lb);
                }
                lb.add(", claimed colony tile");
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            LogBuilder l2 = new LogBuilder(64);
            l2.add(tag, " score-at-foundation ", tile, ":");
            for (Double d : player.getAllColonyValues(tile)) {
                l2.add(" ", d);
            }
            l2.log(logger, Level.FINE);
        }
        if (AIMessage.askBuildColony(aiUnit, "") && tile.getColony() != null) {
            Colony colony = tile.getColony();
            AIColony aiColony = aiMain.getAIColony(colony);
            aiColony.requestRearrange();
            Mission m = euaip.getWorkInsideColonyMission(aiUnit, aiColony);
            return this.lbDone(lb, m != null, colony);
        }
        return this.lbFail(lb, false, "build at ", tile);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(TARGET_TAG, this.target.getId());
            if (this.colonyValue > 0) {
                xw.writeAttribute("value", this.colonyValue);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
        this.colonyValue = xr.getAttribute("value", -1);
    }

    @Override
    public String getXMLTagName() {
        return BuildColonyMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "buildColonyMission";
    }
}

