/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Wish;
import org.w3c.dom.Element;

public class WorkerWish
extends Wish {
    private static final Logger logger = Logger.getLogger(WorkerWish.class.getName());
    private UnitType unitType;
    private boolean expertNeeded;
    private static final String EXPERT_NEEDED_TAG = "expertNeeded";
    private static final String TRANSPORTABLE_TAG = "transportable";
    private static final String UNIT_TYPE_TAG = "unitType";

    public WorkerWish(AIMain aiMain, String id) {
        super(aiMain, id);
        this.unitType = null;
        this.expertNeeded = false;
    }

    public WorkerWish(AIMain aiMain, Location destination, int value, UnitType unitType, boolean expertNeeded) {
        this(aiMain, WorkerWish.getXMLElementTagName() + ":" + aiMain.getNextId());
        if (destination == null) {
            throw new NullPointerException("destination == null");
        }
        this.destination = destination;
        this.setValue(value);
        this.unitType = unitType;
        this.expertNeeded = expertNeeded;
        this.uninitialized = false;
    }

    public WorkerWish(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.unitType == null;
    }

    public WorkerWish(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.unitType == null;
    }

    public void update(UnitType unitType, boolean expertNeeded, int value) {
        this.setValue(value);
        this.unitType = unitType;
        this.expertNeeded = expertNeeded;
        if (this.transportable != null) {
            this.transportable.setTransportPriority(value);
        }
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public boolean satisfiedBy(Unit unit) {
        return this.expertNeeded ? unit.getType() == this.unitType : unit.getType().isNaval() == this.unitType.isNaval();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (this.unitType == null) {
            result = -1;
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(UNIT_TYPE_TAG, this.unitType);
        xw.writeAttribute(EXPERT_NEEDED_TAG, this.expertNeeded);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        Specification spec = this.getSpecification();
        this.transportable = xr.hasAttribute(TRANSPORTABLE_TAG) ? xr.makeAIObject(aiMain, TRANSPORTABLE_TAG, AIUnit.class, null, true) : null;
        this.unitType = xr.getType(spec, UNIT_TYPE_TAG, UnitType.class, null);
        this.expertNeeded = xr.getAttribute(EXPERT_NEEDED_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        if (this.unitType != null) {
            this.uninitialized = false;
        }
    }

    @Override
    public String toString() {
        LogBuilder lb = new LogBuilder(64);
        lb.add("[", this.getId(), " ", this.unitType == null ? "null" : this.unitType.getSuffix(), this.expertNeeded ? "/expert" : "", " -> ", this.destination, " (", this.getValue(), ")]");
        return lb.toString();
    }

    @Override
    public String getXMLTagName() {
        return WorkerWish.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "workerWish";
    }
}

