/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.server.ai.CacheEntryComparator;

public class ProductionCache {
    private final Colony colony;
    private final Set<Unit> units;
    private final Set<ColonyTile> colonyTiles;
    private final Map<GoodsType, List<Entry>> entries;
    private final List<Entry> assigned = new ArrayList<Entry>();
    private final List<Entry> reserved = new ArrayList<Entry>();
    private static final Comparator<Entry> defaultComparator = new CacheEntryComparator();
    private static final Comparator<Entry> marketValueComparator = new CacheEntryComparator(){

        @Override
        public int compareProduction(Entry entry1, Entry entry2) {
            int production = entry2.getProduction() - entry1.getProduction();
            Market market = entry1.getUnit().getOwner().getMarket();
            if (market != null) {
                production = market.getSalePrice(entry2.getGoodsType(), entry2.getProduction()) - market.getSalePrice(entry1.getGoodsType(), entry1.getProduction());
            }
            return production;
        }
    };
    private int unitCount;
    private TypeCountMap<BuildingType> unitCounts = new TypeCountMap();

    public ProductionCache(Colony colony) {
        this.colony = colony;
        this.units = new HashSet<Unit>(colony.getUnitList());
        this.unitCount = this.units.size();
        this.colonyTiles = new HashSet<ColonyTile>();
        Unit someUnit = colony.getUnitList().get(0);
        for (ColonyTile colonyTile : colony.getColonyTiles()) {
            if (!colonyTile.canAdd(someUnit)) continue;
            this.colonyTiles.add(colonyTile);
        }
        this.entries = new HashMap<GoodsType, List<Entry>>();
    }

    private List<Entry> createEntries(GoodsType goodsType) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        if (goodsType.isFarmed()) {
            for (ColonyTile colonyTile : this.colonyTiles) {
                Tile tile = colonyTile.getWorkTile();
                if (tile.getPotentialProduction(goodsType, null) <= 0 && (!tile.hasResource() || tile.getTileItemContainer().getResource().getType().getModifiers(goodsType.getId()).isEmpty())) continue;
                for (Unit unit : this.units) {
                    result.add(new Entry(goodsType, colonyTile, unit));
                }
            }
        } else {
            for (WorkLocation wl : this.colony.getWorkLocationsForProducing(goodsType)) {
                Building building;
                if (!(wl instanceof Building) || (building = (Building)wl).getType().getWorkPlaces() <= 0) continue;
                for (Unit unit : this.units) {
                    result.add(new Entry(goodsType, building, unit));
                }
            }
        }
        Collections.sort(result, defaultComparator);
        this.entries.put(goodsType, result);
        return result;
    }

    public Set<Unit> getUnits() {
        return this.units;
    }

    public int getUnitCount() {
        return this.unitCount;
    }

    public int getUnitCount(BuildingType buildingType) {
        return this.unitCounts.getCount(buildingType);
    }

    public int decrementUnitCount(BuildingType buildingType) {
        Integer result = this.unitCounts.incrementCount(buildingType, -1);
        return result == null ? 0 : result;
    }

    public List<Entry> getAssigned() {
        return this.assigned;
    }

    public List<Entry> getReserved() {
        return this.reserved;
    }

    public List<Entry> getEntries(GoodsType goodsType) {
        List<Entry> result = this.entries.get(goodsType);
        if (result == null) {
            result = this.createEntries(goodsType);
        }
        return result;
    }

    public List<Entry> getEntries(List<GoodsType> goodsTypes) {
        return this.getEntries(goodsTypes, false);
    }

    public List<Entry> getEntries(List<GoodsType> goodsTypes, boolean useMarketValues) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (GoodsType goodsType : goodsTypes) {
            result.addAll(this.getEntries(goodsType));
        }
        if (useMarketValues) {
            Collections.sort(result, marketValueComparator);
        } else {
            Collections.sort(result, defaultComparator);
        }
        return result;
    }

    public void assign(Entry entry) {
        ColonyTile colonyTile = null;
        Building building = null;
        if (entry.getWorkLocation() instanceof ColonyTile) {
            colonyTile = (ColonyTile)entry.getWorkLocation();
            this.colonyTiles.remove(colonyTile);
        } else if (entry.getWorkLocation() instanceof Building) {
            building = (Building)entry.getWorkLocation();
            this.unitCounts.incrementCount(building.getType(), 1);
        }
        Unit unit = null;
        if (!entry.isOtherExpert()) {
            unit = entry.getUnit();
            this.units.remove(unit);
            this.assigned.add(entry);
            ProductionCache.removeEntries(unit, colonyTile, this.reserved);
        } else if (colonyTile == null) {
            if (this.unitCounts.getCount(building.getType()) == 1) {
                this.reserved.addAll((Collection<Entry>)this.entries.get(entry.getGoodsType()));
            }
        } else {
            this.reserved.addAll(ProductionCache.removeEntries(null, colonyTile, this.entries.get(entry.getGoodsType())));
        }
        for (List<Entry> entryList : this.entries.values()) {
            ProductionCache.removeEntries(unit, colonyTile, entryList);
        }
        --this.unitCount;
    }

    public static List<Entry> removeEntries(Unit unit, WorkLocation workLocation, List<Entry> entryList) {
        Iterator<Entry> entryIterator = entryList.iterator();
        ArrayList<Entry> removedEntries = new ArrayList<Entry>();
        while (entryIterator.hasNext()) {
            Entry entry = entryIterator.next();
            if (entry.getUnit() != unit && entry.getWorkLocation() != workLocation) continue;
            removedEntries.add(entry);
            entryIterator.remove();
        }
        return removedEntries;
    }

    public static class Entry {
        private final GoodsType goodsType;
        private final WorkLocation workLocation;
        private final Unit unit;
        private final int production;
        private boolean isExpert = false;
        private boolean isOtherExpert = false;
        private boolean unitUpgrades = false;
        private boolean unitUpgradesToExpert = false;

        public Entry(GoodsType g, WorkLocation w, Unit u) {
            this.goodsType = g;
            this.workLocation = w;
            this.unit = u;
            this.production = w.getProductionOf(u, g);
            GoodsType expertProduction = this.unit.getType().getExpertProduction();
            if (expertProduction != null) {
                if (expertProduction == this.goodsType) {
                    this.isExpert = true;
                } else {
                    this.isOtherExpert = true;
                }
            } else {
                for (UnitTypeChange change : this.unit.getType().getTypeChanges()) {
                    if (!change.asResultOf(UnitTypeChange.ChangeType.EXPERIENCE)) continue;
                    this.unitUpgrades = true;
                    if (change.getNewUnitType().getExpertProduction() != this.goodsType) continue;
                    this.unitUpgradesToExpert = true;
                    break;
                }
            }
        }

        public GoodsType getGoodsType() {
            return this.goodsType;
        }

        public WorkLocation getWorkLocation() {
            return this.workLocation;
        }

        public Unit getUnit() {
            return this.unit;
        }

        public int getProduction() {
            return this.production;
        }

        public boolean isExpert() {
            return this.isExpert;
        }

        public boolean isOtherExpert() {
            return this.isOtherExpert;
        }

        public boolean unitUpgrades() {
            return this.unitUpgrades;
        }

        public boolean unitUpgradesToExpert() {
            return this.unitUpgradesToExpert;
        }

        public String toString() {
            String result = "Cache entry: " + this.unit;
            if (this.workLocation instanceof ColonyTile) {
                return result + ((ColonyTile)this.workLocation).getTile().getNameKey() + "(" + this.workLocation.getId() + ") " + this.goodsType.getNameKey();
            }
            if (this.workLocation instanceof Building) {
                return result + ((Building)this.workLocation).getNameKey() + "(" + this.workLocation.getId() + ") ";
            }
            return result;
        }
    }
}

