/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.NativeAIPlayer;
import net.sf.freecol.server.ai.REFAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.model.ServerPlayer;

public class AIMain
extends FreeColObject
implements FreeColGameObjectListener {
    private static final Logger logger = Logger.getLogger(AIMain.class.getName());
    private FreeColServer freeColServer;
    private int nextId = 1;
    private final Map<String, AIObject> aiObjects = new HashMap<String, AIObject>();
    private static final String NEXT_ID_TAG = "nextId";
    private static final String COLONIAL_AI_PLAYER_TAG = "colonialAIPlayer";
    private static final String GOODS_WISH_TAG = "GoodsWish";
    private static final String TILE_IMPROVEMENT_PLAN_TAG = "tileimprovementplan";
    private static final String OLD_NEXT_ID_TAG = "nextID";

    public AIMain(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public AIMain(FreeColServer freeColServer, FreeColXMLReader xr) throws XMLStreamException {
        this(freeColServer);
        this.readFromXML(xr);
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public Game getGame() {
        return this.freeColServer.getGame();
    }

    public String getNextId() {
        String id = "am" + Integer.toString(this.nextId);
        ++this.nextId;
        return id;
    }

    public int getRandomSeed(String logMe) {
        return RandomUtils.randomInt(logger, logMe, this.freeColServer.getServerRandom(), Integer.MAX_VALUE);
    }

    private boolean shouldHaveAIObject(FreeColGameObject fcgo) {
        return fcgo instanceof Colony ? true : (fcgo instanceof Player ? ((Player)fcgo).isAI() : fcgo instanceof Unit);
    }

    public void findNewObjects(boolean overwrite) {
        Iterator<FreeColGameObject> i = this.freeColServer.getGame().getFreeColGameObjectIterator();
        while (i.hasNext()) {
            FreeColGameObject fcgo = i.next();
            if (!this.shouldHaveAIObject(fcgo) || !overwrite && this.getAIObject(fcgo) != null) continue;
            this.setFreeColGameObject(fcgo.getId(), fcgo);
        }
    }

    public AIObject getAIObject(FreeColGameObject fcgo) {
        return this.getAIObject(fcgo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIObject getAIObject(String id) {
        Map<String, AIObject> map = this.aiObjects;
        synchronized (map) {
            return this.aiObjects.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAIObject(String id, AIObject aiObject) {
        boolean present;
        if (aiObject == null) {
            throw new NullPointerException("aiObject == null");
        }
        Map<String, AIObject> map = this.aiObjects;
        synchronized (map) {
            present = this.aiObjects.containsKey(id);
            if (!present) {
                this.aiObjects.put(id, aiObject);
            }
        }
        if (present) {
            throw new RuntimeException("AIObject already created: " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAIObject(String id) {
        boolean result;
        Map<String, AIObject> map = this.aiObjects;
        synchronized (map) {
            result = this.aiObjects.remove(id) != null;
        }
        if (result) {
            logger.finest("Removed AI object: " + id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AIObject> getAIObjects() {
        Map<String, AIObject> map = this.aiObjects;
        synchronized (map) {
            return new ArrayList<AIObject>(this.aiObjects.values());
        }
    }

    public <T extends AIObject> T getAIObject(String id, Class<T> returnClass) {
        AIObject aio = this.getAIObject(id);
        try {
            return (T)((AIObject)returnClass.cast(aio));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public AIColony getAIColony(Colony colony) {
        return this.getAIObject(colony.getId(), AIColony.class);
    }

    public AIPlayer getAIPlayer(Player player) {
        return this.getAIObject(player.getId(), AIPlayer.class);
    }

    public AIUnit getAIUnit(Unit unit) {
        return this.getAIObject(unit.getId(), AIUnit.class);
    }

    public Map<String, String> getAIStatistics() {
        HashMap<String, String> stats = new HashMap<String, String>();
        HashMap<String, Long> objStats = new HashMap<String, Long>();
        for (AIObject aIObject : this.getAIObjects()) {
            Long count;
            String className = aIObject.getClass().getSimpleName();
            if (objStats.containsKey(className)) {
                Long l = count = (Long)objStats.get(className);
                Long l2 = count = Long.valueOf(count + 1L);
                objStats.put(className, count);
                continue;
            }
            count = new Long(1L);
            objStats.put(className, count);
        }
        for (Map.Entry entry : objStats.entrySet()) {
            stats.put((String)entry.getKey(), Long.toString((Long)entry.getValue()));
        }
        return stats;
    }

    public int checkIntegrity(boolean fix) {
        int result = 1;
        for (AIObject aio : this.getAIObjects()) {
            int integ = aio.checkIntegrity(fix);
            if (integ < 0 && fix) {
                logger.warning("Invalid AIObject: " + aio.getId() + " (" + StringUtils.lastPart(aio.getClass().getName(), ".") + "), dropping.");
                this.removeAIObject(aio.getId());
                aio.dispose();
                integ = 0;
            }
            result = Math.min(result, integ);
        }
        Iterator<FreeColGameObject> fit = this.getGame().getFreeColGameObjectIterator();
        while (fit.hasNext()) {
            FreeColGameObject f = fit.next();
            if (!this.shouldHaveAIObject(f) || this.getAIObject(f.getId()) != null) continue;
            if (fix) {
                logger.warning("Added missing AIObject for: " + f.getId());
                this.setFreeColGameObject(f.getId(), f);
                result = 0;
                continue;
            }
            logger.warning("Missing AIObject for: " + f.getId());
            result = -1;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (this.getAIObject(id) != null || !this.shouldHaveAIObject(fcgo)) {
            return;
        }
        if (!id.equals(fcgo.getId())) {
            throw new IllegalArgumentException("!id.equals(fcgo.getId())");
        }
        if (fcgo instanceof Colony) {
            new AIColony(this, (Colony)fcgo);
            return;
        } else if (fcgo instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)fcgo;
            if (player.getPlayerType() == null) {
                logger.info("Temporarily ignoring incomplete AI player: " + fcgo.getId());
                return;
            } else if (player.isIndian()) {
                new NativeAIPlayer(this, player);
                return;
            } else if (player.isREF()) {
                new REFAIPlayer(this, player);
                return;
            } else {
                if (!player.isEuropean()) throw new IllegalArgumentException("Bogus player: " + player);
                new EuropeanAIPlayer(this, player);
            }
            return;
        } else {
            if (!(fcgo instanceof Unit)) return;
            new AIUnit(this, (Unit)fcgo);
        }
    }

    @Override
    public void removeFreeColGameObject(String id) {
        AIObject o = this.getAIObject(id);
        if (o != null) {
            o.dispose();
        }
        this.removeAIObject(id);
    }

    @Override
    public void ownerChanged(FreeColGameObject source, Player oldOwner, Player newOwner) {
        AIObject ao = this.getAIObject(source);
        logger.finest("Owner changed for " + source.getId() + " with AI object: " + ao);
        AIPlayer aiOwner = this.getAIPlayer(oldOwner);
        if (aiOwner != null) {
            if (ao instanceof AIColony) {
                aiOwner.removeAIColony((AIColony)ao);
            } else if (ao instanceof AIUnit) {
                aiOwner.removeAIUnit((AIUnit)ao);
            }
        }
        if (ao != null) {
            ao.dispose();
            this.setFreeColGameObject(source.getId(), source);
        }
    }

    @Override
    public Specification getSpecification() {
        return this.getGame().getSpecification();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeAttribute(NEXT_ID_TAG, this.nextId);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (AIObject aio : FreeColObject.getSortedCopy(this.aiObjects.values())) {
            if (aio.checkIntegrity(false) < 0) {
                aio.dispose();
                continue;
            }
            if (aio instanceof Wish && !((Wish)aio).shouldBeStored()) continue;
            try {
                if (aio.getId() == null) {
                    logger.warning("Null AI identifier for: " + aio.getClass().getName());
                    continue;
                }
                aio.toXML(xw);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to write AI object: " + aio, e);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.nextId = xr.getAttribute(NEXT_ID_TAG, -1);
        if (this.nextId < 0) {
            this.nextId = xr.getAttribute(OLD_NEXT_ID_TAG, 0);
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.aiObjects.clear();
        super.readChildren(xr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String mainTag;
        String tag = xr.getLocalName();
        String oid = xr.readId();
        try {
            AIColony ac;
            AIObject aio;
            Wish wish = null;
            if (oid != null && (aio = this.getAIObject(oid)) != null) {
                aio.readFromXML(xr);
            } else if (COLONIAL_AI_PLAYER_TAG.equals(tag)) {
                new EuropeanAIPlayer(this, xr);
            } else if (AIColony.getXMLElementTagName().equals(tag)) {
                new AIColony(this, xr);
            } else if (AIGoods.getXMLElementTagName().equals(tag)) {
                new AIGoods(this, xr);
            } else if (AIPlayer.getXMLElementTagName().equals(tag)) {
                Player p = this.getGame().getFreeColGameObject(oid, Player.class);
                if (p != null) {
                    if (p.isIndian()) {
                        new NativeAIPlayer(this, xr);
                    } else if (p.isREF()) {
                        new REFAIPlayer(this, xr);
                    } else {
                        if (!p.isEuropean()) throw new RuntimeException("Bogus AIPlayer: " + p);
                        new EuropeanAIPlayer(this, xr);
                    }
                }
            } else if (AIUnit.getXMLElementTagName().equals(tag)) {
                new AIUnit(this, xr);
            } else if (GoodsWish.getXMLElementTagName().equals(tag) || GOODS_WISH_TAG.equals(tag)) {
                wish = new GoodsWish(this, xr);
            } else if (TileImprovementPlan.getXMLElementTagName().equals(tag) || TILE_IMPROVEMENT_PLAN_TAG.equals(tag)) {
                new TileImprovementPlan(this, xr);
            } else if (WorkerWish.getXMLElementTagName().equals(tag)) {
                wish = new WorkerWish(this, xr);
            } else {
                super.readChild(xr);
            }
            if (wish == null || (ac = wish.getDestinationAIColony()) == null) return;
            ac.addWish(wish);
            return;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception reading AIObject: " + tag + ", id=" + oid, e);
            mainTag = AIMain.getXMLElementTagName();
        }
        while (xr.nextTag() != 2 || !xr.atTag(tag) && !xr.atTag(mainTag)) {
        }
    }

    @Override
    public String getXMLTagName() {
        return AIMain.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "aiMain";
    }
}

