/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.freecol.common.resources.Resource;

public class ResourceMapping {
    protected Map<String, Resource> resources = new HashMap<String, Resource>();

    public void add(String id, Resource value) {
        this.resources.put(id, value);
    }

    public void addAll(ResourceMapping rc) {
        if (rc != null) {
            this.resources.putAll(rc.getResources());
        }
    }

    public boolean containsKey(String key) {
        return this.resources.containsKey(key);
    }

    public Map<String, Resource> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public Resource get(String id) {
        return this.resources.get(id);
    }

    public List<String> getKeys(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.resources.keySet()) {
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result;
    }
}

