/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Color;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.Resource;

public class ColorResource
extends Resource {
    private static final Logger logger = Logger.getLogger(ColorResource.class.getName());
    public static final String SCHEME = "color:";
    private Color color;

    public ColorResource(Color color) {
        this.color = color;
    }

    public ColorResource(URI resourceLocator) throws Exception {
        super(resourceLocator);
        String colorName = resourceLocator.getSchemeSpecificPart().substring(SCHEME.length());
        this.color = ColorResource.getColor(colorName);
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void preload() {
    }

    private static boolean isHexString(String str) {
        if (str == null || !str.startsWith("0x") && !str.startsWith("0X") || str.length() <= 2) {
            return false;
        }
        for (int i = 2; i < str.length(); ++i) {
            if ("0123456789ABCDEFabcdef".indexOf(str.substring(i, i + 1)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static Color getColor(String colorName) {
        if (ColorResource.isHexString(colorName)) {
            try {
                int col = Integer.decode(colorName);
                return new Color(col, colorName.length() > 8);
            }
            catch (NumberFormatException e) {
                logger.warning("Failed to decode hex colour string: " + colorName);
            }
        } else {
            try {
                Field field = Color.class.getField(colorName);
                return (Color)field.get(null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to decode colour", e);
            }
        }
        return Color.BLACK;
    }
}

