/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.ModListOption;
import net.sf.freecol.common.option.ModOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.TextOption;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.option.UnitTypeOption;

public abstract class AbstractOption<T>
extends FreeColObject
implements Option<T> {
    private static Logger logger = Logger.getLogger(AbstractOption.class.getName());
    private String optionGroup = "";
    protected boolean isDefined = false;
    private static final String ACTION_TAG = "action";
    private static final String DEFAULT_VALUE_TAG = "defaultValue";

    public AbstractOption(String id) {
        this.setId(id);
    }

    public AbstractOption(Specification specification) {
        this(null, specification);
    }

    public AbstractOption(String id, Specification specification) {
        this.setId(id);
        this.setSpecification(specification);
    }

    public String getGroup() {
        return this.optionGroup;
    }

    public void setGroup(String group) {
        this.optionGroup = group == null ? "" : group;
    }

    protected void setValues(AbstractOption<T> source) {
        this.setId(source.getId());
        this.setSpecification(source.getSpecification());
        this.setValue(source.getValue());
        this.setGroup(source.getGroup());
        this.isDefined = source.isDefined;
    }

    protected void setValue(String valueString, String defaultValueString) throws XMLStreamException {
        throw new XMLStreamException("Unsupported method: setValue.");
    }

    public void generateChoices() {
    }

    public boolean isNullValueOK() {
        return false;
    }

    @Override
    public abstract AbstractOption<T> clone() throws CloneNotSupportedException;

    @Override
    public abstract T getValue();

    @Override
    public abstract void setValue(T var1);

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        String defaultValue = xr.getAttribute(DEFAULT_VALUE_TAG, null);
        String value = xr.getAttribute("value", null);
        if (defaultValue == null && value == null) {
            if (!this.isNullValueOK()) {
                throw new XMLStreamException("invalid option " + this.getId() + ": no value nor default value found.");
            }
        } else {
            this.setValue(value, defaultValue);
        }
    }

    protected AbstractOption readOption(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        AbstractOption option = null;
        if (ACTION_TAG.equals(tag)) {
            logger.finest("Skipping action " + xr.readId());
            xr.nextTag();
        } else if (AbstractUnitOption.getXMLElementTagName().equals(tag)) {
            option = new AbstractUnitOption(spec);
        } else if (AudioMixerOption.getXMLElementTagName().equals(tag)) {
            option = new AudioMixerOption(spec);
        } else if (BooleanOption.getXMLElementTagName().equals(tag)) {
            option = new BooleanOption(spec);
        } else if (FileOption.getXMLElementTagName().equals(tag)) {
            option = new FileOption(spec);
        } else if (IntegerOption.getXMLElementTagName().equals(tag)) {
            option = new IntegerOption(spec);
        } else if (LanguageOption.getXMLElementTagName().equals(tag)) {
            option = new LanguageOption(spec);
        } else if (ModListOption.getXMLElementTagName().equals(tag)) {
            option = new ModListOption(spec);
        } else if (ModOption.getXMLElementTagName().equals(tag)) {
            option = new ModOption(spec);
        } else if (OptionGroup.getXMLElementTagName().equals(tag)) {
            option = new OptionGroup(spec);
        } else if (PercentageOption.getXMLElementTagName().equals(tag)) {
            option = new PercentageOption(spec);
        } else if (RangeOption.getXMLElementTagName().equals(tag)) {
            option = new RangeOption(spec);
        } else if (SelectOption.getXMLElementTagName().equals(tag)) {
            option = new SelectOption(spec);
        } else if (StringOption.getXMLElementTagName().equals(tag)) {
            option = new StringOption(spec);
        } else if (UnitListOption.getXMLElementTagName().equals(tag)) {
            option = new UnitListOption(spec);
        } else if (UnitTypeOption.getXMLElementTagName().equals(tag)) {
            option = new UnitTypeOption(spec);
        } else if (TextOption.getXMLElementTagName().equals(tag)) {
            option = new TextOption(spec);
        } else {
            logger.warning("Not an option type: " + tag);
            xr.nextTag();
        }
        if (option != null) {
            option.readFromXML(xr);
        }
        return option;
    }
}

