/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.AbandonColonyMessage;
import net.sf.freecol.common.networking.AskSkillMessage;
import net.sf.freecol.common.networking.AssignTeacherMessage;
import net.sf.freecol.common.networking.AssignTradeRouteMessage;
import net.sf.freecol.common.networking.AttackMessage;
import net.sf.freecol.common.networking.BuildColonyMessage;
import net.sf.freecol.common.networking.BuyMessage;
import net.sf.freecol.common.networking.BuyPropositionMessage;
import net.sf.freecol.common.networking.CashInTreasureTrainMessage;
import net.sf.freecol.common.networking.ChangeStateMessage;
import net.sf.freecol.common.networking.ChangeWorkImprovementTypeMessage;
import net.sf.freecol.common.networking.ChangeWorkTypeMessage;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.ClaimLandMessage;
import net.sf.freecol.common.networking.ClearSpecialityMessage;
import net.sf.freecol.common.networking.Client;
import net.sf.freecol.common.networking.CloseTransactionMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DeclareIndependenceMessage;
import net.sf.freecol.common.networking.DeclineMoundsMessage;
import net.sf.freecol.common.networking.DeliverGiftMessage;
import net.sf.freecol.common.networking.DemandTributeMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.DisbandUnitMessage;
import net.sf.freecol.common.networking.DisembarkMessage;
import net.sf.freecol.common.networking.EmbarkMessage;
import net.sf.freecol.common.networking.EmigrateUnitMessage;
import net.sf.freecol.common.networking.EquipForRoleMessage;
import net.sf.freecol.common.networking.FirstContactMessage;
import net.sf.freecol.common.networking.GetNationSummaryMessage;
import net.sf.freecol.common.networking.GetTransactionMessage;
import net.sf.freecol.common.networking.GoodsForSaleMessage;
import net.sf.freecol.common.networking.InciteMessage;
import net.sf.freecol.common.networking.JoinColonyMessage;
import net.sf.freecol.common.networking.LearnSkillMessage;
import net.sf.freecol.common.networking.LoadGoodsMessage;
import net.sf.freecol.common.networking.LoginMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.MissionaryMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.MoveMessage;
import net.sf.freecol.common.networking.MoveToMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.networking.PayArrearsMessage;
import net.sf.freecol.common.networking.PayForBuildingMessage;
import net.sf.freecol.common.networking.PutOutsideColonyMessage;
import net.sf.freecol.common.networking.RenameMessage;
import net.sf.freecol.common.networking.ScoutIndianSettlementMessage;
import net.sf.freecol.common.networking.ScoutSpeakToChiefMessage;
import net.sf.freecol.common.networking.SellMessage;
import net.sf.freecol.common.networking.SellPropositionMessage;
import net.sf.freecol.common.networking.SetBuildQueueMessage;
import net.sf.freecol.common.networking.SetCurrentStopMessage;
import net.sf.freecol.common.networking.SetDestinationMessage;
import net.sf.freecol.common.networking.SetGoodsLevelsMessage;
import net.sf.freecol.common.networking.SetTradeRoutesMessage;
import net.sf.freecol.common.networking.SpySettlementMessage;
import net.sf.freecol.common.networking.TrainUnitInEuropeMessage;
import net.sf.freecol.common.networking.TrivialMessage;
import net.sf.freecol.common.networking.UnloadGoodsMessage;
import net.sf.freecol.common.networking.UpdateTradeRouteMessage;
import net.sf.freecol.common.networking.WorkMessage;
import net.sf.freecol.common.option.OptionGroup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ServerAPI {
    private static final Logger logger = Logger.getLogger(ServerAPI.class.getName());
    private Client client;

    protected abstract void doClientProcessingFor(Element var1);

    protected abstract void doRaiseErrorMessage(String var1);

    private boolean send(Element element) {
        try {
            this.client.send(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send: " + element, e);
        }
        return false;
    }

    private boolean send(DOMMessage message) {
        try {
            this.client.send(message);
            return true;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Could not send: " + message.getType(), ioe);
            return false;
        }
    }

    private boolean sendAndWait(DOMMessage message) {
        try {
            this.client.sendAndWait(message);
            return true;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Could not send: " + message.getType(), ioe);
            return false;
        }
    }

    private Element ask(DOMMessage message) {
        Element reply = null;
        try {
            reply = this.client.ask(message);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Could not ask: " + message.getType(), ioe);
        }
        return reply;
    }

    private void resolve(Element request) {
        while (request != null) {
            try {
                request = this.client.handleReply(this.client.ask(request));
            }
            catch (IOException ioe) {
                logger.warning("Could not resolve: " + request.getTagName());
                break;
            }
        }
    }

    private Element askExpecting(DOMMessage message, String tag, HashMap<String, String> results) {
        Element reply = this.ask(message);
        if (reply == null) {
            return null;
        }
        if ("error".equals(reply.getTagName())) {
            String messageId = reply.getAttribute("messageID");
            String messageText = reply.getAttribute("message");
            if (messageId != null && messageText != null && FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS)) {
                reply.removeAttribute("messageID");
            }
            logger.warning("ServerAPI. " + message.getType() + " error," + " messageId: " + messageId + " message: " + messageText);
            this.client.handleReply(reply);
            return null;
        }
        if (tag == null || tag.equals(reply.getTagName())) {
            this.doClientProcessingFor(reply);
            if (results != null) {
                if (results.containsKey("*")) {
                    results.remove("*");
                    int len = reply.getAttributes().getLength();
                    for (int i = 0; i < len; ++i) {
                        Node n = reply.getAttributes().item(i);
                        results.put(n.getNodeName(), n.getNodeValue());
                    }
                } else {
                    for (String k : results.keySet()) {
                        if (!reply.hasAttribute(k)) continue;
                        results.put(k, reply.getAttribute(k));
                    }
                }
            }
            return reply;
        }
        if ("multiple".equals(reply.getTagName())) {
            ArrayList<Element> replies = new ArrayList<Element>();
            NodeList nodes = reply.getChildNodes();
            Element result = null;
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i) instanceof Element && ((Element)nodes.item(i)).getTagName().equals(tag)) {
                    result = (Element)nodes.item(i);
                    continue;
                }
                Element e = this.client.handleReply((Element)nodes.item(i));
                if (e == null) continue;
                replies.add(e);
            }
            this.resolve(DOMMessage.collapseElements(replies));
            return result;
        }
        String complaint = "Received reply with tag " + reply.getTagName() + " which should have been " + tag + " to message " + message;
        logger.warning(complaint);
        this.doRaiseErrorMessage(complaint);
        return null;
    }

    private boolean askHandling(DOMMessage message, String tag, HashMap<String, String> results) {
        Element reply = this.askExpecting(message, tag, results);
        if (reply == null) {
            return false;
        }
        this.resolve(this.client.handleReply(reply));
        return true;
    }

    private HashMap<String, String> loadMap(String ... queries) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String q : queries) {
            result.put(q, null);
        }
        return result;
    }

    public String getHost() {
        return this.client == null ? null : this.client.getHost();
    }

    public int getPort() {
        return this.client == null ? -1 : this.client.getPort();
    }

    public Connection getConnection() {
        return this.client == null ? null : this.client.getConnection();
    }

    public void registerMessageHandler(MessageHandler messageHandler) {
        if (this.client != null) {
            this.client.setMessageHandler(messageHandler);
        }
    }

    public void disconnect() {
        if (this.client != null) {
            this.client.disconnect();
            this.reset();
        }
    }

    public void reset() {
        this.client = null;
    }

    public boolean connect(String threadName, String host, int port, MessageHandler messageHandler) throws IOException {
        int tries;
        if (port < 0) {
            port = FreeCol.getServerPort();
            tries = 10;
        } else {
            tries = 1;
        }
        for (int i = tries; i > 0; --i) {
            try {
                this.client = new Client(host, port, messageHandler, threadName);
                if (this.client == null) continue;
                break;
            }
            catch (IOException e) {
                if (i > 1) continue;
                throw e;
            }
        }
        return this.client != null;
    }

    public boolean abandonColony(Colony colony) {
        return this.askHandling(new AbandonColonyMessage(colony), null, null);
    }

    public boolean answerMonarch(Monarch.MonarchAction action, boolean accept) {
        return this.askHandling(new MonarchActionMessage(action, null, "").setResult(accept), null, null);
    }

    public boolean askSkill(Unit unit, Map.Direction direction) {
        return this.askHandling(new AskSkillMessage(unit, direction), null, null);
    }

    public boolean assignTeacher(Unit student, Unit teacher) {
        return this.askHandling(new AssignTeacherMessage(student, teacher), null, null);
    }

    public boolean assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        return this.askHandling(new AssignTradeRouteMessage(unit, tradeRoute), null, null);
    }

    public boolean attack(Unit unit, Map.Direction direction) {
        return this.askHandling(new AttackMessage(unit, direction), null, null);
    }

    public boolean buildColony(String name, Unit unit) {
        return this.askHandling(new BuildColonyMessage(name, unit), null, null);
    }

    public boolean buyFromSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        return this.askHandling(new BuyMessage(unit, settlement, goods, gold), null, null);
    }

    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        HashMap<String, String> results = this.loadMap("gold");
        if (this.askHandling(new BuyPropositionMessage(unit, settlement, goods, gold), null, results)) {
            try {
                return Integer.parseInt(results.get("gold"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean cashInTreasureTrain(Unit unit) {
        return this.askHandling(new CashInTreasureTrainMessage(unit), null, null);
    }

    public boolean changeState(Unit unit, Unit.UnitState state) {
        return this.askHandling(new ChangeStateMessage(unit, state), null, null);
    }

    public boolean changeWorkImprovementType(Unit unit, TileImprovementType type) {
        return this.askHandling(new ChangeWorkImprovementTypeMessage(unit, type), null, null);
    }

    public boolean changeWorkType(Unit unit, GoodsType workType) {
        return this.askHandling(new ChangeWorkTypeMessage(unit, workType), null, null);
    }

    public boolean chat(Player player, String chat) {
        return this.send(new ChatMessage(player, chat, false));
    }

    public boolean chooseFoundingFather(List<FoundingFather> ffs, FoundingFather ff) {
        return this.send(new ChooseFoundingFatherMessage(ffs, ff));
    }

    public boolean claimTile(Tile tile, FreeColGameObject claimant, int price) {
        return this.askHandling(new ClaimLandMessage(tile, claimant, price), null, null);
    }

    public boolean clearSpeciality(Unit unit) {
        return this.askHandling(new ClearSpecialityMessage(unit), null, null);
    }

    public boolean closeTransactionSession(Unit unit, Settlement settlement) {
        return this.askHandling(new CloseTransactionMessage(unit, settlement), null, null);
    }

    public boolean continuePlaying() {
        return this.send(new TrivialMessage("continuePlaying", new String[0]));
    }

    public boolean declareIndependence(String nation, String country) {
        return this.askHandling(new DeclareIndependenceMessage(nation, country), null, null);
    }

    public boolean declineMounds(Unit unit, Map.Direction direction) {
        return this.askHandling(new DeclineMoundsMessage(unit, direction), null, null);
    }

    public boolean deliverGiftToSettlement(Unit unit, Settlement settlement, Goods goods) {
        return this.askHandling(new DeliverGiftMessage(unit, settlement, goods), null, null);
    }

    public boolean demandTribute(Unit unit, Map.Direction direction) {
        return this.askHandling(new DemandTributeMessage(unit, direction), null, null);
    }

    public DiplomaticTrade diplomacy(Game game, Unit ourUnit, Colony otherColony, DiplomaticTrade agreement) {
        Element reply = this.askExpecting(new DiplomacyMessage(ourUnit, otherColony, agreement), DiplomacyMessage.getXMLElementTagName(), null);
        if (reply == null) {
            return null;
        }
        if (DiplomacyMessage.getXMLElementTagName().equals(reply.getTagName())) {
            return new DiplomacyMessage(game, reply).getAgreement();
        }
        this.client.handleReply(reply);
        return null;
    }

    public DiplomaticTrade diplomacy(Game game, Unit ourUnit, Unit otherUnit, DiplomaticTrade agreement) {
        Element reply = this.askExpecting(new DiplomacyMessage(ourUnit, otherUnit, agreement), DiplomacyMessage.getXMLElementTagName(), null);
        if (reply == null) {
            return null;
        }
        if (DiplomacyMessage.getXMLElementTagName().equals(reply.getTagName())) {
            return new DiplomacyMessage(game, reply).getAgreement();
        }
        this.client.handleReply(reply);
        return null;
    }

    public DiplomaticTrade diplomacy(Game game, Colony ourColony, Unit otherUnit, DiplomaticTrade agreement) {
        Element reply = this.askExpecting(new DiplomacyMessage(ourColony, otherUnit, agreement), DiplomacyMessage.getXMLElementTagName(), null);
        if (reply == null) {
            return null;
        }
        if (DiplomacyMessage.getXMLElementTagName().equals(reply.getTagName())) {
            return new DiplomacyMessage(game, reply).getAgreement();
        }
        this.client.handleReply(reply);
        return null;
    }

    public boolean disbandUnit(Unit unit) {
        return this.askHandling(new DisbandUnitMessage(unit), null, null);
    }

    public boolean disembark(Unit unit) {
        return this.askHandling(new DisembarkMessage(unit), null, null);
    }

    public boolean embark(Unit unit, Unit carrier, Map.Direction direction) {
        return this.askHandling(new EmbarkMessage(unit, carrier, direction), null, null);
    }

    public boolean emigrate(int slot) {
        return this.askHandling(new EmigrateUnitMessage(slot), null, null);
    }

    public boolean endTurn() {
        return this.askHandling(new TrivialMessage("endTurn", new String[0]), null, null);
    }

    public boolean enterRevengeMode() {
        return this.askHandling(new TrivialMessage("enterRevengeMode", new String[0]), null, null);
    }

    public boolean equipUnitForRole(Unit unit, Role role, int roleCount) {
        return this.askHandling(new EquipForRoleMessage(unit, role, roleCount), null, null);
    }

    public boolean firstContact(Player player, Player other, Tile tile, boolean result) {
        return this.askHandling(new FirstContactMessage(player, other, tile).setResult(result), null, null);
    }

    public List<Goods> getGoodsForSaleInSettlement(Game game, Unit unit, Settlement settlement) {
        GoodsForSaleMessage message = new GoodsForSaleMessage(unit, settlement, null);
        Element reply = this.askExpecting(message, GoodsForSaleMessage.getXMLElementTagName(), null);
        return reply == null ? Collections.emptyList() : new GoodsForSaleMessage(game, reply).getGoods();
    }

    public List<HighScore> getHighScores() {
        Element reply = this.askExpecting(new TrivialMessage("getHighScores", new String[0]), null, null);
        if (reply == null) {
            return Collections.emptyList();
        }
        ArrayList<HighScore> result = new ArrayList<HighScore>();
        NodeList childElements = reply.getChildNodes();
        for (int i = 0; i < childElements.getLength(); ++i) {
            result.add(new HighScore((Element)childElements.item(i)));
        }
        return result;
    }

    public NationSummary getNationSummary(Player player) {
        GetNationSummaryMessage message = new GetNationSummaryMessage(player);
        Element reply = this.askExpecting(message, GetNationSummaryMessage.getXMLElementTagName(), null);
        if (reply == null) {
            return null;
        }
        return new GetNationSummaryMessage(reply).getNationSummary();
    }

    public boolean getNewTradeRoute() {
        return this.askHandling(new TrivialMessage("getNewTradeRoute", new String[0]), null, null);
    }

    public List<AbstractUnit> getREFUnits() {
        Element reply = this.askExpecting(new TrivialMessage("getREFUnits", new String[0]), null, null);
        if (reply == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>();
        NodeList childElements = reply.getChildNodes();
        for (int index = 0; index < childElements.getLength(); ++index) {
            AbstractUnit unit = new AbstractUnit();
            unit.readFromXMLElement((Element)childElements.item(index));
            result.add(unit);
        }
        return result;
    }

    public Map<String, String> getStatistics() {
        HashMap<String, String> results = this.loadMap("*");
        return this.askExpecting(new TrivialMessage("getStatistics", new String[0]), "statistics", results) == null ? null : results;
    }

    public int incite(Unit unit, Map.Direction direction, Player enemy, int gold) {
        HashMap<String, String> results = this.loadMap("gold");
        if (!this.askHandling(new InciteMessage(unit, direction, enemy, gold), null, results)) {
            return -1;
        }
        try {
            return Integer.parseInt(results.get("gold"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean joinColony(Unit unit, Colony colony) {
        return this.askHandling(new JoinColonyMessage(colony, unit), null, null);
    }

    public boolean learnSkill(Unit unit, Map.Direction direction) {
        return this.askHandling(new LearnSkillMessage(unit, direction), null, null);
    }

    public boolean loadGoods(GoodsType type, int amount, Unit carrier) {
        return this.askHandling(new LoadGoodsMessage(type, amount, carrier), null, null);
    }

    public LoginMessage login(String userName, String version) {
        Element reply = this.askExpecting(new TrivialMessage("login", "userName", userName, "version", version), "login", null);
        return reply == null ? null : new LoginMessage(null, reply);
    }

    public boolean logout() {
        return this.sendAndWait(new TrivialMessage("logout", "reason", "User has quit the client."));
    }

    public boolean loot(Unit winner, String defenderId, List<Goods> goods) {
        return this.askHandling(new LootCargoMessage(winner, defenderId, goods), null, null);
    }

    public boolean missionary(Unit unit, Map.Direction direction, boolean denounce) {
        return this.askHandling(new MissionaryMessage(unit, direction, denounce), null, null);
    }

    public boolean move(Unit unit, Map.Direction direction) {
        return this.askHandling(new MoveMessage(unit, direction), null, null);
    }

    public boolean moveTo(Unit unit, Location destination) {
        return this.askHandling(new MoveToMessage(unit, destination), null, null);
    }

    public boolean newLandName(Unit unit, String name) {
        return this.askHandling(new NewLandNameMessage(unit, name), null, null);
    }

    public boolean newRegionName(Region region, Tile tile, Unit unit, String name) {
        return this.askHandling(new NewRegionNameMessage(region, tile, unit, name), null, null);
    }

    public boolean[] openTransactionSession(Unit unit, Settlement settlement) {
        HashMap<String, String> results = this.loadMap("canBuy", "canSell", "canGift");
        if (this.askExpecting(new GetTransactionMessage(unit, settlement), null, results) == null || results.get("canBuy") == null || results.get("canSell") == null || results.get("canGift") == null) {
            return null;
        }
        return new boolean[]{Boolean.parseBoolean(results.get("canBuy")), Boolean.parseBoolean(results.get("canSell")), Boolean.parseBoolean(results.get("canGift"))};
    }

    public boolean payArrears(GoodsType type) {
        return this.askHandling(new PayArrearsMessage(type), null, null);
    }

    public boolean payForBuilding(Colony colony) {
        return this.askHandling(new PayForBuildingMessage(colony), null, null);
    }

    public boolean putOutsideColony(Unit unit) {
        return this.askHandling(new PutOutsideColonyMessage(unit), null, null);
    }

    public boolean rename(FreeColGameObject object, String name) {
        return this.askHandling(new RenameMessage(object, name), null, null);
    }

    public boolean requestLaunch() {
        return this.send(new TrivialMessage("requestLaunch", new String[0]));
    }

    public boolean retire() {
        return this.askHandling(new TrivialMessage("retire", new String[0]), null, null);
    }

    public String scoutSettlement(Unit unit, Map.Direction direction) {
        HashMap<String, String> results = this.loadMap("settlements");
        return this.askHandling(new ScoutIndianSettlementMessage(unit, direction), null, results) ? results.get("settlements") : null;
    }

    public String scoutSpeakToChief(Unit unit, Map.Direction direction) {
        HashMap<String, String> results = this.loadMap("result");
        return this.askHandling(new ScoutSpeakToChiefMessage(unit, direction), null, results) ? results.get("result") : null;
    }

    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        HashMap<String, String> results = this.loadMap("gold");
        if (this.askHandling(new SellPropositionMessage(unit, settlement, goods, gold), null, results)) {
            try {
                return Integer.parseInt(results.get("gold"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean sellToSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        return this.askHandling(new SellMessage(unit, settlement, goods, gold), null, null);
    }

    public boolean setAvailable(Nation nation, NationOptions.NationState state) {
        return this.askHandling(new TrivialMessage("setAvailable", "nation", nation.getId(), "state", state.toString()), null, null);
    }

    public boolean setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        return this.askHandling(new SetBuildQueueMessage(colony, buildQueue), null, null);
    }

    public boolean setColor(Nation nation, Color color) {
        return this.askHandling(new TrivialMessage("setColor", "nation", nation.getId(), "color", Integer.toString(color.getRGB())), null, null);
    }

    public boolean setCurrentStop(Unit unit, int index) {
        return this.askHandling(new SetCurrentStopMessage(unit, index), null, null);
    }

    public boolean setDestination(Unit unit, Location destination) {
        return this.askHandling(new SetDestinationMessage(unit, destination), null, null);
    }

    public boolean setGoodsLevels(Colony colony, ExportData data) {
        return this.askHandling(new SetGoodsLevelsMessage(colony, data), null, null);
    }

    public boolean setNation(Nation nation) {
        return this.askHandling(new TrivialMessage("setNation", "value", nation.getId()), null, null);
    }

    public boolean setNationType(NationType nationType) {
        return this.askHandling(new TrivialMessage("setNationType", "value", nationType.getId()), null, null);
    }

    public boolean setReady(boolean ready) {
        return this.send(new TrivialMessage("ready", "value", Boolean.toString(ready)));
    }

    public boolean setTradeRoutes(List<TradeRoute> routes) {
        return this.askHandling(new SetTradeRoutesMessage(routes), null, null);
    }

    public boolean spy(Unit unit, Map.Direction direction) {
        return this.askHandling(new SpySettlementMessage(unit, direction), null, null);
    }

    public boolean startSkipping() {
        return this.send(new TrivialMessage("endTurn", new String[0]));
    }

    public boolean trainUnitInEurope(UnitType type) {
        return this.askHandling(new TrainUnitInEuropeMessage(type), null, null);
    }

    public boolean unloadGoods(GoodsType type, int amount, Unit carrier) {
        return this.askHandling(new UnloadGoodsMessage(type, amount, carrier), null, null);
    }

    public boolean updateGameOptions(OptionGroup gameOptions) {
        Element up = DOMMessage.createMessage("updateGameOptions", new String[0]);
        up.appendChild(gameOptions.toXMLElement(up.getOwnerDocument()));
        return this.send(up);
    }

    public boolean updateMapGeneratorOptions(OptionGroup mapOptions) {
        Element up = DOMMessage.createMessage("updateMapGeneratorOptions", new String[0]);
        up.appendChild(mapOptions.toXMLElement(up.getOwnerDocument()));
        return this.send(up);
    }

    public boolean updateTradeRoute(TradeRoute route) {
        return this.askHandling(new UpdateTradeRouteMessage(route), null, null);
    }

    public boolean work(Unit unit, WorkLocation workLocation) {
        return this.askHandling(new WorkMessage(unit, workLocation), null, null);
    }
}

