/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class RenameMessage
extends DOMMessage {
    private String id;
    private String newName;

    public RenameMessage(FreeColGameObject object, String newName) {
        super(RenameMessage.getXMLElementTagName());
        this.id = object.getId();
        this.newName = newName;
    }

    public RenameMessage(Game game, Element element) {
        super(RenameMessage.getXMLElementTagName());
        this.id = element.getAttribute("nameable");
        this.newName = element.getAttribute("name");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        FreeColGameObject fcgo;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            fcgo = player.getOurFreeColGameObject(this.id, FreeColGameObject.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!(fcgo instanceof Nameable)) {
            return DOMMessage.clientError("Not a nameable: " + this.id);
        }
        return server.getInGameController().renameObject(serverPlayer, (Nameable)((Object)fcgo), this.newName);
    }

    @Override
    public Element toXMLElement() {
        return RenameMessage.createMessage(RenameMessage.getXMLElementTagName(), "nameable", this.id, "name", this.newName);
    }

    public static String getXMLElementTagName() {
        return "rename";
    }
}

