/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class EquipForRoleMessage
extends DOMMessage {
    private String unitId;
    private String roleId;
    private String roleCount;

    public EquipForRoleMessage(Unit unit, Role role, int roleCount) {
        super(EquipForRoleMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.roleId = role.getId();
        this.roleCount = String.valueOf(roleCount);
    }

    public EquipForRoleMessage(Game game, Element element) {
        super(EquipForRoleMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.roleId = element.getAttribute("role");
        this.roleCount = element.getAttribute("count");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int count;
        Role role;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.isInEurope()) {
            if (!unit.hasTile()) {
                return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
            }
            if (unit.getSettlement() == null) {
                return DOMMessage.clientError("Unit is not in a settlement: " + this.unitId);
            }
        }
        if ((role = game.getSpecification().getRole(this.roleId)) == null) {
            return DOMMessage.clientError("Not a role: " + this.roleId);
        }
        try {
            count = Integer.parseInt(this.roleCount);
        }
        catch (NumberFormatException nfe) {
            return DOMMessage.clientError("Role count is not an integer: " + this.roleCount);
        }
        if (count < 0 || count > role.getMaximumCount()) {
            return DOMMessage.clientError("Invalid role count: " + this.roleCount);
        }
        return server.getInGameController().equipForRole(serverPlayer, unit, role, count);
    }

    @Override
    public Element toXMLElement() {
        return EquipForRoleMessage.createMessage(EquipForRoleMessage.getXMLElementTagName(), "unit", this.unitId, "role", this.roleId, "count", this.roleCount);
    }

    public static String getXMLElementTagName() {
        return "equipForRole";
    }
}

