/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class EmigrateUnitMessage
extends DOMMessage {
    private String slotString;

    public EmigrateUnitMessage(int slot) {
        super(EmigrateUnitMessage.getXMLElementTagName());
        this.slotString = Integer.toString(slot);
    }

    public EmigrateUnitMessage(Game game, Element element) {
        super(EmigrateUnitMessage.getXMLElementTagName());
        this.slotString = element.getAttribute("slot");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Europe.MigrationType type;
        int slot;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Europe europe = player.getEurope();
        if (europe == null) {
            return DOMMessage.clientError("No Europe to migrate from.");
        }
        try {
            slot = Integer.parseInt(this.slotString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad slot: " + this.slotString);
        }
        if (!Europe.MigrationType.validMigrantSlot(slot)) {
            return DOMMessage.clientError("Invalid slot for recruitment: " + slot);
        }
        if (serverPlayer.getRemainingEmigrants() > 0) {
            if (Europe.MigrationType.unspecificMigrantSlot(slot)) {
                return DOMMessage.clientError("Specific slot expected for FoY migration.");
            }
            type = Europe.MigrationType.FOUNTAIN;
        } else if (player.checkEmigrate()) {
            if (Europe.MigrationType.specificMigrantSlot(slot) && !player.hasAbility("model.ability.selectRecruit")) {
                return DOMMessage.clientError("selectRecruit ability absent.");
            }
            type = Europe.MigrationType.NORMAL;
        } else {
            if (!player.checkGold(europe.getRecruitPrice())) {
                return DOMMessage.clientError("No migrants available at cost " + europe.getRecruitPrice() + " for player with " + player.getGold() + " gold.");
            }
            type = Europe.MigrationType.RECRUIT;
        }
        return server.getInGameController().emigrate(serverPlayer, slot, type);
    }

    @Override
    public Element toXMLElement() {
        return EmigrateUnitMessage.createMessage(EmigrateUnitMessage.getXMLElementTagName(), "slot", this.slotString);
    }

    public static String getXMLElementTagName() {
        return "emigrateUnit";
    }
}

