/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import org.w3c.dom.Element;

public class DisembarkMessage
extends DOMMessage {
    private String unitId;

    public DisembarkMessage(Unit unit) {
        super(DisembarkMessage.getXMLElementTagName());
        this.unitId = unit.getId();
    }

    public DisembarkMessage(Game game, Element element) {
        super(DisembarkMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerUnit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, ServerUnit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().disembarkUnit(serverPlayer, unit);
    }

    @Override
    public Element toXMLElement() {
        return DisembarkMessage.createMessage(DisembarkMessage.getXMLElementTagName(), "unit", this.unitId);
    }

    public static String getXMLElementTagName() {
        return "disembark";
    }
}

