/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class DemandTributeMessage
extends DOMMessage {
    private String unitId;
    private String directionString;

    public DemandTributeMessage(Unit unit, Map.Direction direction) {
        super(DemandTributeMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public DemandTributeMessage(Game game, Element element) {
        super(DemandTributeMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Tile tile;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.isArmed() && !unit.hasAbility("model.ability.demandTribute")) {
            return DOMMessage.clientError("Unit is neither armed nor able to demand tribute: " + this.unitId);
        }
        try {
            tile = unit.getNeighbourTile(this.directionString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        ServerIndianSettlement settlement = (ServerIndianSettlement)tile.getIndianSettlement();
        if (settlement == null) {
            return DOMMessage.clientError("There is native settlement at: " + tile.getId());
        }
        Unit.MoveType type = unit.getMoveType(tile);
        if (type != Unit.MoveType.ATTACK_SETTLEMENT && type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT) {
            return DOMMessage.clientError("Unable to demand tribute at: " + settlement.getName() + ": " + type.whyIllegal());
        }
        return server.getInGameController().demandTribute(serverPlayer, unit, settlement);
    }

    @Override
    public Element toXMLElement() {
        return DemandTributeMessage.createMessage(DemandTributeMessage.getXMLElementTagName(), "unit", this.unitId, "direction", this.directionString);
    }

    public static String getXMLElementTagName() {
        return "demandTribute";
    }
}

