/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class DeclareIndependenceMessage
extends DOMMessage {
    private String nationName;
    private String countryName;

    public DeclareIndependenceMessage(String nationName, String countryName) {
        super(DeclareIndependenceMessage.getXMLElementTagName());
        this.nationName = nationName;
        this.countryName = countryName;
    }

    public DeclareIndependenceMessage(Game game, Element element) {
        super(DeclareIndependenceMessage.getXMLElementTagName());
        this.nationName = element.getAttribute("nationName");
        this.countryName = element.getAttribute("countryName");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        if (this.nationName == null || this.nationName.isEmpty() || this.countryName == null || this.countryName.isEmpty()) {
            return DOMMessage.clientError("Empty nation or country name.");
        }
        StringTemplate problem = player.checkDeclareIndependence();
        if (problem != null) {
            return DOMMessage.clientError("Declaration blocked");
        }
        return server.getInGameController().declareIndependence(serverPlayer, this.nationName, this.countryName);
    }

    @Override
    public Element toXMLElement() {
        return DeclareIndependenceMessage.createMessage(DeclareIndependenceMessage.getXMLElementTagName(), "nationName", this.nationName, "countryName", this.countryName);
    }

    public static String getXMLElementTagName() {
        return "declareIndependence";
    }
}

