/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.NetworkReplyObject;
import net.sf.freecol.common.networking.ReceivingThread;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Connection
implements Closeable {
    private static final Logger logger = Logger.getLogger(Connection.class.getName());
    public static final String DISCONNECT_TAG = "disconnect";
    public static final String NETWORK_REPLY_ID_TAG = "networkReplyId";
    public static final String QUESTION_TAG = "question";
    public static final String REPLY_TAG = "reply";
    private static final int TIMEOUT = 5000;
    private InputStream in = null;
    private Socket socket = null;
    private OutputStream out = null;
    private Transformer xmlTransformer = null;
    private ReceivingThread thread = null;
    private MessageHandler messageHandler = null;
    private String name;
    protected static final boolean dump = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS);

    protected Connection(String name) {
        this.name = name;
    }

    public Connection(String host, int port, MessageHandler messageHandler, String name) throws IOException {
        this(Connection.createSocket(host, port), messageHandler, name);
    }

    public Connection(Socket socket, MessageHandler messageHandler, String name) throws IOException {
        this(name);
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        Transformer myTransformer = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            myTransformer = factory.newTransformer();
            myTransformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerException e) {
            logger.log(Level.WARNING, "Failed to install transformer!", e);
        }
        this.xmlTransformer = myTransformer;
        this.thread = new ReceivingThread(this, this.in, name);
        this.messageHandler = messageHandler;
        this.name = name;
        this.thread.start();
    }

    private static Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        InetSocketAddress addr = new InetSocketAddress(host, port);
        socket.connect(addr, 5000);
        return socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setMessageHandler(MessageHandler mh) {
        this.messageHandler = mh;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.send(DOMMessage.createMessage(DISCONNECT_TAG, new String[0]));
            }
            catch (IOException ioe) {
                logger.fine("Error disconnecting " + this.name + ": " + ioe.getMessage());
            }
            finally {
                this.reallyClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reallyClose() {
        if (this.thread != null) {
            this.thread.askToStop();
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Error closing output", ioe);
            }
            finally {
                this.out = null;
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Error closing input", ioe);
            }
            finally {
                this.in = null;
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Error closing socket", ioe);
            }
            finally {
                this.socket = null;
            }
        }
        logger.fine("Connection really closed for " + this.name);
    }

    private void transform(DOMSource source, OutputStream out) throws IOException {
        try {
            this.xmlTransformer.transform(source, new StreamResult(out));
            out.write(10);
        }
        catch (TransformerException te) {
            logger.log(Level.WARNING, "Failed to transform", te);
        }
        if (dump) {
            try {
                System.err.println(this.getName());
                this.xmlTransformer.transform(source, new StreamResult(System.err));
                System.err.write(10);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInternal(Element element) throws IOException {
        DOMSource src = new DOMSource(element);
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.transform(src, this.out);
            this.out.flush();
            this.out.notifyAll();
        }
    }

    private Element askInternal(Element element) throws IOException {
        int networkReplyId = this.thread.getNextNetworkReplyId();
        String tag = element.getTagName();
        if (Thread.currentThread() == this.thread) {
            throw new IOException("wait(ReceivingThread) for: " + tag);
        }
        Element question = element.getOwnerDocument().createElement(QUESTION_TAG);
        question.setAttribute(NETWORK_REPLY_ID_TAG, Integer.toString(networkReplyId));
        question.appendChild(element);
        NetworkReplyObject nro = this.thread.waitForNetworkReply(networkReplyId);
        this.sendInternal(question);
        DOMMessage response = (DOMMessage)nro.getResponse();
        Element reply = response == null ? null : response.getDocument().getDocumentElement();
        Element child = reply == null ? null : (Element)reply.getFirstChild();
        return child;
    }

    public void send(Element element) throws IOException {
        this.sendInternal(element);
        logger.fine("Send: " + element.getTagName());
    }

    public void sendAndWait(Element element) throws IOException {
        this.askInternal(element);
        logger.fine("SendAndWait: " + element.getTagName());
    }

    public Element ask(Element element) throws IOException {
        Element reply = this.askInternal(element);
        logger.fine("Ask: " + element.getTagName() + ", reply: " + (reply == null ? "null" : reply.getTagName()));
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAndSendReply(BufferedInputStream in) throws IOException {
        DOMMessage msg;
        String networkReplyId;
        boolean question;
        in.mark(200);
        FreeColXMLReader xr = null;
        try {
            xr = new FreeColXMLReader(in);
            xr.nextTag();
            question = QUESTION_TAG.equals(xr.getLocalName());
            networkReplyId = xr.getAttribute(NETWORK_REPLY_ID_TAG, null);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "XML stream failure", xse);
            return;
        }
        in.reset();
        try {
            msg = new DOMMessage(in);
        }
        catch (SAXException e) {
            logger.log(Level.WARNING, "Unable to read message.", e);
            return;
        }
        finally {
            if (xr != null) {
                xr.close();
            }
        }
        final Connection conn = this;
        Thread t = new Thread(msg.getType()){

            @Override
            public void run() {
                Element element = msg.getDocument().getDocumentElement();
                try {
                    Element reply;
                    if (question) {
                        reply = (Element)element.getFirstChild();
                        if ((reply = conn.handle(reply)) == null) {
                            reply = DOMMessage.createMessage(Connection.REPLY_TAG, Connection.NETWORK_REPLY_ID_TAG, networkReplyId);
                        } else {
                            Element header = reply.getOwnerDocument().createElement(Connection.REPLY_TAG);
                            header.setAttribute(Connection.NETWORK_REPLY_ID_TAG, networkReplyId);
                            header.appendChild(reply);
                            reply = header;
                        }
                    } else {
                        reply = conn.handle(element);
                    }
                    if (reply != null) {
                        conn.send(reply);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Handler failed: " + element, e);
                }
            }
        };
        t.setName(this.name + "-MessageHandler-" + t.getName());
        t.start();
    }

    public Element handle(Element request) throws FreeColException {
        return this.messageHandler.handle(this, request);
    }

    public String toString() {
        return "[Connection " + this.name + " (" + this.socket + ")]";
    }
}

